<?php

namespace App\Controllers;


class RegistroComisiones extends BaseController
{

	public function index(){  
		$session = \Config\Services::session();	
		if(empty($session->get('fullName')) && empty($session->get('referenceId')) ){
            return redirect()->to(base_url());
        }
        
		$opciones = array('http' =>
			array(
				'method'  => 'GET',
				'header'  => 'Content-type: application/x-www-form-urlencoded'
			)
		);

		$contexto = stream_context_create($opciones);
		$resultado = file_get_contents($this->url_api_conciliacion.'banco', false, $contexto);
		$resultado_banco=json_decode($resultado,true); 

		$opciones = array('http' =>
			array(
				'method'  => 'POST',
				'header'  => 'Content-type: application/x-www-form-urlencoded'
			)
		);

		$contexto = stream_context_create($opciones);
		$resultado = file_get_contents($this->url_api_conciliacion.'tipopagoindex', false, $contexto);
		$resultado_tipo_pago=json_decode($resultado,true); 

		$opciones = array('http' =>
			array(
				'method'  => 'POST',
				'header'  => 'Content-type: application/x-www-form-urlencoded'
			)
		);

		$contexto = stream_context_create($opciones);
		$resultado = file_get_contents($this->url_api_conciliacion.'bancopagadorindex', false, $contexto);
		$resultado_banco_pagador=json_decode($resultado,true); 

		$opciones = array('http' =>
			array(
				'method'  => 'POST',
				'header'  => 'Content-type: application/x-www-form-urlencoded'
			)
		);

		$contexto = stream_context_create($opciones);
		$resultado = file_get_contents($this->url_api_conciliacion.'relacionbancotipopagoindex', false, $contexto);
		$resultado_relacion_banco_tipo_pago=json_decode($resultado,true);

		$datos=array(
			'resultado_relacion_banco_tipo_pago'=>!empty($resultado_relacion_banco_tipo_pago['data'])?$resultado_relacion_banco_tipo_pago['data']:[],
			'resultado_banco'=>!empty($resultado_banco['data'])?$resultado_banco['data']:[],
			'resultado_tipo_pago'=>!empty($resultado_tipo_pago['data'])?$resultado_tipo_pago['data']:[],
			'resultado_banco_pagador'=>!empty($resultado_banco_pagador['data'])?$resultado_banco_pagador['data']:[],
		);
		echo view("layouts/header");
		echo view("layouts/aside");
		echo view("registrocomisiones/vistaregistrocomisiones",$datos);
		echo view("layouts/footer");
		
	}

	

	public function add(){
		$session = \Config\Services::session();	
		if(empty($session->get('fullName')) && empty($session->get('referenceId')) ){
            return redirect()->to(base_url());
        }
		

		$bap_id=$this->request->getPost('bapid');
		$ban_codigo_banco =$this->request->getPost('bancoid');
		$tac_codigo=$this->request->getPost('taccodigo');
		$tip_id=$this->request->getPost('tipid');
		$rbt_meses_gracia=$this->request->getPost('mesesgracia');
		$rbt_numero_cuotas=$this->request->getPost('numerocuotas');
		$rbt_porcentaje_comision=$this->request->getPost('porcentajecomision');
		$rbt_frecuencia_pago=$this->request->getPost('frecuenciapago');
		$rbt_fecha_creacion=date("Y-m-d");
		$rbt_id_usuario=$session->get('referenceId');
		$rbt_nombre_usuario=$session->get('fullName');
		$rbt_estado='1';
		$rbt_fecha_contable=$this->request->getPost('fechacontable');
		$rbt_fecha_modificacion='0000-00-00';
		$rbt_id_usuario_modificacion =0;
		$rbt_nombre_usuario_modificacion='';

		if($rbt_meses_gracia!=0){
			$rbt_porcentaje_comision=3.50;
		}
		

		if(!empty($this->request->getPost('fechaferiadodesde')) && !empty($this->request->getPost('fechaferiadohasta')) && !empty($this->request->getPost('porentajecomisionferiado'))){
			$rbt_fecha_desde=$this->request->getPost('fechaferiadodesde');
			$rbt_fecha_hasta=$this->request->getPost('fechaferiadohasta');
			$rbt_porcentaje_feriado=$this->request->getPost('porentajecomisionferiado');
		}else{
			$rbt_fecha_desde='0000-00-00';
			$rbt_fecha_hasta='0000-00-00';
			$rbt_porcentaje_feriado=0;
		}

		

		$datos_post = http_build_query(
			array(
				"bap_id"=> $bap_id ,
				"ban_codigo_banco"=> $ban_codigo_banco ,
				"tac_codigo"=> $tac_codigo ,
				"tip_id"=> $tip_id ,
				"rbt_meses_gracia"=> $rbt_meses_gracia ,
				"rbt_numero_cuotas"=> $rbt_numero_cuotas ,
				"rbt_porcentaje_comision"=> $rbt_porcentaje_comision ,
				"rbt_frecuencia_pago"=> $rbt_frecuencia_pago ,
				"rbt_fecha_creacion"=> $rbt_fecha_creacion ,
				"rbt_id_usuario"=> $rbt_id_usuario ,
				"rbt_nombre_usuario"=>$rbt_nombre_usuario,
				"rbt_fecha_contable"=> $rbt_fecha_contable ,
				"rbt_fecha_modificacion"=> $rbt_fecha_modificacion ,
				"rbt_id_usuario_modificacion"=> $rbt_id_usuario_modificacion ,
				"rbt_estado"=> $rbt_estado ,
				"rbt_nombre_usuario_modificacion"=>$rbt_nombre_usuario_modificacion,

				"rbt_fecha_desde"=> $rbt_fecha_desde ,
                "rbt_fecha_hasta"=> $rbt_fecha_hasta ,
                "rbt_porcentaje_feriado"=> $rbt_porcentaje_feriado ,
			)
		);

		$opciones = array('http' =>
			array(
				'method'  => 'POST',
				'header'  => 'Content-type: application/x-www-form-urlencoded',
				'content' => $datos_post
			)
		);

		$contexto = stream_context_create($opciones);
		$resultado = file_get_contents($this->url_api_conciliacion.'relacionbancotipopagocrear', false, $contexto);
		$resultado=json_decode($resultado,true);  


		if(!empty($resultado)){
			if($resultado['code'] ==200){
				$session->setFlashdata('mensaje_bueno', 'Agregado con exito');
				return redirect()->to(base_url('RegistroComisiones')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Fallo, al momento de agregar');
				return redirect()->to(base_url('RegistroComisiones')); 
			}

		}else{
			$session->setFlashdata('mensaje_malo', 'respuesta nula');
			return redirect()->to(base_url('RegistroComisiones')); 
		}      

	}


	

	public function edit(){
		$session = \Config\Services::session();

		if(empty($session->get('fullName')) && empty($session->get('referenceId')) ){
            return redirect()->to(base_url());
        }

		$rbt_id=$this->request->getPost('editrbtid');
		$bap_id=$this->request->getPost('editbapid');
		$ban_codigo_banco =$this->request->getPost('editbancoid');
		$tac_codigo=$this->request->getPost('edittaccodigo');
		$tip_id=$this->request->getPost('edittipid');
		$rbt_meses_gracia=$this->request->getPost('editmesesgracia');
		$rbt_numero_cuotas=$this->request->getPost('editnumerocuotas');
		$rbt_porcentaje_comision=$this->request->getPost('editporcentajecomision');
		$rbt_frecuencia_pago=$this->request->getPost('editfrecuenciapago');
		
		$rbt_id_usuario='';
		$rbt_nombre_usuario='';
		$rbt_estado='1';
		$rbt_fecha_contable=$this->request->getPost('editfechacontable');
		$rbt_fecha_modificacion=date("Y-m-d");
		$rbt_id_usuario_modificacion =$session->get('referenceId');
		$rbt_nombre_usuario_modificacion=$session->get('fullName');

		if($rbt_meses_gracia!=0){
			$rbt_porcentaje_comision=3.50;
		}

		if(!empty($this->request->getPost('editfechaferiadodesde')) && !empty($this->request->getPost('editfechaferiadohasta')) && !empty($this->request->getPost('editporentajecomisionferiado'))){
			$rbt_fecha_desde=$this->request->getPost('editfechaferiadodesde');
			$rbt_fecha_hasta=$this->request->getPost('editfechaferiadohasta');
			$rbt_porcentaje_feriado=$this->request->getPost('editporentajecomisionferiado');

		}else{
			$rbt_fecha_desde='0000-00-00';
			$rbt_fecha_hasta='0000-00-00';
			$rbt_porcentaje_feriado=0;
		}

		


		$datos_post = http_build_query(
			array(
				"rbt_id"=> $rbt_id ,
				"bap_id"=> $bap_id ,
				"ban_codigo_banco"=> $ban_codigo_banco ,
				"tac_codigo"=> $tac_codigo ,
				"tip_id"=> $tip_id ,
				"rbt_meses_gracia"=> $rbt_meses_gracia ,
				"rbt_numero_cuotas"=> $rbt_numero_cuotas ,
				"rbt_porcentaje_comision"=> $rbt_porcentaje_comision ,
				"rbt_frecuencia_pago"=> $rbt_frecuencia_pago ,
				
				"rbt_id_usuario"=> $rbt_id_usuario ,
				"rbt_nombre_usuario"=>$rbt_nombre_usuario,
				"rbt_fecha_contable"=> $rbt_fecha_contable ,
				"rbt_fecha_modificacion"=> $rbt_fecha_modificacion ,
				"rbt_id_usuario_modificacion"=> $rbt_id_usuario_modificacion ,
				"rbt_nombre_usuario_modificacion"=>$rbt_nombre_usuario_modificacion,
				"rbt_estado"=> $rbt_estado ,

				"rbt_fecha_desde"=> $rbt_fecha_desde ,
                "rbt_fecha_hasta"=> $rbt_fecha_hasta ,
                "rbt_porcentaje_feriado"=> $rbt_porcentaje_feriado ,
			)
		);

		$opciones = array('http' =>
			array(
				'method'  => 'POST',
				'header'  => 'Content-type: application/x-www-form-urlencoded',
				'content' => $datos_post
			)
		);

		$contexto = stream_context_create($opciones);
		$resultado = file_get_contents($this->url_api_conciliacion.'relacionbancotipopagoactualizar', false, $contexto);
		$resultado=json_decode($resultado,true);
		if(!empty($resultado)){
			if($resultado['code'] ==200){
				$session->setFlashdata('mensaje_bueno', 'Editado con exito');
				return redirect()->to(base_url('RegistroComisiones')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Fallo, al momento de editar');
				return redirect()->to(base_url('RegistroComisiones')); 
			}

		}else{
			$session->setFlashdata('mensaje_malo', 'respuesta nula');
			return redirect()->to(base_url('RegistroComisiones')); 
		}     
	}
	public function eliminar($id){
		$session = \Config\Services::session();
		$datos_post = http_build_query(
			array(
				"rbt_id"=> $id ,				
			)
		);

		$opciones = array('http' =>
			array(
				'method'  => 'POST',
				'header'  => 'Content-type: application/x-www-form-urlencoded',
				'content' => $datos_post
			)
		);

		$contexto = stream_context_create($opciones);
		$resultado = file_get_contents($this->url_api_conciliacion.'relacionbancotipopagoeliminar', false, $contexto);
		$resultado=json_decode($resultado,true);
		if(!empty($resultado)){
			if($resultado['code'] ==200){
				$session->setFlashdata('mensaje_bueno', 'Eliminado con exito');
				return redirect()->to(base_url('registrocomisiones')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Fallo, al momento de eliminar');
				return redirect()->to(base_url('registrocomisiones')); 
			}

		}else{
			$session->setFlashdata('mensaje_malo', 'respuesta nula');
			return redirect()->to(base_url('registrocomisiones')); 
		}     
	}
}