<script>
    var baseUrl = "<?= base_url(); ?>";

    function activarDescuento(element) {
        event.preventDefault(); // Evita la redirección

        let dem_id = element.getAttribute("data-dem-id");
        let usu_id = element.getAttribute("data-usu-id");

        // Verifica si las variables tienen valores válidos
        if (!dem_id || !usu_id) {
            alert("Error: Datos inválidos.");
            return;
        }

        // Llamada AJAX para enviar los datos al servidor
        $.ajax({
            url: baseUrl + "/Rolmenu/activarDescuento", // Usa la variable baseUrl definida en el HTML
            type: "POST",
            data: { dem_id: dem_id, USU_ID: usu_id },
            dataType: "json",
            success: function (response) {
                if (response.success) {
                    // Reemplaza el enlace con su versión desactivada
                    element.outerHTML = `
                        <a href="#" class="inactivar-descuento" 
                            data-dem-id="${dem_id}" 
                            data-usu-id="${usu_id}" 
                            onclick="inactivarDescuento(this)">
                            <div class="text-success">ACTIVO</div>
                        </a>`;
                } else {
                    alert("No se pudo activar el descuento.");
                }
            },
            error: function (xhr, status, error) {
                console.error("Error en la solicitud AJAX:", xhr.responseText);
                alert("Error en la solicitud. Verifica la consola para más detalles.");
            }
        });
    }

    function inactivarDescuento(element) {
        event.preventDefault(); // Evita la redirección

        let dem_id = element.getAttribute("data-dem-id");
        let usu_id = element.getAttribute("data-usu-id");

        // Verifica si las variables tienen valores válidos
        if (!dem_id || !usu_id) {
            alert("Error: Datos inválidos.");
            return;
        }

        // Llamada AJAX para enviar los datos al servidor
        $.ajax({
            url: baseUrl + "/Rolmenu/inactivarDescuento", // Usa la variable baseUrl definida en el HTML
            type: "POST",
            data: { dem_id: dem_id, USU_ID: usu_id },
            dataType: "json",
            success: function (response) {
                if (response.success) {
                    // Reemplaza el enlace con su versión activadora
                    element.outerHTML = `
                        <a href="#" class="activar-descuento" 
                            data-dem-id="${dem_id}" 
                            data-usu-id="${usu_id}" 
                            onclick="activarDescuento(this)">
                            <div class="text-danger">INACTIVO</div>
                        </a>`;
                } else {
                    alert("No se pudo inactivar el descuento.");
                }
            },
            error: function (xhr, status, error) {
                console.error("Error en la solicitud AJAX:", xhr.responseText);
                alert("Error en la solicitud. Verifica la consola para más detalles.");
            }
        });
    }
</script>
