<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Areamodel;

class Area extends BaseController
{

	public function index(){
		$area_model= new Areamodel();
		$datos_area=$area_model->getArea();
        $area=array();
        foreach($datos_area as $are)
        {
            $datos_presupuesto=$area_model->getAreaPresupuesto($are['are_id']);
            $a=array(
			'are_id' => $are['are_id'], 
			'are_area' => $are['are_area'], 
			'are_estado' => $are['are_estado'],
			'usu_cobrador' => $are['usu_cobrador'],
			'are_presupuesto'=>$datos_presupuesto
		    );
		    array_push($area, $a);
        }
       // print_r($area);
		$enviar_datos=array(
			'datos_area' => !empty($area)?$area:null , 
		);

		$datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside",$datos);
		echo view("area/list",$enviar_datos);
		echo view("layouts/footer");
	}

	
	public function add(){
		$session = \Config\Services::session();
		$area_model= new Areamodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('area'))){
				$are_area=$this->request->getPost('area');
				$usu_cobrador=$this->request->getPost('cobrador');
				$ingresar_datos=array(
					'are_area'=>$are_area,
					'are_estado'=>1,
					'usu_cobrador'=>$usu_cobrador,
				);
				$area_model->insertar($ingresar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
				return redirect()->to(base_url('Area')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Area')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}


	}
	
	public function addAreaPresupuesto(){
		$session = \Config\Services::session();
		$area_model= new Areamodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('addareid'))){
				$are_id=$this->request->getPost('addareid');
				$arp_year=$this->request->getPost('addyear');
				$arp_valor=$this->request->getPost('addvalor');
				$year_repetido=$area_model->getAreaPresupuestoYear($are_id,$arp_year);
				if(count($year_repetido)>0)
				{
				    $mensaje='Ya existe un presupuesto para el año y aárea seleccionados';
				    $session->setFlashdata('mensaje_malo', $mensaje);
				    return redirect()->to(base_url('Area')); 
				}
				$ingresar_datos=array(
					'are_id'=>$are_id,
					'arp_year'=>$arp_year,
					'arp_presupuesto'=>$arp_valor,
					'arp_estado'=>1
				);
				$area_model->insertarAreaPresupuesto($ingresar_datos);
				$session->setFlashdata('mensaje_bueno', 'Presupuesto ingresado');
				return redirect()->to(base_url('Area')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese datos');
				return redirect()->to(base_url('Area')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}


	}

	public function edit(){
		$session = \Config\Services::session();
		$area_model= new Areamodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('editarea')) && !empty($this->request->getPost('editareid'))){
				$are_area=$this->request->getPost('editarea');
				$are_id=$this->request->getPost('editareid');
				$usu_cobrador=$this->request->getPost('editcobrador');
				$editar_datos=array(
					'are_area'=>$are_area,
					'usu_cobrador'=>$usu_cobrador,
					'are_estado'=>1
				);
				$area_model->actualizar($are_id,$editar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Editado');
				return redirect()->to(base_url('Area')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Area')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
    
    public function editAreaPresupuesto(){
		$session = \Config\Services::session();
		$area_model= new Areamodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('editpresupuestovalor')) && !empty($this->request->getPost('editpresupuestoyear'))){
				$arp_year=$this->request->getPost('editpresupuestoyear');
				$arp_presupuesto=$this->request->getPost('editpresupuestovalor');
				$arp_id=$this->request->getPost('editarpid');
				$editar_datos=array(
					'arp_presupuesto'=>$arp_presupuesto,
					'arp_estado'=>1
				);
				$area_model->actualizarAreaPresupuesto($arp_id,$editar_datos);
				$session->setFlashdata('mensaje_bueno', 'Presupuesto modificado');
				return redirect()->to(base_url('Area')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Area')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	
	public function eliminar($id){		
		
		$session = \Config\Services::session();
		$area_model= new Areamodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($id)){				
				$eliminar_datos=array(
					'are_estado'=>0
				);
				$area_model->eliminar($id,$eliminar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Eliminado');
				return redirect()->to(base_url('Area')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Area')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	
		
    public function datosMenu()
    {
        $session = \Config\Services::session();
        
        $usuario_model=new UsuarioModel();
        
        $rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
        $menu = $usuario_model->selectMenu();
        $datos = array(
            'rolMenu' => $rm,
            'menu' => $menu
        );
        return $datos;
    }
}