<?php

namespace App\Controllers;
include_once 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use \PhpOffice\PhpSpreadsheet\Reader\IReader;
use App\Models\UsuarioModel;
use App\Models\Puntoventamodel;
use App\Models\Descuentosmodel;
use App\Models\Tipofranquiciacomisionesmodel;
use App\Models\Descuentospdvtipofranquiciamodel;
use App\Models\Descuentomensualmodel;
use App\Models\Descuentomensualvalormodel;
class Descuentomensual extends BaseController
{

	public function index(){
		$datos = $this->datosMenu();
		$descuento_mensual_model=new Descuentomensualmodel();
		$datos_descuento_mensual= $descuento_mensual_model->getDescuentomensual();
		$enviar_datos=array(
			'datos_descuento_mensual'=>$datos_descuento_mensual,			
		);

		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("descuentosmensual/list",$enviar_datos);
		echo view("layouts/footer");
	}

	public function add(){
		$session = \Config\Services::session();
		
		if(!empty($this->request->getPost('descuentomensual')) && !empty($this->request->getPost('fechadesde')) && !empty($this->request->getPost('fechahasta')) && !empty($this->request->getPost('tipo'))){

			$descuento_mensual_model=new Descuentomensualmodel();

			$dem_nombre=$this->request->getPost('descuentomensual');
			$dem_desde=$this->request->getPost('fechadesde');
			$dem_hasta=$this->request->getPost('fechahasta');
			$dem_tipo=$this->request->getPost('tipo');

			$datos=array(
				'dem_nombre'=>$dem_nombre,
				'dem_desde'=>$dem_desde,
				'dem_hasta'=>$dem_hasta,
				'dem_tipo'=>$dem_tipo,				
				'dem_estado'=>1,
			);
			$descuento_mensual_model->insertar($datos);
			
			$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
			return redirect()->to(base_url('Descuentomensual')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay Datos');
			return redirect()->to(base_url('Descuentomensual')); 
		}
	}
	public function edit(){
		$session = \Config\Services::session();
		
		if(!empty($this->request->getPost('editdemid')) && !empty($this->request->getPost('editdescuentomensual')) && !empty($this->request->getPost('editfechadesde')) && !empty($this->request->getPost('editfechahasta')) && !empty($this->request->getPost('edittipo'))){

			
			$descuento_mensual_model=new Descuentomensualmodel();
			$dem_id=$this->request->getPost('editdemid');
			$dem_nombre=$this->request->getPost('editdescuentomensual');
			$dem_desde=$this->request->getPost('editfechadesde');
			$dem_hasta=$this->request->getPost('editfechahasta');
			$dem_tipo=$this->request->getPost('edittipo');

			$datos=array(
				'dem_nombre'=>$dem_nombre,
				'dem_desde'=>$dem_desde,
				'dem_hasta'=>$dem_hasta,
				'dem_tipo'=>$dem_tipo,				
				'dem_estado'=>1,
			);
			$descuento_mensual_model->actualizar($dem_id,$datos);
			
			$session->setFlashdata('mensaje_bueno', 'Dato Actualizado');
			return redirect()->to(base_url('Descuentomensual')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay Datos');
			return redirect()->to(base_url('Descuentomensual')); 
		}
	}
	public function eliminar($dem_id){		
		$session = \Config\Services::session();		
		if(!empty($dem_id)){

			
			$descuento_mensual_model=new Descuentomensualmodel();	
			$datos_descuento_mensual=array(	
				'dem_estado'=>0,
			);

			$descuento_mensual_model->actualizar($dem_id,$datos_descuento_mensual);



			$session->setFlashdata('mensaje_bueno', 'Datos Eliminado');
			return redirect()->to(base_url('Descuentomensual')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Descuentomensual')); 
		}
	}
	public function eliminardescuentomensualvalor(){		
		$session = \Config\Services::session();		
		if(!empty($this->request->getPost('demideliminar')) && !empty($this->request->getPost('dmvfechaeliminar'))){
			$dem_id=$this->request->getPost('demideliminar');
			$fecha=$this->request->getPost('dmvfechaeliminar');

			$fecha=date('Y-m-1',strtotime($fecha));

			$descuento_mensual_valor_model=new Descuentomensualvalormodel();

			$descuento_mensual_valor_model->eliminarsegundemidmes($dem_id,$fecha);



			$session->setFlashdata('mensaje_bueno', 'Datos Eliminado');
			return redirect()->to(base_url('Descuentomensual')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Descuentomensual')); 
		}
	}
	public function editvalor(){		
		$session = \Config\Services::session();		
		if(!empty($this->request->getPost('dmvid'))){
			$descuento_mensual_valor_model=new Descuentomensualvalormodel();

			$dmv_id=$this->request->getPost('dmvid');
			$dmv_valor=$this->request->getPost('nuevovalor');

			$datos_descuento_mensual_valor=array(
				'dmv_valor'=>$dmv_valor,
			);

			$descuento_mensual_valor_model->actualizar($dmv_id,$datos_descuento_mensual_valor);
			$session->setFlashdata('mensaje_bueno', 'Dato editado');
			return redirect()->to(base_url('Descuentomensual')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Descuentomensual')); 
		}
	}

	public function leerdescuentomensual(){
		$datos = $this->datosMenu();		
		$descuento_mensual_model=new Descuentomensualmodel();
		$datos_descuento_mensual= $descuento_mensual_model->getDescuentomensual();
		$enviar_datos=array(
			'datos_descuento_mensual'=>$datos_descuento_mensual,			
		);
		
		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("descuentosmensual/leerdescuentomensual",$enviar_datos);
		echo view("layouts/footer");
	}

	public function tabla()
	{
		$session = \Config\Services::session();
		$punto_venta_model =new Puntoventamodel();
		$nombre_archivo=null;
		
		$mes='';
		if(empty($this->request->getPost('mes'))){
			
			$session->setFlashdata('mensaje_malo', 'Seleccione el mes');
			return redirect()->to(base_url('Descuentomensual/leerdescuentomensual'));
		}
		$mes=$this->request->getPost('mes');
		$mes=date('Y-m-d',strtotime($mes));
		$dem_nombre='';
		$dem_id=0;

		if(!empty($this->request->getPost('demid'))){
			$descuentomensual=explode('/',$this->request->getPost('demid'));
			$dem_id=$descuentomensual[0];
			$dem_nombre=$descuentomensual[1];	
		}

		
		if(!empty($_FILES["archivoseleccionado"]["name"])){
			$nombre_archivo = $_FILES["archivoseleccionado"]["name"];            
		}   
		if($nombre_archivo!=null ){            

			$path = $_FILES["archivoseleccionado"]["tmp_name"];
			$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
			$reader->setReadDataOnly(true);
			$spreadsheet = $reader->load($path);
			$sheet = $spreadsheet->getSheetByName('DESCUENTOS');        

			if(empty($sheet)){
				$session->setFlashdata('mensaje_malo', 'Archivo no Compatible: Hoja con el nombre "DESCUENTOS"');
				return redirect()->to(base_url('Descuentomensual/leerdescuentomensual'));
			}    

			$data=[];

			$pdv_no_encontrados='';
			foreach ($sheet->getRowIterator() as $row) {
				$cellIterator = $row->getCellIterator();
				$cellIterator->setIterateOnlyExistingCells(false); 
				$highestRow = $sheet->getHighestDataRow();               

				$highestColumn = $sheet->getHighestDataColumn();            
				for($row=2; $row<=$highestRow; $row++)
				{

					$nombre = $sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue(); 
					$dmv_valor= $sheet->getCellByColumnAndRow(2, $row)->getCalculatedValue();
					if(!is_numeric($dmv_valor)){
						$dmv_valor=0;
					}

					$puv_id= $punto_venta_model->getPuntoventasegunnombre($nombre);
					$puv_id=!empty($puv_id[0]['puv_id'])?$puv_id[0]['puv_id']:0;
					if($puv_id!=0){
						if($dmv_valor!=0){
							$data[]=array(
								'nombre'=>$nombre,
								'puv_id'=>$puv_id,
								'dmv_valor'=>$dmv_valor,								
							);	
						}				
					}else{
						$pdv_no_encontrados=$pdv_no_encontrados."-".$nombre;
					}
				}
				break;

			}
			$datos = $this->datosMenu();
			
			$enviar_datos=array(        
				'mensaje'=>$pdv_no_encontrados,
				'data'=>$data,
				'dem_nombre'=>$dem_nombre,
				'dem_id'=>$dem_id,
				'mes'=>$mes,
			);

			

			echo view("layouts/header");
			echo view("layouts/aside",$datos);
			echo view("descuentosmensual/tabla",$enviar_datos);
			echo view("layouts/footer");


		}else{
			$session->setFlashdata('mensaje_malo', 'Seleccione un archivo');
			return redirect()->to(base_url('Descuentos/leerdescuento')); 
		}

	}
	public function finalizar (){
		$session = \Config\Services::session();

		if(!empty($this->request->getPost('datos')) && !empty($this->request->getPost('demid')) && !empty($this->request->getPost('mes')) ){
			$descuento_mensual_valor_model=new Descuentomensualvalormodel();
			$datos =$this->request->getPost('datos');		
			$datos=base64_decode($datos);
			$datos=json_decode($datos,true);
			
			$mes=$this->request->getPost('mes');
			$dem_id=$this->request->getPost('demid');

			foreach ($datos as $value) {

				$datos_descuento_mensual=array(

					'puv_id'=>$value['puv_id'],
					'dmv_valor'=>$value['dmv_valor'],
					'dem_id'=>$dem_id,
					'dmv_mes'=>$mes,
					'dmv_estado'=>1,
				);				
				$descuento_mensual_valor_model->insertar($datos_descuento_mensual);

			}

			$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
			return redirect()->to(base_url('Descuentomensual/leerdescuentomensual')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Descuentomensual/leerdescuentomensual')); 
		}

	}

	public function mostrardatosundescuentomensual(){
		if(!empty($this->request->getPost('demid')) && !empty($this->request->getPost('fecha'))){
			$descuento_mensual_valor_model=new Descuentomensualvalormodel();
			$dem_id=$this->request->getPost('demid');
			$dmv_mes=$this->request->getPost('fecha');
			$dmv_mes=date('Y-m-1',strtotime($dmv_mes));
			$resultado=[];
			$resultado= $descuento_mensual_valor_model->getDescuentomensualidmes($dem_id,$dmv_mes);
			return json_encode($resultado);
		}else{
			return json_encode([]);
		}
	}

    public function eliminardescuentomensualvalorporid(){		
		$session = \Config\Services::session();		
		$dmv_id=$this->request->getPost('eliminardmvid');
		if(!empty($dmv_id)){
			$descuento_mensual_valor_model=new Descuentomensualvalormodel();
			
			$descuento_mensual_valor_model->eliminar($dmv_id);						

			$session->setFlashdata('mensaje_bueno', 'Datos Eliminado');
			return redirect()->to(base_url('Descuentomensual')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Descuentomensual')); 
		}
	}
	
	
	
	public function datosMenu()
	{
		$session = \Config\Services::session();

		$usuario_model=new UsuarioModel();

		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datos = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);
		return $datos;
	}
}