<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Tipoplanmodel;

class Tipoplan extends BaseController
{

	public function index(){
		$tipo_plan_model= new Tipoplanmodel();
		$datos_tipo_plan=$tipo_plan_model->getTipoplan();


		$enviar_datos=array(
			'datos_tipo_plan' => !empty($datos_tipo_plan)?$datos_tipo_plan:null , 
		);

		$datos = $this->datosMenu();
		
		echo view("layouts/header");
		echo view("layouts/aside",$datos);
		echo view("tipoplan/list",$enviar_datos);
		echo view("layouts/footer");
	}

	
	public function add(){
		$session = \Config\Services::session();
		$tipo_plan_model= new Tipoplanmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('tipo'))){
				$tip_tipo=$this->request->getPost('tipo');
				$ingresar_datos=array(
					'tip_tipo'=>$tip_tipo,
					'tip_estado'=>1
				);
				$tipo_plan_model->insertar($ingresar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
				return redirect()->to(base_url('Tipoplan')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Tipoplan')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}


	}
	

	public function edit(){
		$session = \Config\Services::session();
		$tipo_plan_model= new Tipoplanmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('edittipo')) && !empty($this->request->getPost('edittipid'))){
				$tip_tipo=$this->request->getPost('edittipo');
				$tip_id=$this->request->getPost('edittipid');
				$editar_datos=array(
					'tip_tipo'=>$tip_tipo,
					'tip_estado'=>1
				);
				$tipo_plan_model->actualizar($tip_id,$editar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Editado');
				return redirect()->to(base_url('Tipoplan')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Tipoplan')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}

	public function eliminar($id){		
		
		$session = \Config\Services::session();
		$tipo_plan_model= new Tipoplanmodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($id)){				
				$eliminar_datos=array(
					'tip_estado'=>0
				);
				$tipo_plan_model->eliminar($id,$eliminar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Eliminado');
				return redirect()->to(base_url('Tipoplan')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Tipoplan')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	
	public function datosMenu()
    {
        $session = \Config\Services::session();
        
        $usuario_model=new UsuarioModel();
        
        $rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
        $menu = $usuario_model->selectMenu();
        $datos = array(
            'rolMenu' => $rm,
            'menu' => $menu
        );
        return $datos;
    }
}