<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Tipoproveedormodel;

class Tipoproveedor extends BaseController
{

	public function index(){
		$tipo_proveedor_model= new Tipoproveedormodel();
		$datos_tipo_proveedor=$tipo_proveedor_model->getTipoproveedor();


		$enviar_datos=array(
			'datos_tipo_proveedor' => !empty($datos_tipo_proveedor)?$datos_tipo_proveedor:null , 
		);

		$datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside",$datos);
		echo view("tipoproveedor/list",$enviar_datos);
		echo view("layouts/footer");
	}

	
	public function add(){
		$session = \Config\Services::session();
		$tipo_proveedor_model= new Tipoproveedormodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('tipo'))){
				$tpp_tipo=$this->request->getPost('tipo');
				$ingresar_datos=array(
					'tpp_tipo'=>$tpp_tipo,
					'tpp_estado'=>1
				);
				$tipo_proveedor_model->insertar($ingresar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
				return redirect()->to(base_url('Tipoproveedor')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Tipoproveedor')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}


	}
	

	public function edit(){
		$session = \Config\Services::session();
		$tipo_proveedor_model= new Tipoproveedormodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('edittipo')) && !empty($this->request->getPost('edittppid'))){
				$tpp_tipo=$this->request->getPost('edittipo');
				$tpp_id=$this->request->getPost('edittppid');
				$editar_datos=array(
					'tpp_tipo'=>$tpp_tipo,
					'tpp_estado'=>1
				);
				$tipo_proveedor_model->actualizar($tpp_id,$editar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Editado');
				return redirect()->to(base_url('Tipoproveedor')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Tipoproveedor')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}

	public function eliminar($id){		
		
		$session = \Config\Services::session();
		$tipo_proveedor_model= new Tipoproveedormodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($id)){				
				$eliminar_datos=array(
					'tpp_estado'=>0
				);
				$tipo_proveedor_model->eliminar($id,$eliminar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Eliminado');
				return redirect()->to(base_url('Tipoproveedor')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Tipoproveedor')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	
	public function datosMenu()
    {
        $session = \Config\Services::session();
        
        $usuario_model=new UsuarioModel();
        
        $rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
        $menu = $usuario_model->selectMenu();
        $datos = array(
            'rolMenu' => $rm,
            'menu' => $menu
        );
        return $datos;
    }
}