<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class Rolmenumodel extends Model
{
    public function getRol()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_rol');
        $builder->select('tbl_rol.*');   
        $builder->where('tbl_rol.ROL_SISTEMA','2');
        $builder->where('tbl_rol.ROL_ESTADO','1');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }    
    public function getMenu()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_menu');
        $builder->select('tbl_menu.*');    
        $builder->where('tbl_menu.MEN_SISTEMA =','2');
        $builder->where('tbl_menu.MEN_ESTADO','1');
        $builder->where('tbl_menu.MEN_PADRE = 0 OR tbl_menu.MEN_PADRE IS NULL');
        $builder->orderBy('tbl_menu.MEN_NOMBRE','ASC');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }   
    public function getRolMenu()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('rel_rol_menu');
        $builder->select('rel_rol_menu.*,tbl_rol.*,GROUP_CONCAT(tbl_menu.MEN_NOMBRE) AS accesos,GROUP_CONCAT(tbl_menu.MEN_ID) AS accesosid');   
        $builder->join('tbl_rol','tbl_rol.ROL_ID=rel_rol_menu.ROL_ID');
        $builder->join('tbl_menu','tbl_menu.MEN_ID=rel_rol_menu.MEN_ID');
        $builder->where('tbl_menu.MEN_SISTEMA =','2');
        $builder->where('tbl_menu.MEN_ESTADO','1');
        $builder->where('tbl_menu.MEN_PADRE = 0 OR tbl_menu.MEN_PADRE IS NULL');
        $builder->groupBy('tbl_rol.ROL_NOMBRE');
        $builder->orderBy('tbl_menu.MEN_NOMBRE','ASC');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    } 
    public function insertarRol($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_rol');
        $builder->set($data);
		$builder->insert();
		
		$builder->selectMax('tbl_rol.ROL_ID');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    } 
    public function insertarMenuRol($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('rel_rol_menu');
        $builder->set($data);
		$builder->insert();
    } 
    public function actualizarRol($rol_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_rol');
        $builder->where('tbl_rol.rol_id', $rol_id);
		return $builder->update($data);        
    }
    public function eliminarRolMenu($rol_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('rel_rol_menu');
        $builder->where('rel_rol_menu.rol_id', $rol_id);   
		$builder->delete();        
    }
}