<?php namespace App\Controllers;

use App\Models\ProductoPreciosViewModel;
use App\Models\ParametrosProductoModel;

class ProductoPreciosController extends BaseController
{
    public function index()
    {
        echo view('layouts/header');
        echo view('layouts/aside');
        echo view('productos/matriz_precios'); // asegúrate que exista esta vista
        echo view('layouts/footer');
    }

    public function data()
    {
        $req = $this->request;

        $filtros = [
            'codigo'      => $req->getGet('codigo'),
            'descripcion' => $req->getGet('descripcion'),
            'lista'       => $req->getGet('lista'),
            'familia'     => $req->getGet('familia'),
        ];

        $length = (int) ($req->getGet('length') ?? 25);
        $start  = (int) ($req->getGet('start')  ?? 0);

        $orderColIndex = $req->getGet('order')[0]['column'] ?? null;
        $orderDir      = $req->getGet('order')[0]['dir']    ?? 'asc';
        $columns       = $req->getGet('columns') ?? [];
        $orderBy       = $orderColIndex !== null ? ($columns[$orderColIndex]['data'] ?? null) : null;

        $model = new ProductoPreciosViewModel();
        $res   = $model->buscar($filtros, $length, $start, $orderBy, $orderDir);


        return $this->response->setJSON([
            'draw'            => (int)($req->getGet('draw') ?? 1),
            'recordsTotal'    => $res['total'],
            'recordsFiltered' => $res['total'],
            'data'            => $res['rows'],
        ]);
    }
    public function detail()
{
    $codigo  = trim($this->request->getGet('codigo') ?? '');
    $lprRef  = $this->request->getGet('lista'); // opcional, para base/preview por lista
    if ($codigo === '') return $this->response->setStatusCode(400)->setJSON(['error'=>'Falta código']);

    $db = \Config\Database::connect();

    // Producto
    $prod = $db->table('public.tbl_producto')
        ->select('pro_codigo, pro_descripcion, pro_reference_id, pro_imagen_url, pro_marca, pro_familia, pro_unidad_nombre, pro_unidad_simbolo')
        ->where('pro_codigo',$codigo)->get()->getFirstRow('array');

    if(!$prod) return $this->response->setStatusCode(404)->setJSON(['error'=>'Producto no existe']);

    // Base price (último por imported_at, unidad base y lista si viene)
    $b = $db->table('public.tbl_pdv_precios_hist h')
        ->select('h.base_price, h.imported_at, h.lpr_ref_id, h.price_list_name')
        ->where('h.pro_reference_id', $prod['pro_reference_id'])
        ->where('h.measury_unit_base', true);
    if (!empty($lprRef)) $b->where('h.lpr_ref_id', $lprRef);
    $base = $b->orderBy('h.imported_at','DESC')->get()->getFirstRow('array');

    // Parámetros activos (márgenes y descuentos del producto)
    $ppModel = new ParametrosProductoModel();
    $ppAct   = $ppModel->activoPorProducto($codigo) ?? [
        'ppr_margen_hoy'=>0,'ppr_desc_normal'=>0,'ppr_desc_limite'=>0,'ppr_desc_admin'=>0,'ppr_desc_mayorista'=>0,'ppr_desc_especial'=>0,
        'ppr_margen_normal'=>0,'ppr_margen_limite'=>0,'ppr_margen_admin'=>0,'ppr_margen_mayorista'=>0,'ppr_margen_especial'=>0,
        'ppr_sentido_normal'=>'D','ppr_sentido_limite'=>'D','ppr_sentido_admin'=>'D','ppr_sentido_mayorista'=>'D','ppr_sentido_especial'=>'D',
        'ppr_observacion'=>''
    ];

    // Precios calculados (solo si hay base)
    $baseVal = (float)($base['base_price'] ?? 0);
    $calc = null;
    
    if ($baseVal > 0) {
    
        // Helper para calcular: base / (1 - margen/100)
        $precioConMargen = function ($margen) use ($baseVal) {
            $m = (float)($margen ?? 0);
            $den = 1 - ($m / 100);
            if ($den <= 0) {            // margen >= 100 ⇒ inválido
                return null;            // o 0 si prefieres: return 0.00;
            }
            return round($baseVal / $den, 2);
        };
    
        $calc = [
            'base_price'         => round($baseVal, 2),
    
            'precio_hoy'         => $precioConMargen($ppAct['ppr_margen_hoy']        ?? 0),
            'precio_normal'      => $precioConMargen($ppAct['ppr_margen_normal']     ?? 0),
            'precio_limite'      => $precioConMargen($ppAct['ppr_margen_limite']     ?? 0),
            'precio_admin'       => $precioConMargen($ppAct['ppr_margen_admin']      ?? 0),
            'precio_mayorista'   => $precioConMargen($ppAct['ppr_margen_mayorista']  ?? 0),
            'precio_especial'    => $precioConMargen($ppAct['ppr_margen_especial']   ?? 0),
    
            'imported_at'        => $base['imported_at'] ?? null,
            'lpr_ref_id'         => $base['lpr_ref_id'] ?? null,
            'price_list_name'    => $base['price_list_name'] ?? null,
        ];
    }


    // Historial resumido
    $hist = $ppModel->historial($codigo, 20);

    return $this->response->setJSON([
        'producto' => $prod,
        'parametros' => $ppAct,
        'calculo' => $calc,
        'historial' => $hist,
    ]);
}

public function saveDetail()
{
    $req    = $this->request;
    $codigo = trim($req->getPost('pro_codigo') ?? '');
    if ($codigo === '') return $this->response->setStatusCode(400)->setJSON(['error'=>'Falta código']);

    $mho   = (float) $req->getPost('mho', FILTER_SANITIZE_NUMBER_FLOAT);
    $d = [
      'normal'     => (float)$req->getPost('desc_normal'),
      'limite'     => (float)$req->getPost('desc_limite'),
      'admin'      => (float)$req->getPost('desc_admin'),
      'mayorista'  => (float)$req->getPost('desc_mayorista'),
      'especial'   => (float)$req->getPost('desc_especial'),
    ];
    $s = [
      'normal'     => $req->getPost('sent_normal') ?: 'D',
      'limite'     => $req->getPost('sent_limite') ?: 'D',
      'admin'      => $req->getPost('sent_admin') ?: 'D',
      'mayorista'  => $req->getPost('sent_mayorista') ?: 'D',
      'especial'   => $req->getPost('sent_especial') ?: 'D',
    ];
    $obs  = trim($req->getPost('observacion') ?? '');

    // Reglas: 4 decimales, 0–100 para % (aunque el "sentido" no cambia el cálculo)
    foreach ($d as $k=>$v) { if ($v < 0) $d[$k] = 0; }

    // Cálculo de márgenes por tipo (fórmula definida): m_tipo = m_hoy × (1 − descuento/100)
    $m = [
      'normal'     => round($mho * (1 - $d['normal']/100), 4),
      'limite'     => round($mho * (1 - $d['limite']/100), 4),
      'admin'      => round($mho * (1 - $d['admin']/100), 4),
      'mayorista'  => round($mho * (1 - $d['mayorista']/100), 4),
      'especial'   => round($mho * (1 - $d['especial']/100), 4),
    ];

    $db = \Config\Database::connect();
    $pp = new ParametrosProductoModel();

    $db->transStart();

    // Inactivar set anterior
    $db->table($pp->table)
       ->where('pro_codigo', $codigo)
       ->where('ppr_activo', true)
       ->set(['ppr_activo'=>false,'ppr_updated_at'=>date('c')])
       ->update();

    // Insertar nuevo set activo
    $pp->insert([
      'pro_codigo'           => $codigo,
      'ppr_margen_hoy'       => number_format($mho,4,'.',''),
      'ppr_desc_normal'      => number_format($d['normal'],4,'.',''),
      'ppr_sentido_normal'   => in_array($s['normal'],['D','I'],true)?$s['normal']:'D',
      'ppr_margen_normal'    => number_format($m['normal'],4,'.',''),

      'ppr_desc_limite'      => number_format($d['limite'],4,'.',''),
      'ppr_sentido_limite'   => in_array($s['limite'],['D','I'],true)?$s['limite']:'D',
      'ppr_margen_limite'    => number_format($m['limite'],4,'.',''),

      'ppr_desc_admin'       => number_format($d['admin'],4,'.',''),
      'ppr_sentido_admin'    => in_array($s['admin'],['D','I'],true)?$s['admin']:'D',
      'ppr_margen_admin'     => number_format($m['admin'],4,'.',''),

      'ppr_desc_mayorista'   => number_format($d['mayorista'],4,'.',''),
      'ppr_sentido_mayorista'=> in_array($s['mayorista'],['D','I'],true)?$s['mayorista']:'D',
      'ppr_margen_mayorista' => number_format($m['mayorista'],4,'.',''),

      'ppr_desc_especial'    => number_format($d['especial'],4,'.',''),
      'ppr_sentido_especial' => in_array($s['especial'],['D','I'],true)?$s['especial']:'D',
      'ppr_margen_especial'  => number_format($m['especial'],4,'.',''),

      'ppr_observacion'      => $obs,
      'ppr_activo'           => true,
      'ppr_created_at'       => date('c'),
      'ppr_updated_at'       => date('c'),
    ]);

    $db->transComplete();

    if(!$db->transStatus()){
        return $this->response->setStatusCode(500)->setJSON(['error'=>'No se pudo guardar']);
    }

    return $this->response->setJSON(['ok'=>true]);
}
}
