<?php namespace App\Models;

use CodeIgniter\Model;

class MatrizCampoRefModel extends Model
{
    protected $table         = 'tbl_matriz_campo_ref';
    protected $primaryKey    = 'mcr_id';
    protected $returnType    = 'array';
    protected $allowedFields = [
        'mat_id','cam_id','mcr_titulo','mcr_formato','mcr_color',
        'mcr_orden','mcr_visible','mcr_params'
    ];
    protected $useTimestamps = false;

    public function forMatriz(int $matId): array
    {
        return $this->db->table($this->table . ' mcr')
            ->select('mcr.*, cg.cam_nombre, cg.cam_titulo, cg.cam_origen, cg.cam_tipo, cg.cam_formato AS cam_formato, cg.cam_color AS cam_color, cg.cam_depends, cg.cam_source, cg.cam_formula')
            ->join('tbl_campo_global cg', 'cg.cam_id = mcr.cam_id', 'inner')
            ->where('mcr.mat_id', $matId)
            ->orderBy('mcr.mcr_orden IS NULL, mcr.mcr_orden ASC, mcr.mcr_id ASC', '', false)
            ->get()->getResultArray();
    }

    public function upsertSet(int $matId, array $camIds, array $overrides = []): void
    {
        $exist = $this->where('mat_id',$matId)->findColumn('cam_id') ?: [];
        $toAdd = array_diff($camIds, $exist);
        foreach ($toAdd as $cid) {
            $payload = [
                'mat_id' => $matId,
                'cam_id' => (int)$cid,
                'mcr_visible' => 1,
                'mcr_orden' => null,
                'mcr_params' => '{}',
            ];
            if (isset($overrides[$cid])) $payload = array_merge($payload, $overrides[$cid]);
            $this->insert($payload);
        }
    }
}
