<?php namespace App\Models;

use CodeIgniter\Model;

class MatrizDatoModel extends Model
{
    protected $table      = 'tbl_matriz_dato';
    protected $primaryKey = 'mad_id';
    protected $returnType = 'array';
    protected $allowedFields = ['mat_id','pro_id','pdv_id','mad_campos','mad_estado','created_at','updated_at'];
    protected $useTimestamps = false;

    public function pageByMatriz(int $matId, int $length=50, int $offset=0, array $filters=[]): array
    {
        $db  = $this->db;
        $bld = $db->table($this->table.' md')
                  ->select('md.mad_id, md.pro_id, md.pdv_id, md.mad_campos,
                            p.pro_codigo, p.pro_descripcion, p.pro_familia, p.pro_gancho')
                  ->join('tbl_producto p','p.pro_id = md.pro_id','left')
                  ->where('md.mat_id', $matId);

        // Filtros ejemplo (precio_hoy >= ?)
        if (isset($filters['precio_hoy_min'])) {
            $bld->where("((md.mad_campos->>'precio_hoy')::numeric) >=", (float)$filters['precio_hoy_min']);
        }
        if (isset($filters['codigo'])) {
            $bld->like('p.pro_codigo', $filters['codigo'], 'after');
        }

        $total = (clone $bld)->countAllResults(false);
        $rows  = $bld->orderBy("((md.mad_campos->>'pp_final')::numeric)","DESC")
                     ->limit($length, $offset)
                     ->get()->getResultArray();

        return ['total'=>$total,'rows'=>$rows];
    }

    /** Actualiza pares campo→valor dentro de JSONB con jsonb_set de Postgres */
    public function updateCampos(int $madId, array $kv): bool
    {
        $setParts = [];
        $binds    = [];
        foreach ($kv as $campo => $valor) {
            $setParts[] = "mad_campos = jsonb_set(mad_campos, '{".$campo."}', to_jsonb(?), true)";
            $binds[]    = $valor;
        }
        $sql = "UPDATE {$this->table} SET ".implode(", ", $setParts).", updated_at = now() WHERE mad_id = ?";
        $binds[] = $madId;
        return $this->db->query($sql, $binds);
    }
    public function getMadRow(int $matId, int $proId, ?int $pdvId = null): ?array
    {
        $b = $this->where('mat_id',$matId)->where('pro_id',$proId);
        if ($pdvId === null) $b->where('pdv_id', null);
        else $b->where('pdv_id', $pdvId);
        return $b->first();
    }

    public function upsertCampos(int $matId, int $proId, ?int $pdvId, array $kv): bool
    {
        $row = $this->getMadRow($matId,$proId,$pdvId);
        if (!$row) {
            return (bool)$this->insert([
                'mat_id'=>$matId,'pro_id'=>$proId,'pdv_id'=>$pdvId,
                'mad_campos'=>json_encode($kv, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES),
                'mad_estado'=>1,'created_at'=>date('c'),'updated_at'=>date('c')
            ]);
        }
        $campos = is_array($row['mad_campos']) ? $row['mad_campos'] : (json_decode((string)$row['mad_campos'], true) ?: []);
        foreach($kv as $k=>$v) $campos[$k] = $v;
        return (bool)$this->update($row['mad_id'], [
            'mad_campos'=>json_encode($campos, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES),
            'updated_at'=>date('c')
        ]);
    }
}
