<?php namespace App\Models;

use CodeIgniter\Model;

class ProductoStockModel extends Model
{
    protected $DBGroup       = 'postgres';
    protected $table         = 'public.tbl_producto_stock';
    protected $primaryKey    = null; // PK compuesto en la tabla
    protected $returnType    = 'array';
    protected $allowedFields = ['pro_reference_id','warehouse_name','stock','updated_at'];

    public function upsertStocks(array $stocks): void
    {
        if (empty($stocks)) return;

        $sql = "
            INSERT INTO public.tbl_producto_stock (pro_reference_id, warehouse_name, stock, updated_at)
            VALUES %s
            ON CONFLICT (pro_reference_id, warehouse_name)
            DO UPDATE SET
                stock = EXCLUDED.stock,
                updated_at = NOW()
        ";

        $ph = []; $params = [];
        foreach ($stocks as $s) {
            $ph[] = '(?, ?, ?, NOW())';
            $params[] = $s['pro_reference_id'];
            $params[] = $s['warehouse_name'];
            $params[] = $s['stock'];
        }

        $q = sprintf($sql, implode(',', $ph));
        $this->db->query($q, $params);
    }
}
