<?php

namespace App\Controllers;

use App\Models\CentroCostoModel;
use CodeIgniter\RESTful\ResourceController;

class CentroCosto extends ResourceController
{
   
    public function index()
    {

        try {
            $centro_costo_model=new  CentroCostoModel();
            $datos=$centro_costo_model->getCentroCosto();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function mostrar()        
    {        

        try {
            
            $tip_id=$this->request->getPost('tip_id');
            $tipo_pago_model=new  TipoPagoModel();
            $datos=$tipo_pago_model->getUnTipoPago($tip_id);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
           
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function eliminar()
    {
        try {
            
            $tipo_pago_model=new  TipoPagoModel();
            $tip_id=$this->request->getPost('tip_id');
            $datos=$tipo_pago_model->getUnTipoPago($tip_id);
            if(empty($datos)){
                return $this->genericResponse(null, "No Eliminado", 404);
            }
            $datos=array(
                "tip_estado"=>0,
            );            
                       
            $tipo_pago_model->eliminar($tip_id,$datos);           
            return $this->genericResponse("Eliminado con exito", null, 200);  

            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function crear()
    {

        try {
            
                        
            $cco_centro_costo=$this->request->getPost('cco_centro_costo');
            $cco_pdv=$this->request->getPost('cco_pdv');
            $cco_ctc=$this->request->getPost('cco_ctc');
            
            
            
            $datos =array(
                "cco_centro_costo"=> $cco_centro_costo,
                "cco_pdv"=> $cco_pdv,
                "cco_ctc"=> $cco_ctc,
                             
            );
            
            $validation =  \Config\Services::validation();
            $validation->setRules([
                
                "cco_centro_costo"=> 'numeric',
                "cco_pdv"=> 'required',
                "cco_ctc"=> 'numeric',                       
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            
            $centro_costo_model=new  CentroCostoModel();
            $centro_costo_model->insertar($datos);            
            
            
            return $this->genericResponse("Ingresado con exito",null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function actualizar()
    {
        try {
            $datos_ingresado = $this->request->getRawinput();            
            $edit_cco_centro_costo=$datos_ingresado['edit_cco_centro_costo'];
            $edit_cco_pdv=$datos_ingresado['edit_cco_pdv'];
            $edit_cco_ctc=$datos_ingresado['edit_cco_ctc'];
            $edit_cco_id=$datos_ingresado['edit_cco_id'];
            
            $datos =array(
                "cco_centro_costo"=> $edit_cco_centro_costo,
                "cco_pdv"=> $edit_cco_pdv,
                "cco_ctc"=> $edit_cco_ctc
                             
            );
            /*
            $validation =  \Config\Services::validation();
            $validation->setRules([
                
                "edit_cco_centro_costo"=> 'numeric',
                "edit_cco_pdv"=> 'required',
                "edit_cco_ctc"=> 'numeric',            
            ]);
            
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                //return $this->genericResponse(null, $errores, 404);
            }
            */
            //return $this->genericResponse(null, $edit_cco_id, $edit_cco_id);
            $centro_costo_model=new CentroCostoModel();
            $centro_costo_model->actualizar($edit_cco_id,$datos);           
            
            return $this->genericResponse("Editado con exito", '', 200);
               
            
                

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}