<?php

namespace App\Controllers;

use App\Models\CierresProcesosModificacionesModel;
use CodeIgniter\RESTful\ResourceController;

class CierresProcesosModificaciones extends ResourceController
{
    protected $format = 'json';
    // hay estado anterior y estado actual (se usa estado actual para el eliminar)
    public function index()
    {

        try {
            $cierres_procesos_modificaciones_model=new  CierresProcesosModificacionesModel();
            $datos=$cierres_procesos_modificaciones_model->getCierresProcesosModificaciones();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }

    public function show($cpm_codigo   =null)        
    {        

        try {
            /*================================================
            =            Busqueda             =
            ================================================*/
            
            $cierres_procesos_modificaciones_model=new  CierresProcesosModificacionesModel();
            $datos=$cierres_procesos_modificaciones_model->getUnCierresProcesosModificaciones($cpm_codigo);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function delete($cpm_codigo = null)
    {
        try {
            /*================================================
            =            Eliminar         =
            ================================================*/

            $datos=array(
                "cpm_estado_actual"=>0,
            );            
            $cierres_procesos_modificaciones_model=new  CierresProcesosModificacionesModel();
            $cierres_procesos_modificaciones_model->eliminar($cpm_codigo,$datos);           
            return $this->genericResponse("Eliminado con exito", null, 200);  

            /*=====  End of Eliminar ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function create()
    {

        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            
            $cip_codigo_cierre=$this->request->getPost('cip_codigo_cierre');
            $cpm_fecha_modificacion=$this->request->getPost('cpm_fecha_modificacion');
            $cpm_observaciones=$this->request->getPost('cpm_observaciones');
            $cpm_estado_anterior=$this->request->getPost('cpm_estado_anterior');
            $cpm_usuario_modificacion=$this->request->getPost('cpm_usuario_modificacion');
            $cpm_estado_actual=$this->request->getPost('cpm_estado_actual');
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "cip_codigo_cierre"=> $cip_codigo_cierre,
                "cpm_fecha_modificacion"=> $cpm_fecha_modificacion,
                "cpm_observaciones"=> $cpm_observaciones,
                "cpm_estado_anterior"=> $cpm_estado_anterior,
                "cpm_usuario_modificacion"=> $cpm_usuario_modificacion,
                "cpm_estado_actual"=> $cpm_estado_actual,

            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([                  

                "cip_codigo_cierre"=> 'required',
                "cpm_fecha_modificacion"=> 'required|valid_date',
                "cpm_observaciones"=> 'required',
                "cpm_estado_anterior"=> 'required',
                "cpm_usuario_modificacion"=> 'required',
                "cpm_estado_actual"=> 'required',             
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            insertar datos            =
            ======================================*/
            $cierres_procesos_modificaciones_model=new  CierresProcesosModificacionesModel();
            $cierres_procesos_modificaciones_model->insertar($datos);            
            
            /*=====  End of insertar datos  ======*/            
            
            return $this->genericResponse("Ingresado con exito",null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    public function update($cpm_codigo = null)
    {
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            $datos_ingresado = $this->request->getRawinput();
            $cip_codigo_cierre=$datos_ingresado['cip_codigo_cierre'];
            $cpm_fecha_modificacion=$datos_ingresado['cpm_fecha_modificacion'];
            $cpm_observaciones=$datos_ingresado['cpm_observaciones'];
            $cpm_estado_anterior=$datos_ingresado['cpm_estado_anterior'];
            $cpm_usuario_modificacion=$datos_ingresado['cpm_usuario_modificacion'];
            $cpm_estado_actual=$datos_ingresado['cpm_estado_actual'];
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "cip_codigo_cierre"=> $cip_codigo_cierre,
                "cpm_fecha_modificacion"=> $cpm_fecha_modificacion,
                "cpm_observaciones"=> $cpm_observaciones,
                "cpm_estado_anterior"=> $cpm_estado_anterior,
                "cpm_usuario_modificacion"=> $cpm_usuario_modificacion,
                "cpm_estado_actual"=> $cpm_estado_actual,

            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([

                "cip_codigo_cierre"=> 'required',
                "cpm_fecha_modificacion"=> 'required|valid_date',
                "cpm_observaciones"=> 'required',
                "cpm_estado_anterior"=> 'required',
                "cpm_usuario_modificacion"=> 'required',
                "cpm_estado_actual"=> 'required',              
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            actualizar datos            =
            ======================================*/
            $cierres_procesos_modificaciones_model=new  CierresProcesosModificacionesModel();
            $cierres_procesos_modificaciones_model->actualizar($cpm_codigo,$datos);           
            
            /*=====  End of actualizar datos  ======*/        
            $existente=$cierres_procesos_modificaciones_model->getUnCierresProcesosModificaciones($cpm_codigo);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }       
            


        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}