<?php

namespace App\Controllers;

use App\Models\ConciliacionModel;
use CodeIgniter\RESTful\ResourceController;

class Conciliacion extends ResourceController
{
    protected $format = 'json';

    public function index()
    {

        try {
            $conciliacion_model=new  ConciliacionModel();
            $datos=$conciliacion_model->getconciliacionautomatica();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}