<?php

namespace App\Controllers;

use App\Models\EstadosVentasPagosModel;
use CodeIgniter\RESTful\ResourceController;

class EstadosVentasPagos extends ResourceController
{
    protected $format = 'json';
    public function index()
    {

        try {
            $estados_ventas_pagos_model=new  EstadosVentasPagosModel();
            $datos=$estados_ventas_pagos_model->getEstadosVentasPagos();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }

    public function show($id   =null)        
    {        

        try {
            /*================================================
            =            Busqueda             =
            ================================================*/
            $evp_estado_descripcion=$this->request->getPost('evp_estado_descripcion');
            $evp_tipo=$this->request->getPost('evp_tipo');
            $evp_cuenta_contable=$this->request->getPost('evp_cuenta_contable');
            
            $estados_ventas_pagos_model=new  EstadosVentasPagosModel();
            $datos=$estados_ventas_pagos_model->getUnEstadosVentasPagos($evp_estado_descripcion,$evp_tipo,$evp_cuenta_contable);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function delete($id = null)
    {
        try {
            /*================================================
            =            Eliminar         =
            ================================================*/
            $evp_estado_descripcion=$this->request->getPost('evp_estado_descripcion');
            $evp_tipo=$this->request->getPost('evp_tipo');
            $evp_cuenta_contable=$this->request->getPost('evp_cuenta_contable');

            $datos=array(
                "evp_estado"=>0,
            );            
            $estados_ventas_pagos_model=new  EstadosVentasPagosModel();
            $estados_ventas_pagos_model->eliminar($evp_estado_descripcion,$evp_tipo,$evp_cuenta_contable,$datos);           
            return $this->genericResponse("Eliminado con exito", null, 200);  

            /*=====  End of Eliminar ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function create()
    {

        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            
            $evp_estado_descripcion=$this->request->getPost('evp_estado_descripcion');
            $evp_tipo=$this->request->getPost('evp_tipo');
            $evp_cuenta_contable=$this->request->getPost('evp_cuenta_contable');
            $ecp_nombre_cuenta=$this->request->getPost('ecp_nombre_cuenta');
            $evp_estado=$this->request->getPost('evp_estado');
            $evp_naturaleza=$this->request->getPost('evp_naturaleza');
            $evp_descripcion=$this->request->getPost('evp_descripcion');
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "evp_estado_descripcion"=> $evp_estado_descripcion,
                "evp_tipo"=> $evp_tipo,
                "evp_cuenta_contable"=> $evp_cuenta_contable,
                "ecp_nombre_cuenta"=> $ecp_nombre_cuenta,
                "evp_estado"=> $evp_estado,
                "evp_naturaleza"=> $evp_naturaleza,
                "evp_descripcion"=> $evp_descripcion,
                       

            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([                  

                "evp_estado_descripcion"=> 'required',
                "evp_tipo"=> 'required',
                "evp_cuenta_contable"=> 'required',
                "ecp_nombre_cuenta"=> 'required',
                "evp_estado"=> 'required',
                "evp_naturaleza"=> 'required',
                "evp_descripcion"=> 'required',          
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            insertar datos            =
            ======================================*/
            $estados_ventas_pagos_model=new  EstadosVentasPagosModel();
            $estados_ventas_pagos_model->insertar($datos);            
            
            /*=====  End of insertar datos  ======*/            
            
            return $this->genericResponse("Ingresado con exito",null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    public function update($id = null)
    {
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            $datos_ingresado = $this->request->getRawinput();
            $evp_estado_descripcion=$datos_ingresado['evp_estado_descripcion'];
            $evp_tipo=$datos_ingresado['evp_tipo'];
            $evp_cuenta_contable=$datos_ingresado['evp_cuenta_contable'];
            $ecp_nombre_cuenta=$datos_ingresado['ecp_nombre_cuenta'];
            $evp_estado=$datos_ingresado['evp_estado'];
            $evp_naturaleza=$datos_ingresado['evp_naturaleza'];
            $evp_descripcion=$datos_ingresado['evp_descripcion'];
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "evp_estado_descripcion"=> $evp_estado_descripcion,
                "evp_tipo"=> $evp_tipo,
                "evp_cuenta_contable"=> $evp_cuenta_contable,
                "ecp_nombre_cuenta"=> $ecp_nombre_cuenta,
                "evp_estado"=> $evp_estado,
                "evp_naturaleza"=> $evp_naturaleza,
                "evp_descripcion"=> $evp_descripcion,

            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([

                "evp_estado_descripcion"=> 'required',
                "evp_tipo"=> 'required',
                "evp_cuenta_contable"=> 'required',
                "ecp_nombre_cuenta"=> 'required',
                "evp_estado"=> 'required',
                "evp_naturaleza"=> 'required',
                "evp_descripcion"=> 'required',            
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            actualizar datos            =
            ======================================*/
            $estados_ventas_pagos_model=new  EstadosVentasPagosModel();
            $estados_ventas_pagos_model->actualizar($evp_estado_descripcion,$evp_tipo,$evp_cuenta_contable,$datos);           
            
            /*=====  End of actualizar datos  ======*/        
            $existente=$estados_ventas_pagos_model->getUnEstadosVentasPagos($evp_estado_descripcion,$evp_tipo,$evp_cuenta_contable);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }       
            


        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}