<?php

namespace App\Controllers;

use App\Models\FrecuenciasPagoModel;
use CodeIgniter\RESTful\ResourceController;

class FrecuenciasPago extends ResourceController
{
    protected $format = 'json';
    //NO ENCONTRE LA LOGICA PARA HACER EL SHOW / DELETE / UPDATE
    public function index()
    {

        try {
            $frecuencias_pago_model=new  FrecuenciasPagoModel();
            $datos=$frecuencias_pago_model->getFrecuenciasPago();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }

    public function show($id   =null)        
    {        

        try {
            /*================================================
            =            Busqueda             =
            ================================================*/
            
            $bap_codigo_banco=$this->request->getPost('bap_codigo_banco');
            $frp_tipo_credito=$this->request->getPost('frp_tipo_credito');
            
            $frecuencias_pago_model=new  FrecuenciasPagoModel();
            $datos=$frecuencias_pago_model->getUnFrecuenciasPago($bap_codigo_banco,$frp_tipo_credito);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            } 
            
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function delete($id = null)
    {
        try {
            /*================================================
            =            Eliminar         =
            ================================================*/
            $bap_codigo_banco=$this->request->getPost('bap_codigo_banco');
            $frp_tipo_credito=$this->request->getPost('frp_tipo_credito');

            $datos=array(
                "frp_estado"=>0,
            );            
            $frecuencias_pago_model=new  FrecuenciasPagoModel();
            $frecuencias_pago_model->eliminar($bap_codigo_banco,$frp_tipo_credito,$datos);           
            return $this->genericResponse("Eliminado con exito", null, 200);  
            
            /*=====  End of Eliminar ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function create()
    {

        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            
            $bap_codigo_banco=$this->request->getPost('bap_codigo_banco');
            $frp_tipo_credito=$this->request->getPost('frp_tipo_credito');
            $frp_tipo_frecuencia=$this->request->getPost('frp_tipo_frecuencia');
            $frp_cantidad_frecuencia=$this->request->getPost('frp_cantidad_frecuencia');
            $frp_fecha1=$this->request->getPost('frp_fecha1');
            $frp_fecha2=$this->request->getPost('frp_fecha2');
            $frp_fecha3=$this->request->getPost('frp_fecha3');
            $frp_fecha4=$this->request->getPost('frp_fecha4');
            $frp_estado=$this->request->getPost('frp_estado');
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "bap_codigo_banco"=> $bap_codigo_banco,
                "frp_tipo_credito"=> $frp_tipo_credito,
                "frp_tipo_frecuencia"=> $frp_tipo_frecuencia,
                "frp_cantidad_frecuencia"=> $frp_cantidad_frecuencia,
                "frp_fecha1"=> $frp_fecha1,
                "frp_fecha2"=> $frp_fecha2,
                "frp_fecha3"=> $frp_fecha3,
                "frp_fecha4"=> $frp_fecha4,
                "frp_estado"=> $frp_estado,
                
            );
            

            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([                  

                "bap_codigo_banco"=> 'required',
                "frp_tipo_credito"=> 'required',
                "frp_tipo_frecuencia"=> 'required',
                "frp_cantidad_frecuencia"=> 'required|numeric',
                "frp_fecha1"=> 'required|valid_date',
                "frp_fecha2"=> 'required|valid_date',
                "frp_fecha3"=> 'required|valid_date',
                "frp_fecha4"=> 'required|valid_date',
                "frp_estado"=> 'required',        
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            insertar datos            =
            ======================================*/
            $frecuencias_pago_model=new  FrecuenciasPagoModel();
            $frecuencias_pago_model->insertar($datos);            
            
            /*=====  End of insertar datos  ======*/            
            
            return $this->genericResponse("Ingresado con exito",null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    public function update($id = null)
    {
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            
            $datos_ingresado = $this->request->getRawinput();
            $bap_codigo_banco=$datos_ingresado['bap_codigo_banco'];
            $frp_tipo_credito=$datos_ingresado['frp_tipo_credito'];
            $frp_tipo_frecuencia=$datos_ingresado['frp_tipo_frecuencia'];
            $frp_cantidad_frecuencia=$datos_ingresado['frp_cantidad_frecuencia'];
            $frp_fecha1=$datos_ingresado['frp_fecha1'];
            $frp_fecha2=$datos_ingresado['frp_fecha2'];
            $frp_fecha3=$datos_ingresado['frp_fecha3'];
            $frp_fecha4=$datos_ingresado['frp_fecha4'];
            $frp_estado=$datos_ingresado['frp_estado'];
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "bap_codigo_banco"=> $bap_codigo_banco,
                "frp_tipo_credito"=> $frp_tipo_credito,
                "frp_tipo_frecuencia"=> $frp_tipo_frecuencia,
                "frp_cantidad_frecuencia"=> $frp_cantidad_frecuencia,
                "frp_fecha1"=> $frp_fecha1,
                "frp_fecha2"=> $frp_fecha2,
                "frp_fecha3"=> $frp_fecha3,
                "frp_fecha4"=> $frp_fecha4,
                "frp_estado"=> $frp_estado,

            );

            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([

                "bap_codigo_banco"=> 'required',
                "frp_tipo_credito"=> 'required',
                "frp_tipo_frecuencia"=> 'required',
                "frp_cantidad_frecuencia"=> 'required|numeric',
                "frp_fecha1"=> 'required|valid_date',
                "frp_fecha2"=> 'required|valid_date',
                "frp_fecha3"=> 'required|valid_date',
                "frp_fecha4"=> 'required|valid_date',
                "frp_estado"=> 'required',              
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            actualizar datos            =
            ======================================*/
            
            $frecuencias_pago_model=new  FrecuenciasPagoModel();
            $frecuencias_pago_model->actualizar($bap_codigo_banco,$frp_tipo_credito,$datos);           
            
            /*=====  End of actualizar datos  ======*/  
               
            $existente=$frecuencias_pago_model->getUnFrecuenciasPago($bap_codigo_banco,$frp_tipo_credito);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            


        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}