<?php

namespace App\Controllers;

use App\Models\HistorialVentaModel;
use CodeIgniter\RESTful\ResourceController;

class HistorialVenta extends ResourceController
{
    
    public function index(){
        try {
            $desde =$this->request->getPost('desde');
            $hasta =$this->request->getPost('hasta');
            $tipo_busqueda =$this->request->getPost('tipobusqueda');
            
            $historial_venta_model= new   HistorialVentaModel();
            $datos=$historial_venta_model->gethistorialventa($desde,$hasta,$tipo_busqueda);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }
    public function getultimafechacierremes(){
        try {
                        
            $historial_venta_model= new   HistorialVentaModel();
            $datos=$historial_venta_model->ultimafechacierremes();
            
            if(!empty($datos[0]['cim_hasta'])){
                $datos=$datos[0]['cim_hasta'];
            }else{
                $datos=null;
            }
            
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }
    public function historial($desde,$hasta,$cim_id)
    {
           
        try {
            $historial_venta_model= new   HistorialVentaModel();
            
            //$datos_comprobarcierremes=$historial_venta_model->comprobarcierremes($desde,$hasta);

            //if(!empty($datos_comprobarcierremes)){
             //   return $this->genericResponse(null, 'El mes ingresado esta cerrado', 404);
            //}
            /*$fechas_cierre_mes=array(
                'cim_desde'=>$desde,
                'cim_hasta'=>$hasta,
                'cim_estado'=>1,
            );
            $historial_venta_model->insertarcierremes($fechas_cierre_mes);*/
            
            $datos_conciliados=$historial_venta_model->selectventaconciliada($desde,$hasta,2);
            

            $datos_no_conciliados=$historial_venta_model->selectventanoconciliada($desde,$hasta,1);
            

            $hsv_ven_fecha_pago='';
            $tic_id=1;
            
            foreach ($datos_conciliados as  $value) {
                $ven_monto=$value['ven_monto'];
                $ven_monto=$ven_monto-$value['ven_ajuste'];
                if($value['ven_fecha_transaccion']>$hasta)
                {
                    $hsv_ven_fecha_pago='0000-00-00';
                    $tic_id=1;
                }
                else
                {
                    $hsv_ven_fecha_pago=$value['rpv_fecha_cruce'];
                    $tic_id=2;
                }
                $datos=array(
                    'ven_id'=>$value['ven_id'],
                    'hsv_ven_fecha_transaccion'=>$value['ven_fecha_transaccion'], 
                    'hsv_ven_fecha_pago'=>$hsv_ven_fecha_pago, 
                    'hsv_ven_ajuste'=>$value['ven_ajuste'],
                    'hsv_ven_banco'=>$value['ven_banco'], 
                    'hsv_ven_centro_costo'=>$value['ven_centro_costo'],
                    'hsv_ven_cuotas'=>$value['ven_cuotas'],  
                    'hsv_ven_id_banco'=>$value['ven_id_banco'],
                    'hsv_ven_id_tarjeta_credito'=>$value['ven_id_tarjeta_credito'],  
                    'hsv_ven_lote'=>$value['ven_lote'], 
                    'hsv_ven_autorizacion'=>$value['ven_autorizacion'], 
                    'hsv_ven_numero_tc'=>$value['ven_numero_tc'], 
                    'hsv_ven_monto'=>$ven_monto,  
                    'tic_id'=>$tic_id,
                    'cim_id'=>$cim_id,

                );

                $historial_venta_model->insertar($datos);
            }
            $hsv_ven_fecha_pago='';
            $tic_id=1;
            foreach ($datos_no_conciliados as  $value) {
                $ven_monto=$value['ven_monto']-$value['ven_ajuste'];
                $datos=array(
                    'ven_id'=>$value['ven_id'],
                    'hsv_ven_fecha_transaccion'=>$value['ven_fecha_transaccion'],
                    'hsv_ven_fecha_pago'=>$hsv_ven_fecha_pago, 
                    'hsv_ven_ajuste'=>$value['ven_ajuste'],
                    'hsv_ven_banco'=>$value['ven_banco'], 
                    'hsv_ven_centro_costo'=>$value['ven_centro_costo'],
                    'hsv_ven_cuotas'=>$value['ven_cuotas'],  
                    'hsv_ven_id_banco'=>$value['ven_id_banco'],
                    'hsv_ven_id_tarjeta_credito'=>$value['ven_id_tarjeta_credito'],  
                    'hsv_ven_lote'=>$value['ven_lote'], 
                    'hsv_ven_autorizacion'=>$value['ven_autorizacion'], 
                    'hsv_ven_numero_tc'=>$value['ven_numero_tc'], 
                    'hsv_ven_monto'=>$ven_monto,  
                    'tic_id'=>$value['tic_id'],
                    'cim_id'=>$cim_id,

                );

                $historial_venta_model->insertar($datos);
                $ven_monto=0;
            }
            return true;
        } catch (Exception $e) {  

            return false;
        }        
        
    }


    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}