<?php

namespace App\Controllers;

use App\Models\MovimientosPagosModel;
use CodeIgniter\RESTful\ResourceController;

class MovimientosPagos extends ResourceController
{
    protected $format = 'json';
    public function index()
    {

        try {
            $movimientos_pagos_model=new  MovimientosPagosModel();
            $datos=$movimientos_pagos_model->getMovimientosPagos();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }

    public function show($id   =null)        
    {        

        try {
            /*================================================
            =            Busqueda             =
            ================================================*/
            $pad_codigo_pago =$this->request->getPost('pad_codigo_pago');
            $pad_numero_item =$this->request->getPost('pad_numero_item');
            
            $movimientos_pagos_model=new  MovimientosPagosModel();
            $datos=$movimientos_pagos_model->getUnMovimientosPagos($pad_codigo_pago,$pad_numero_item);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function delete($id = null)
    {
        try {
            /*================================================
            =            Eliminar         =
            ================================================*/
            $pad_codigo_pago =$this->request->getPost('pad_codigo_pago');
            $pad_numero_item =$this->request->getPost('pad_numero_item');

            $datos=array(
                "mop_estado_reembolsado"=>0,
            );   

            $movimientos_pagos_model=new  MovimientosPagosModel();
            $movimientos_pagos_model->eliminar($pad_codigo_pago,$pad_numero_item,$datos);           
            return $this->genericResponse("Eliminado con exito", null, 200);  

            /*=====  End of Eliminar ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function create()
    {

        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            
            $pad_codigo_pago=$this->request->getPost('pad_codigo_pago');
            $pad_numero_item=$this->request->getPost('pad_numero_item');
            $mop_movimiento=$this->request->getPost('mop_movimiento');
            $mop_valor_movimiento=$this->request->getPost('mop_valor_movimiento');
            $mop_fecha_ingreso=$this->request->getPost('mop_fecha_ingreso');
            $mop_fecha_registro=$this->request->getPost('mop_fecha_registro');
            $mop_cuenta_contable=$this->request->getPost('mop_cuenta_contable');
            $mop_fecha_contable=$this->request->getPost('mop_fecha_contable');
            $mop_referencia_contable=$this->request->getPost('mop_referencia_contable');
            $mop_observacion=$this->request->getPost('mop_observacion');
            $mop_usuario=$this->request->getPost('mop_usuario');
            $mop_sucursal=$this->request->getPost('mop_sucursal');
            $mop_oficina=$this->request->getPost('mop_oficina');
            $mop_centro_costo=$this->request->getPost('mop_centro_costo');
            $mop_fecha_reembolso=$this->request->getPost('mop_fecha_reembolso');
            $mop_numero_comprobante=$this->request->getPost('mop_numero_comprobante');
            $mop_beneficiario=$this->request->getPost('mop_beneficiario');
            $mop_estado_reembolsado=$this->request->getPost('mop_estado_reembolsado');
            $mop_fecha_modificacion_estado=$this->request->getPost('mop_fecha_modificacion_estado');
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "pad_codigo_pago"=> $pad_codigo_pago,
                "pad_numero_item"=> $pad_numero_item,
                "mop_movimiento"=> $mop_movimiento,
                "mop_valor_movimiento"=> $mop_valor_movimiento,
                "mop_fecha_ingreso"=> $mop_fecha_ingreso,
                "mop_fecha_registro"=> $mop_fecha_registro,
                "mop_cuenta_contable"=> $mop_cuenta_contable,
                "mop_fecha_contable"=> $mop_fecha_contable,
                "mop_referencia_contable"=> $mop_referencia_contable,
                "mop_observacion"=> $mop_observacion,
                "mop_usuario"=> $mop_usuario,
                "mop_sucursal"=> $mop_sucursal,
                "mop_oficina"=> $mop_oficina,
                "mop_centro_costo"=> $mop_centro_costo,
                "mop_fecha_reembolso"=> $mop_fecha_reembolso,
                "mop_numero_comprobante"=> $mop_numero_comprobante,
                "mop_beneficiario"=> $mop_beneficiario,
                "mop_estado_reembolsado"=> $mop_estado_reembolsado,
                "mop_fecha_modificacion_estado"=> $mop_fecha_modificacion_estado,
                         

            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([                  

                "pad_codigo_pago"=> 'required',
                "pad_numero_item"=> 'required|numeric',
                "mop_movimiento"=> 'required',
                "mop_valor_movimiento"=> 'required|numeric',
                "mop_fecha_ingreso"=> 'required|valid_date',
                "mop_fecha_registro"=> 'required|valid_date',
                "mop_cuenta_contable"=> 'required',
                "mop_fecha_contable"=> 'required|valid_date',
                "mop_referencia_contable"=> 'required',
                "mop_observacion"=> 'required',
                "mop_usuario"=> 'required',
                "mop_sucursal"=> 'required',
                "mop_oficina"=> 'required',
                "mop_centro_costo"=> 'required',
                "mop_fecha_reembolso"=> 'required|valid_date',
                "mop_numero_comprobante"=> 'required|numeric',
                "mop_beneficiario"=> 'required',
                "mop_estado_reembolsado"=> 'required',
                "mop_fecha_modificacion_estado"=> 'required|valid_date',    
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            insertar datos            =
            ======================================*/
            $movimientos_pagos_model=new  MovimientosPagosModel();
            $movimientos_pagos_model->insertar($datos);            
            
            /*=====  End of insertar datos  ======*/            
            
            return $this->genericResponse("Ingresado con exito",null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    public function update($id = null)
    {
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            $datos_ingresado = $this->request->getRawinput();
            $pad_codigo_pago=$datos_ingresado['pad_codigo_pago'];
            $pad_numero_item=$datos_ingresado['pad_numero_item'];
            $mop_movimiento=$datos_ingresado['mop_movimiento'];
            $mop_valor_movimiento=$datos_ingresado['mop_valor_movimiento'];
            $mop_fecha_ingreso=$datos_ingresado['mop_fecha_ingreso'];
            $mop_fecha_registro=$datos_ingresado['mop_fecha_registro'];
            $mop_cuenta_contable=$datos_ingresado['mop_cuenta_contable'];
            $mop_fecha_contable=$datos_ingresado['mop_fecha_contable'];
            $mop_referencia_contable=$datos_ingresado['mop_referencia_contable'];
            $mop_observacion=$datos_ingresado['mop_observacion'];
            $mop_usuario=$datos_ingresado['mop_usuario'];
            $mop_sucursal=$datos_ingresado['mop_sucursal'];
            $mop_oficina=$datos_ingresado['mop_oficina'];
            $mop_centro_costo=$datos_ingresado['mop_centro_costo'];
            $mop_fecha_reembolso=$datos_ingresado['mop_fecha_reembolso'];
            $mop_numero_comprobante=$datos_ingresado['mop_numero_comprobante'];
            $mop_beneficiario=$datos_ingresado['mop_beneficiario'];
            $mop_estado_reembolsado=$datos_ingresado['mop_estado_reembolsado'];
            $mop_fecha_modificacion_estado=$datos_ingresado['mop_fecha_modificacion_estado'];
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "pad_codigo_pago"=> $pad_codigo_pago,
                "pad_numero_item"=> $pad_numero_item,
                "mop_movimiento"=> $mop_movimiento,
                "mop_valor_movimiento"=> $mop_valor_movimiento,
                "mop_fecha_ingreso"=> $mop_fecha_ingreso,
                "mop_fecha_registro"=> $mop_fecha_registro,
                "mop_cuenta_contable"=> $mop_cuenta_contable,
                "mop_fecha_contable"=> $mop_fecha_contable,
                "mop_referencia_contable"=> $mop_referencia_contable,
                "mop_observacion"=> $mop_observacion,
                "mop_usuario"=> $mop_usuario,
                "mop_sucursal"=> $mop_sucursal,
                "mop_oficina"=> $mop_oficina,
                "mop_centro_costo"=> $mop_centro_costo,
                "mop_fecha_reembolso"=> $mop_fecha_reembolso,
                "mop_numero_comprobante"=> $mop_numero_comprobante,
                "mop_beneficiario"=> $mop_beneficiario,
                "mop_estado_reembolsado"=> $mop_estado_reembolsado,
                "mop_fecha_modificacion_estado"=> $mop_fecha_modificacion_estado,

            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([

                "pad_codigo_pago"=> 'required',
                "pad_numero_item"=> 'required|numeric',
                "mop_movimiento"=> 'required',
                "mop_valor_movimiento"=> 'required|numeric',
                "mop_fecha_ingreso"=> 'required|valid_date',
                "mop_fecha_registro"=> 'required|valid_date',
                "mop_cuenta_contable"=> 'required',
                "mop_fecha_contable"=> 'required|valid_date',
                "mop_referencia_contable"=> 'required',
                "mop_observacion"=> 'required',
                "mop_usuario"=> 'required',
                "mop_sucursal"=> 'required',
                "mop_oficina"=> 'required',
                "mop_centro_costo"=> 'required',
                "mop_fecha_reembolso"=> 'required|valid_date',
                "mop_numero_comprobante"=> 'required|numeric',
                "mop_beneficiario"=> 'required',
                "mop_estado_reembolsado"=> 'required',
                "mop_fecha_modificacion_estado"=> 'required|valid_date',            
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            actualizar datos            =
            ======================================*/
            $movimientos_pagos_model=new  MovimientosPagosModel();
            $movimientos_pagos_model->actualizar($pad_codigo_pago,$pad_numero_item,$datos);           
            
            /*=====  End of actualizar datos  ======*/        
            $existente=$movimientos_pagos_model->getUnMovimientosPagos($pad_codigo_pago,$pad_numero_item);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }       
            


        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}