<?php

namespace App\Controllers;

use App\Models\MovimientosVentasModel;
use CodeIgniter\RESTful\ResourceController;

class MovimientosVentas extends ResourceController
{
    protected $format = 'json';
    public function index()
    {

        try {
            $movimientos_ventas_model=new  MovimientosVentasModel();
            $datos=$movimientos_ventas_model->getMovimientosVentas();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }

    public function show($ven_codigo   =null)        
    {        

        try {
            /*================================================
            =            Busqueda             =
            ================================================*/
                                    
            $movimientos_ventas_model=new  MovimientosVentasModel();
            $datos=$movimientos_ventas_model->getUnMovimientosVentas($ven_codigo);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            } 
             
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function delete($ven_codigo = null)
    {
        try {
            /*================================================
            =            Eliminar         =
            ================================================*/            
            $datos=array(
                "mov_estado"=>0,
            );            
            $movimientos_ventas_model=new  MovimientosVentasModel();
            $movimientos_ventas_model->eliminar($ven_codigo,$datos);           
            return $this->genericResponse("Eliminado con exito", null, 200);  
            
            /*=====  End of Eliminar ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function create()
    {

        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            
           
            $ven_codigo=$this->request->getPost('ven_codigo');
            $mov_movimiento=$this->request->getPost('mov_movimiento');
            $mov_valor_movimiento=$this->request->getPost('mov_valor_movimiento');
            $mov_fecha_ingreso=$this->request->getPost('mov_fecha_ingreso');
            $mov_fecha_registro=$this->request->getPost('mov_fecha_registro');
            $mov_cuenta_contable=$this->request->getPost('mov_cuenta_contable');
            $mov_fecha_contable=$this->request->getPost('mov_fecha_contable');
            $mov_referencia_contable=$this->request->getPost('mov_referencia_contable');
            $mov_observacion=$this->request->getPost('mov_observacion');
            $mov_usuario=$this->request->getPost('mov_usuario');
            $mov_estado=$this->request->getPost('mov_estado');
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "ven_codigo"=> $ven_codigo,
                "mov_movimiento"=> $mov_movimiento,
                "mov_valor_movimiento"=> $mov_valor_movimiento,
                "mov_fecha_ingreso"=> $mov_fecha_ingreso,
                "mov_fecha_registro"=> $mov_fecha_registro,
                "mov_cuenta_contable"=> $mov_cuenta_contable,
                "mov_fecha_contable"=> $mov_fecha_contable,
                "mov_referencia_contable"=> $mov_referencia_contable,
                "mov_observacion"=> $mov_observacion,
                "mov_usuario"=> $mov_usuario,
                "mov_estado"=> $mov_estado,
                
                
            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([                  


                "ven_codigo"=> 'required',
                "mov_movimiento"=> 'required',
                "mov_valor_movimiento"=> 'required|numeric',
                "mov_fecha_ingreso"=> 'required|valid_date',
                "mov_fecha_registro"=> 'required|valid_date',
                "mov_cuenta_contable"=> 'required',
                "mov_fecha_contable"=>'required|valid_date',
                "mov_referencia_contable"=> 'required',
                "mov_observacion"=> 'required',
                "mov_usuario"=> 'required',
                "mov_estado"=> 'required',       
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            insertar datos            =
            ======================================*/
            $movimientos_ventas_model=new  MovimientosVentasModel();
            $movimientos_ventas_model->insertar($datos);            
            
            /*=====  End of insertar datos  ======*/            
            
            return $this->genericResponse("Ingresado con exito",null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    public function update($ven_codigo = null)
    {
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            
            $datos_ingresado = $this->request->getRawinput();            
            $mov_movimiento=$datos_ingresado['mov_movimiento'];
            $mov_valor_movimiento=$datos_ingresado['mov_valor_movimiento'];
            $mov_fecha_ingreso=$datos_ingresado['mov_fecha_ingreso'];
            $mov_fecha_registro=$datos_ingresado['mov_fecha_registro'];
            $mov_cuenta_contable=$datos_ingresado['mov_cuenta_contable'];
            $mov_fecha_contable=$datos_ingresado['mov_fecha_contable'];
            $mov_referencia_contable=$datos_ingresado['mov_referencia_contable'];
            $mov_observacion=$datos_ingresado['mov_observacion'];
            $mov_usuario=$datos_ingresado['mov_usuario'];
            $mov_estado=$datos_ingresado['mov_estado'];
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                
                "mov_movimiento"=> $mov_movimiento,
                "mov_valor_movimiento"=> $mov_valor_movimiento,
                "mov_fecha_ingreso"=> $mov_fecha_ingreso,
                "mov_fecha_registro"=> $mov_fecha_registro,
                "mov_cuenta_contable"=> $mov_cuenta_contable,
                "mov_fecha_contable"=> $mov_fecha_contable,
                "mov_referencia_contable"=> $mov_referencia_contable,
                "mov_observacion"=> $mov_observacion,
                "mov_usuario"=> $mov_usuario,
                "mov_estado"=> $mov_estado,

            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([
                
                "mov_movimiento"=> 'required',
                "mov_valor_movimiento"=> 'required|numeric',
                "mov_fecha_ingreso"=> 'required|valid_date',
                "mov_fecha_registro"=> 'required|valid_date',
                "mov_cuenta_contable"=> 'required',
                "mov_fecha_contable"=>'required|valid_date',
                "mov_referencia_contable"=> 'required',
                "mov_observacion"=> 'required',
                "mov_usuario"=> 'required',
                "mov_estado"=> 'required',           
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            actualizar datos            =
            ======================================*/
            
            $movimientos_ventas_model=new  MovimientosVentasModel();
            $movimientos_ventas_model->actualizar($ven_codigo,$datos);           
            
            /*=====  End of actualizar datos  ======*/  
                
            $existente=$movimientos_ventas_model->getUnMovimientosVentas($ven_codigo);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }       
            


        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}