<?php

namespace App\Controllers;

use App\Models\PagoCabeceraModel;
use App\Models\PagoDetalleModel;
use CodeIgniter\RESTful\ResourceController;

class PagoCabecera extends ResourceController
{


    public function datoscabeceradetalle(){
        try {
            $datos_cabecera_detalle = json_decode(file_get_contents('php://input'), true);
            
            $datos_cabecera=$datos_cabecera_detalle['datos_cabecera'];
            $datos_detalle=$datos_cabecera_detalle['datos_detalle'];
            $pago_cabecera_model=new  PagoCabeceraModel();


            $resultado_nombre_archivo= $pago_cabecera_model->getPacoCabeceraNombreArchivo($datos_cabecera['pac_nombre_archivo']);

            if(!empty($resultado_nombre_archivo)){
                return $this->genericResponse(null, 'No ingresado', 404);
            }

            if(!empty($datos_cabecera)){
                
                $pago_detalle_model=new  PagoDetalleModel();
                $resultado= $pago_cabecera_model->insertar($datos_cabecera);     
                                
                
                $pac_id=$resultado[0]['pac_id'];
                //$pac_id=$resultado->pac_id;

                if(!empty($datos_detalle)){                    
                    foreach ($datos_detalle as  $value) {
                        $dato_detalle=array(
                            "pad_fecha_pago"=> $value['fecha_pago'],
                            "pad_fecha_transaccion"=> $value['fecha_transaccion'],
                            "pad_comercio"=> $value['comercio'],
                            "pad_numero_retencion"=> $value['numero_retencion'],
                            "pad_monto_depositado"=> $value['monto_depositado'],
                            "pad_total_pagar"=> $value['total_pagar'],
                            "pad_retencion_iva"=> $value['retencion_iva'],
                            "pad_retencion_fuente"=> $value['retencion_fuente'],
                            "pad_porcentaje_comision"=> $value['porcentaje_comision'],
                            "pad_descuento_comision"=> $value['descuento_comision'],
                            "pad_autorizacion"=> $value['autorizacion'],               
                            "pad_lote"=> $value['lote'],
                            "pad_id_terminal"=> $value['id_terminal'],
                            "pad_cuenta_contable_banco"=> $value['cuentacontable_banco'],
                            "pac_id"=> $pac_id,
                            "tic_id"=> 1,
                            "pad_estado"=> 1,   
                            "cco_centro_costo"=> $value['centro_costo'], 
                            "pad_numero_tarjeta"=> $value['numero_tarjeta'], 
                        );
                        $pago_detalle_model->insertar($dato_detalle);       
                    }
                }
                return $this->genericResponse($pac_id, null, 200);
            }    
            return $this->genericResponse(null, 'No ingresado', 404);
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }        
    }

    public function index()
    {

        try {
            $pago_cabecera_model=new  PagoCabeceraModel();
            $datos=$pago_cabecera_model->getPagoCabecera();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }
    public function eliminar()
    {

        try {

            $pac_id=$this->request->getPost('pacid');

            if(empty($pac_id)){
                return $this->genericResponse(null, "No hay datos", 404);
            }


            $pago_cabecera_model=new  PagoCabeceraModel();
            $pago_detalle_model=new  PagoDetalleModel();

            $resultado_detalle=$pago_detalle_model->getDatosSegunpacidticid($pac_id);  

            if(!empty($resultado_detalle)){
                return $this->genericResponse(null, "Existen datos conciliados", 404);
            }

            $pago_detalle_model->eliminarsegunpacid($pac_id);

            $pago_cabecera_model->eliminarsegunpacid($pac_id);

            return $this->genericResponse('Eliminado con exito', null, 200);



        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }

    public function show($ajc_id =null)        
    {        

        try {
            /*================================================
            =            Busqueda             =
            ================================================*/
            
            $ajustes_centavos_model=new  AjustesCentavosModel();
            $datos=$ajustes_centavos_model->getAjusteCentavo($ajc_id);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function delete($ajc_id = null)
    {
        try {
            /*================================================
            =            Eliminar         =
            ================================================*/

            $datos=array(
                "ajc_estado"=>0,
            );            
            $ajustes_centavos_model=new  AjustesCentavosModel();
            $ajustes_centavos_model->eliminar($ajc_id,$datos);           
            return $this->genericResponse("Eliminado con exito", null, 200);  

            /*=====  End of Eliminar ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function create()
    {

        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/

            $pac_descuento_comision=$this->request->getPost('pac_descuento_comision');
            $pac_monto_depositado=$this->request->getPost('pac_monto_depositado');
            $pac_total_pagar=$this->request->getPost('pac_total_pagar');
            $pac_retencion_iva=$this->request->getPost('pac_retencion_iva');
            $pac_retencion_fuente=$this->request->getPost('pac_retencion_fuente');
            $bap_id=$this->request->getPost('bap_id');
            $pac_fecha_carga=$this->request->getPost('pac_fecha_carga');
            $pac_nombre_archivo=$this->request->getPost('pac_nombre_archivo');
            $id_usuario=$this->request->getPost('id_usuario');
            $pac_estado=$this->request->getPost('pac_estado');
            
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "pac_descuento_comision"=> $pac_descuento_comision,
                "pac_monto_depositado"=> $pac_monto_depositado,
                "pac_total_pagar"=> $pac_total_pagar,
                "pac_retencion_iva"=> $pac_retencion_iva,
                "pac_retencion_fuente"=> $pac_retencion_fuente,
                "bap_id"=> $bap_id,
                "pac_fecha_carga"=> $pac_fecha_carga,
                "pac_nombre_archivo"=> $pac_nombre_archivo,
                "id_usuario"=> $id_usuario,
                "pac_estado"=> $pac_estado,               
            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([
                "pac_descuento_comision"=>'required|numeric',
                "pac_monto_depositado"=> 'required|numeric',
                "pac_total_pagar"=> 'required|numeric',
                "pac_retencion_iva"=> 'required|numeric',
                "pac_retencion_fuente"=> 'required|numeric',
                "bap_id"=> 'required|numeric',
                "pac_fecha_carga"=> 'required|valid_date',
                "pac_nombre_archivo"=> 'required|is_unique[tbl_pago_cabecera.pac_nombre_archivo]',
                "id_usuario"=> 'required|numeric',
                "pac_estado"=> 'required|numeric',   
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            insertar datos            =
            ======================================*/
            $pago_cabecera_model=new  PagoCabeceraModel();
            $resultado= $pago_cabecera_model->insertar($datos);            
            
            
            /*=====  End of insertar datos  ======*/            
            
            return $this->genericResponse($resultado,null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    public function update($ajc_id = null)
    {
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            $datos_ingresado = $this->request->getRawinput();            
            $ajc_valor_movimiento=$datos_ingresado['ajc_valor_movimiento'];
            $ajc_cuenta_contable=$datos_ingresado['ajc_cuenta_contable'];
            $ajc_fecha_contable=$datos_ingresado['ajc_fecha_contable'];
            $ajc_referencia_contable=$datos_ingresado['ajc_referencia_contable'];
            $ajc_observacion=$datos_ingresado['ajc_observacion'];
            $ajc_oficina=$datos_ingresado['ajc_oficina'];
            $ajc_sucursal=$datos_ingresado['ajc_sucursal'];
            $ajc_fecha_registro=$datos_ingresado['ajc_fecha_registro'];
            $ajc_centro_costo=$datos_ingresado['ajc_centro_costo'];
            $ajc_numero_comprobante =$datos_ingresado['ajc_numero_comprobante'];
            $ajc_usuario=$datos_ingresado['ajc_usuario'];
            $ajc_estado=$datos_ingresado['ajc_estado'];
            
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "ajc_valor_movimiento"=> $ajc_valor_movimiento,
                "ajc_cuenta_contable"=> $ajc_cuenta_contable,
                "ajc_fecha_contable"=> $ajc_fecha_contable,
                "ajc_referencia_contable"=> $ajc_referencia_contable,
                "ajc_observacion"=> $ajc_observacion,
                "ajc_oficina"=> $ajc_oficina,
                "ajc_sucursal"=> $ajc_sucursal,
                "ajc_fecha_registro"=> $ajc_fecha_registro,
                "ajc_centro_costo"=> $ajc_centro_costo,
                "ajc_numero_comprobante"=> $ajc_numero_comprobante,
                "ajc_usuario"=> $ajc_usuario,
                "ajc_estado"=> $ajc_estado,                
            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([

                "ajc_valor_movimiento"=> 'required',
                "ajc_cuenta_contable"=> 'required',
                "ajc_fecha_contable"=> 'required|valid_date',
                "ajc_referencia_contable"=> 'required',
                "ajc_observacion"=> 'required',
                "ajc_oficina"=> 'required',
                "ajc_sucursal"=> 'required',
                "ajc_fecha_registro"=> 'required|valid_date',
                "ajc_centro_costo"=> 'required',
                "ajc_numero_comprobante"=> 'required|numeric',
                "ajc_usuario"=> 'required',
                "ajc_estado"=> 'required|numeric',               
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            actualizar datos            =
            ======================================*/
            $ajustes_centavos_model=new  AjustesCentavosModel();
            $ajustes_centavos_model->actualizar($ajc_id,$datos);           
            
            /*=====  End of actualizar datos  ======*/        
            $existente=$ajustes_centavos_model->getAjusteCentavo($ajc_id);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }       
            


        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
    
    public function agregarreferenciacontable()
    {

        try {

            $pac_referencia_contable=$this->request->getPost('pac_referencia_contable');    
            $pac_id=$this->request->getPost('pac_id');    
            
            $datos =array(
                "pac_referencia_contable"=>$pac_referencia_contable,               
                
            );            
            
            $pago_cabecera_model=new  PagoCabeceraModel();
            $pago_cabecera_model->actualizar($pac_id,$datos);
            return $this->genericResponse('referencia contable ingresada',null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }
}