<?php

namespace App\Controllers;

use App\Models\ParametrizacionCentroCostoModel;
use CodeIgniter\RESTful\ResourceController;

class ParametrizacionCentroCosto extends ResourceController
{
    protected $format = 'json';
    public function index()
    {

        try {
            $parametrizacion_centro_costo_model=new  ParametrizacionCentroCostoModel();
            $datos=$parametrizacion_centro_costo_model->getParametrizacionCentroCosto();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }

    public function show($id   =null)        
    {        

        try {
            /*================================================
            =            Busqueda             =
            ================================================*/
            $pcc_oficina =$this->request->getPost('pcc_oficina');
            $pcc_centro_costo =$this->request->getPost('pcc_centro_costo');            
            
            $parametrizacion_centro_costo_model=new  ParametrizacionCentroCostoModel();
            $datos=$parametrizacion_centro_costo_model->getUnParametrizacionCentroCosto($pcc_oficina,$pcc_centro_costo);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function delete($id = null)
    {
        try {
            /*================================================
            =            Eliminar         =
            ================================================*/
            $pcc_oficina =$this->request->getPost('pcc_oficina');
            $pcc_centro_costo =$this->request->getPost('pcc_centro_costo');

            $datos=array(
                "pcc_estado"=>0,
            );            
            $parametrizacion_centro_costo_model=new  ParametrizacionCentroCostoModel();
            $parametrizacion_centro_costo_model->eliminar($pcc_oficina,$pcc_centro_costo,$datos);       
            return $this->genericResponse("Eliminado con exito", null, 200);  

            /*=====  End of Eliminar ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function create()
    {

        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            
            $pcc_oficina =$this->request->getPost('pcc_oficina');
            $pcc_centro_costo =$this->request->getPost('pcc_centro_costo');
            $pcc_estado =$this->request->getPost('pcc_estado');
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "pcc_oficina"=> $pcc_oficina,
                "pcc_centro_costo"=> $pcc_centro_costo,
                "pcc_estado"=> $pcc_estado,                
            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([                  

                "pcc_oficina"=> 'required',
                "pcc_centro_costo"=> 'required',
                "pcc_estado"=> 'required',               
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            insertar datos            =
            ======================================*/
            $parametrizacion_centro_costo_model=new  ParametrizacionCentroCostoModel();
            $parametrizacion_centro_costo_model->insertar($datos);            
            
            /*=====  End of insertar datos  ======*/            
            
            return $this->genericResponse("Ingresado con exito",null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    public function update($id = null)
    {
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            $datos_ingresado = $this->request->getRawinput();
            $pcc_oficina =$datos_ingresado['pcc_oficina'];
            $pcc_centro_costo =$datos_ingresado['pcc_centro_costo'];
            $pcc_estado =$datos_ingresado['pcc_estado'];
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "pcc_oficina"=> $pcc_oficina,
                "pcc_centro_costo"=> $pcc_centro_costo,
                "pcc_estado"=> $pcc_estado, 

            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([

                "pcc_oficina"=> 'required',
                "pcc_centro_costo"=> 'required',
                "pcc_estado"=> 'required',                
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            actualizar datos            =
            ======================================*/
            $parametrizacion_centro_costo_model=new  ParametrizacionCentroCostoModel();
            $parametrizacion_centro_costo_model->actualizar($pcc_oficina,$pcc_centro_costo,$datos);           
            
            /*=====  End of actualizar datos  ======*/        
            $existente=$parametrizacion_centro_costo_model->getUnParametrizacionCentroCosto($pcc_oficina,$pcc_centro_costo);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }       
            


        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}