<?php

namespace App\Controllers;

use App\Models\ReferenciasBancariasCabeceraModel;
use CodeIgniter\RESTful\ResourceController;

class ReferenciasBancariasCabecera extends ResourceController
{
    protected $format = 'json';
    //PREGUNTAR SI ESTE CAMPO rbc_codigo_referencia_bancaria se lo puede cambiar en el metodo (update)
    public function index()
    {

        try {
            $referencias_bancarias_cabecera_model=new  ReferenciasBancariasCabeceraModel();
            $datos=$referencias_bancarias_cabecera_model->getReferenciasBancariasCabecera();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }

    public function show($rbc_codigo_referencia_bancaria     =null)        
    {        

        try {
            /*================================================
            =            Busqueda             =
            ================================================*/
            
            $referencias_bancarias_cabecera_model=new  ReferenciasBancariasCabeceraModel();
            $datos=$referencias_bancarias_cabecera_model->getUnReferenciasBancariasCabecera($rbc_codigo_referencia_bancaria);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function delete($rbc_codigo_referencia_bancaria = null)
    {
        try {
            /*================================================
            =            Eliminar         =
            ================================================*/

            $datos=array(
                "rbc_estado"=>0,
            );            
            $referencias_bancarias_cabecera_model=new  ReferenciasBancariasCabeceraModel();
            $referencias_bancarias_cabecera_model->eliminar($rbc_codigo_referencia_bancaria,$datos);          
            return $this->genericResponse("Eliminado con exito", null, 200);  

            /*=====  End of Eliminar ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function create()
    {

        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            
            $rbc_codigo_referencia_bancaria=$this->request->getPost('rbc_codigo_referencia_bancaria');
            $rbc_valor_total=$this->request->getPost('rbc_valor_total');
            $rbc_fecha_referencia=$this->request->getPost('rbc_fecha_referencia');
            $rbc_numero_referencia_bancaria=$this->request->getPost('rbc_numero_referencia_bancaria');
            $rbc_fecha_ingreso=$this->request->getPost('rbc_fecha_ingreso');
            $rbc_usuario_ingreso=$this->request->getPost('rbc_usuario_ingreso');
            $rbc_estado=$this->request->getPost('rbc_estado');
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "rbc_codigo_referencia_bancaria"=> $rbc_codigo_referencia_bancaria,
                "rbc_valor_total"=> $rbc_valor_total,
                "rbc_fecha_referencia"=> $rbc_fecha_referencia,
                "rbc_numero_referencia_bancaria"=> $rbc_numero_referencia_bancaria,
                "rbc_fecha_ingreso"=> $rbc_fecha_ingreso,
                "rbc_usuario_ingreso"=> $rbc_usuario_ingreso,
                "rbc_estado"=> $rbc_estado,
                              

            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([                  

                "rbc_codigo_referencia_bancaria"=> 'required',
                "rbc_valor_total"=> 'required|numeric',
                "rbc_fecha_referencia"=> 'required|valid_date',
                "rbc_numero_referencia_bancaria"=> 'required|numeric',
                "rbc_fecha_ingreso"=> 'required|valid_date',
                "rbc_usuario_ingreso"=> 'required',
                "rbc_estado"=> 'required',          
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            insertar datos            =
            ======================================*/
            $referencias_bancarias_cabecera_model=new  ReferenciasBancariasCabeceraModel();
            $referencias_bancarias_cabecera_model->insertar($datos);            
            
            /*=====  End of insertar datos  ======*/            
            
            return $this->genericResponse("Ingresado con exito",null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    public function update($rbc_codigo_referencia_bancaria = null)
    {
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            $datos_ingresado = $this->request->getRawinput();
            //$rbc_codigo_referencia_bancaria=$datos_ingresado['rbc_codigo_referencia_bancaria'];
            $rbc_valor_total=$datos_ingresado['rbc_valor_total'];
            $rbc_fecha_referencia=$datos_ingresado['rbc_fecha_referencia'];
            $rbc_numero_referencia_bancaria=$datos_ingresado['rbc_numero_referencia_bancaria'];
            $rbc_fecha_ingreso=$datos_ingresado['rbc_fecha_ingreso'];
            $rbc_usuario_ingreso=$datos_ingresado['rbc_usuario_ingreso'];
            $rbc_estado=$datos_ingresado['rbc_estado'];
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                //"rbc_codigo_referencia_bancaria"=> $rbc_codigo_referencia_bancaria,
                "rbc_valor_total"=> $rbc_valor_total,
                "rbc_fecha_referencia"=> $rbc_fecha_referencia,
                "rbc_numero_referencia_bancaria"=> $rbc_numero_referencia_bancaria,
                "rbc_fecha_ingreso"=> $rbc_fecha_ingreso,
                "rbc_usuario_ingreso"=> $rbc_usuario_ingreso,
                "rbc_estado"=> $rbc_estado,    

            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([
                //"rbc_codigo_referencia_bancaria"=> 'required',
                "rbc_valor_total"=> 'required|numeric',
                "rbc_fecha_referencia"=> 'required|valid_date',
                "rbc_numero_referencia_bancaria"=> 'required|numeric',
                "rbc_fecha_ingreso"=> 'required|valid_date',
                "rbc_usuario_ingreso"=> 'required',
                "rbc_estado"=> 'required',                           
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            actualizar datos            =
            ======================================*/
            $referencias_bancarias_cabecera_model=new  ReferenciasBancariasCabeceraModel();
            $referencias_bancarias_cabecera_model->actualizar($rbc_codigo_referencia_bancaria,$datos);        
            
            /*=====  End of actualizar datos  ======*/        
            $existente=$referencias_bancarias_cabecera_model->getUnReferenciasBancariasCabecera($rbc_codigo_referencia_bancaria);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }       
            


        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}