<?php

namespace App\Controllers;

use App\Models\RelacionPagosRetencionesModel;
use CodeIgniter\RESTful\ResourceController;

class RelacionPagosRetenciones extends ResourceController
{
    protected $format = 'json';

    public function index()
    {

        try {
            $relacion_pagos_retenciones_model=new  RelacionPagosRetencionesModel();
            $datos=$relacion_pagos_retenciones_model->getRelacionPagosRetenciones();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }

    public function show($id=null)        
    {


        try {
            /*================================================
            =            Busqueda por mes y año            =
            ================================================*/
            $rec_codigo_retencion  =$this->request->getPost('rec_codigo_retencion');        
            $pad_codigo_pago  =$this->request->getPost('pad_codigo_pago');
            $pad_numero_item   =$this->request->getPost('pad_numero_item');
            $relacion_pagos_retenciones_model=new  RelacionPagosRetencionesModel();
            $datos=$relacion_pagos_retenciones_model->getUnRelacionPagosRetenciones($rec_codigo_retencion,$pad_codigo_pago,$pad_numero_item);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda por cip_codigo_cierre  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function delete($id = null)
    {
        try {
            /*================================================
            =            Eliminar por mes-año            =
            ================================================*/

            $rec_codigo_retencion  =$this->request->getPost('rec_codigo_retencion');        
            $pad_codigo_pago  =$this->request->getPost('pad_codigo_pago');
            $pad_numero_item   =$this->request->getPost('pad_numero_item');
            $datos=array(
                "rpr_estado"=>0,
            );            
            $relacion_pagos_retenciones_model=new  RelacionPagosRetencionesModel();
            $relacion_pagos_retenciones_model->eliminar($rec_codigo_retencion,$pad_codigo_pago,$pad_numero_item,$datos);            
            return $this->genericResponse("Eliminado con exito", null, 200);  

            /*=====  End of Eliminar por ven_voucher  ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function create()
    {
        //PREGUNTAR:  SI SE GUARDA MARZO O 03 y validar los numeros de fechas.
        //no mes y año repetido
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            
            $rec_codigo_retencion  =$this->request->getPost('rec_codigo_retencion');        
            $pad_codigo_pago  =$this->request->getPost('pad_codigo_pago');
            $pad_numero_item   =$this->request->getPost('pad_numero_item');
            $rpr_valor_retencion=$this->request->getPost('rpr_valor_retencion');
            $rpr_tipo=$this->request->getPost('rpr_tipo');
            $rpr_saldo_retencion=$this->request->getPost('rpr_saldo_retencion');
            $rpr_fecha_saldo=$this->request->getPost('rpr_fecha_saldo');
            $rpr_estado=$this->request->getPost('rpr_estado');
            /*=====  End of Section Recoger datos Ingresados  ======*/

            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(


                "rec_codigo_retencion"=> $rec_codigo_retencion,
                "pad_codigo_pago"=> $pad_codigo_pago,
                "pad_numero_item"=> $pad_numero_item,
                "rpr_valor_retencion"=> $rpr_valor_retencion,
                "rpr_tipo"=> $rpr_tipo,
                "rpr_saldo_retencion"=> $rpr_saldo_retencion,
                "rpr_fecha_saldo"=> $rpr_fecha_saldo,
                "rpr_estado"=> $rpr_estado,

            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([

                "rec_codigo_retencion"=> 'required',
                "pad_codigo_pago"=> 'required',
                "pad_numero_item"=> 'required|numeric',
                "rpr_valor_retencion"=> 'required|numeric',
                "rpr_tipo"=> 'required',
                "rpr_saldo_retencion"=> 'required|numeric',
                "rpr_fecha_saldo"=> 'required|valid_date',
                "rpr_estado"=> 'required',               
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            $relacion_pagos_retenciones_model=new  RelacionPagosRetencionesModel();
            $relacion_pagos_retenciones_model->insertar($datos);
            return $this->genericResponse("Ingresado con exito", null, 200);  

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    public function update($id = null)
    {
        //PREGUNTAR:  SI SE GUARDA MARZO O 03 

        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            $datos_ingresado = $this->request->getRawinput();
            $rec_codigo_retencion  =$datos_ingresado['rec_codigo_retencion'];        
            $pad_codigo_pago  =$datos_ingresado['pad_codigo_pago'];
            $pad_numero_item   =$datos_ingresado['pad_numero_item'];
            $rpr_valor_retencion=$datos_ingresado['rpr_valor_retencion'];
            $rpr_tipo=$datos_ingresado['rpr_tipo'];
            $rpr_saldo_retencion=$datos_ingresado['rpr_saldo_retencion'];
            $rpr_fecha_saldo=$datos_ingresado['rpr_fecha_saldo'];
            $rpr_estado=$datos_ingresado['rpr_estado'];
            
            /*=====  End of Section Recoger datos Ingresados  ======*/

            
            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(

                "rec_codigo_retencion"=> $rec_codigo_retencion,
                "pad_codigo_pago"=> $pad_codigo_pago,
                "pad_numero_item"=> $pad_numero_item,
                "rpr_valor_retencion"=> $rpr_valor_retencion,
                "rpr_tipo"=> $rpr_tipo,
                "rpr_saldo_retencion"=> $rpr_saldo_retencion,
                "rpr_fecha_saldo"=> $rpr_fecha_saldo,
                "rpr_estado"=> $rpr_estado,               
            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([
                "rec_codigo_retencion"=> 'required',
                "pad_codigo_pago"=> 'required',
                "pad_numero_item"=> 'required|numeric',
                "rpr_valor_retencion"=> 'required|numeric',
                "rpr_tipo"=> 'required',
                "rpr_saldo_retencion"=> 'required|numeric',
                "rpr_fecha_saldo"=> 'required|valid_date',
                "rpr_estado"=> 'required',                
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            
            $relacion_pagos_retenciones_model=new  RelacionPagosRetencionesModel();
            $relacion_pagos_retenciones_model->actualizar($rec_codigo_retencion,$pad_codigo_pago,$pad_numero_item,$datos);      

            $existente=$relacion_pagos_retenciones_model->getUnRelacionPagosRetenciones($rec_codigo_retencion,$pad_codigo_pago,$pad_numero_item);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Retornamos datos actualizados  ======*/

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}