<?php

namespace App\Controllers;

use App\Models\RelacionPagosVentasModel;
use App\Models\DatosRelacionPagosVentasModel;
use App\Models\PagoDetalleModel;
use CodeIgniter\RESTful\ResourceController;

class RelacionPagosVentas extends ResourceController
{
    protected $format = 'json';
    public function index()
    {

        try {
            $relacion_pagos_ventas_model=new  RelacionPagosVentasModel();
            $datos=$relacion_pagos_ventas_model->getRelacionPagosVentas();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }

    public function estadisticasayervshoy(){
        $fecha = date("Y-m-d");      
        $fecha_ayer= date("Y-m-d",strtotime($fecha."- 1 days"));        
        $fecha_manana= date("Y-m-d",strtotime($fecha."+ 1 days"));
        $meses_anio=array("January","February","March","April","May","June","July","August","September","October","November","December");
        
        $relacion_pagos_ventas_model=new  RelacionPagosVentasModel();
        $datos_ayer=$relacion_pagos_ventas_model->getestadisticasdeundia($fecha_ayer,$fecha);
        $datos_hoy=$relacion_pagos_ventas_model->getestadisticasdeundia($fecha,$fecha_manana);
        $conciliaciones_anio=$relacion_pagos_ventas_model->getEstadisticasAnio();
        $pagos_anio=$relacion_pagos_ventas_model->getEstadisticasPagosAnio();
        $ventas_anio=$relacion_pagos_ventas_model->getEstadisticasVentasAnio();
        
        $mes=date('Y-m-01');
        
        $mes_siguiente= date("Y-m-01",strtotime($mes."+ 1 month"));
        
        $datos_mes=[];
        while ($mes<$mes_siguiente) {
            $aux=date("Y-m-d",strtotime($mes."+ 1 days"));
            $dia=date("d",strtotime($mes));
            $cantidad=$relacion_pagos_ventas_model->getestadisticasdeundia($mes,$aux);
            $datos_mes[]=array(
                'dia' => $dia,
                'cantidad' =>!empty($cantidad[0]['rpv_id'])?$cantidad[0]['rpv_id']:0,
            );
            $mes= date("Y-m-d",strtotime($mes."+ 1 days"));
            
        }
        
        $conciliaciones_anio_mes="";
        $cantidad=0;
        $i=0;
        foreach($meses_anio as $m)
        {
            $cantidad=0;
            foreach($conciliaciones_anio as $c)
            {
                if($c['mes']==$m)
                {
                    $cantidad=$c['cantidad']; 
                    break;
                }
                else
                {
                    $cantidad=0;
                }
            }
            if($i==0)
            {
                $conciliaciones_anio_mes=$cantidad;
                $i++;
            }
            else
            {
                $conciliaciones_anio_mes=$conciliaciones_anio_mes.','.$cantidad;
            }
        }
        
        $pagos_anio_mes="";
        $cantidad=0;
        $i=0;
        foreach($meses_anio as $m)
        {
            $cantidad=0;
            foreach($pagos_anio as $c)
            {
                if($c['mes']==$m)
                {
                    $cantidad=$c['cantidad']; 
                    break;
                }
                else
                {
                    $cantidad=0;
                }
            }
            if($i==0)
            {
                $pagos_anio_mes=$cantidad;
                $i++;
            }
            else
            {
                $pagos_anio_mes=$pagos_anio_mes.','.$cantidad;
            }
        }
        
        $ventas_anio_mes="";
        $cantidad=0;
        $i=0;
        foreach($meses_anio as $m)
        {
            $cantidad=0;
            foreach($ventas_anio as $c)
            {
                if($c['mes']==$m)
                {
                    $cantidad=$c['cantidad']; 
                    break;
                }
                else
                {
                    $cantidad=0;
                }
            }
            if($i==0)
            {
                $ventas_anio_mes=$cantidad;
                $i++;
            }
            else
            {
                $ventas_anio_mes=$ventas_anio_mes.','.$cantidad;
            }
        }
        
        $pad_fecha = date("Y-m-d");      
        $pad_fecha_ayer= date("Y-m-d",strtotime($pad_fecha."- 1 days"));     

        $pago_detalle_model=new  PagoDetalleModel();
        $pad_datos_ayer=$pago_detalle_model->getestadisticasdeundia($pad_fecha_ayer,$pad_fecha_ayer);
        
        $pad_datos_hoy=$pago_detalle_model->getestadisticasdeundia($pad_fecha,$pad_fecha);

        $dato=array(
            'rpv_cantidad_ayer'=>!empty($datos_ayer[0]['rpv_id'])?$datos_ayer[0]['rpv_id']:0,
            'rpv_cantidad_hoy'=>!empty($datos_hoy[0]['rpv_id'])?$datos_hoy[0]['rpv_id']:0,
            'rpv_cantidad_mes'=>$datos_mes,

            'pad_cantidad_ayer'=>!empty($pad_datos_ayer[0]['pad_id'])?$pad_datos_ayer[0]['pad_id']:0,
            'pad_cantidad_hoy'=>!empty($pad_datos_hoy[0]['pad_id'])?$pad_datos_hoy[0]['pad_id']:0,
            'rpv_anio'=>$conciliaciones_anio_mes,
            'pagos_anio'=>$pagos_anio_mes,
            'ventas_anio'=>$ventas_anio_mes,
        );

        return $this->genericResponse($dato, null, 200);
    }

    public function reportemayorconciliado()
    {

        try {
            $desde =$this->request->getPost('desde');
            $hasta =$this->request->getPost('hasta');
            $tipobusqueda =$this->request->getPost('tipobusqueda');
            //print_r($desde+' '+$hasta+' '+$tipobusqueda);
            $relacion_pagos_ventas_model=new  RelacionPagosVentasModel();
            $datos_relacion_pagos_ventas_model=new  DatosRelacionPagosVentasModel();

            $datos=$relacion_pagos_ventas_model->getRelacionPagosVentas($desde,$hasta,$tipobusqueda);
            $retornar=[];
            if(!empty($datos)){
                $nuevos_datos=[];
                foreach ($datos as  $value) {
                    $nuevos_datos=$datos_relacion_pagos_ventas_model->getUnDatoRelacionPagosVentas($value['rpv_id']);
                    $retornar[]=array(
                        'rpv_id'=>$value['rpv_id'],
                        'rpv_referencia_contable'=>$value['rpv_referencia_contable'],
                        'rpv_fecha_cruce'=>$value['rpv_fecha_cruce'],
                        'rpv_valor_pago'=>$value['rpv_valor_pago'],
                        'rpv_porcentaje_comision_pago'=>$value['rpv_porcentaje_comision_pago'],
                        'rpv_descuento_comision_pago'=>$value['rpv_descuento_comision_pago'],
                        'rpv_valor_venta'=>$value['rpv_valor_venta'],
                        'rpv_porcentaje_comision_venta'=>$value['rpv_porcentaje_comision_venta'],
                        'rpv_descuento_comision_venta'=>$value['rpv_descuento_comision_venta'],
                        'rpv_valor_diferencia_pago'=>$value['rpv_valor_diferencia_pago'],
                        'rpv_frecuencia_pago'=>$value['rpv_frecuencia_pago'],
                        'rpv_estado'=>$value['rpv_estado'],
                        'datos_cruzados'=>$nuevos_datos,
                    );
                }
            }

            if(!empty($retornar)){
                return $this->genericResponse($retornar, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }
    
    public function reportesaldocentavos()
    {

        try {
            $desde =$this->request->getPost('desde');
            $hasta =$this->request->getPost('hasta');
            $relacion_pagos_ventas_model=new  RelacionPagosVentasModel();

            $datos=$relacion_pagos_ventas_model->getSaldosCentavos($desde,$hasta);
            $retornar=[];
            if(!empty($datos)){
                foreach ($datos as  $value) {
                    $retornar[]=array(
                        'rpv_id'=>$value['rpv_id'],
                        'rpv_referencia_contable'=>$value['rpv_referencia_contable'],
                        'rpv_fecha_cruce'=>$value['rpv_fecha_cruce'],
                        'rpv_valor_pago'=>$value['rpv_valor_pago'],
                        'rpv_porcentaje_comision_pago'=>$value['rpv_porcentaje_comision_pago'],
                        'rpv_descuento_comision_pago'=>$value['rpv_descuento_comision_pago'],
                        'rpv_valor_venta'=>$value['rpv_valor_venta'],
                        'rpv_porcentaje_comision_venta'=>$value['rpv_porcentaje_comision_venta'],
                        'rpv_descuento_comision_venta'=>$value['rpv_descuento_comision_venta'],
                        'rpv_valor_diferencia_pago'=>$value['rpv_valor_diferencia_pago'],
                        'rpv_frecuencia_pago'=>$value['rpv_frecuencia_pago'],
                        'rpv_estado'=>$value['rpv_estado'],
                    );
                }
            }

            if(!empty($retornar)){
                return $this->genericResponse($retornar, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }
    
    public function shownumeroconciliacion($id   =null)        
    {        

        try {
            /*================================================
            =            Busqueda             =
            ================================================*/
            $rpv_numero_conciliacion=$this->request->getPost('rpv_numero_conciliacion');          
            
            $relacion_pagos_ventas_model=new  RelacionPagosVentasModel();
            $datos=$relacion_pagos_ventas_model->getRelacionPagosVentas_numero_conciliacion($rpv_numero_conciliacion);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }
    public function comprarnumeroconciliacion()        
    {        

        try {

            $rpv_id=$this->request->getPost('rpv_id'); 

            $relacion_pagos_ventas_model=new  RelacionPagosVentasModel();
            $datos=$relacion_pagos_ventas_model->getComprobarRelacionPagosVentas($rpv_id);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }
    
    public function comprobarnumeroconciliacionFechaCruce()        
    {        

        try {

            $rpv_fecha_cruce=$this->request->getPost('rpv_fecha_cruce'); 

            $relacion_pagos_ventas_model=new  RelacionPagosVentasModel();
            $datos=$relacion_pagos_ventas_model->getComprobarRelacionPagosVentasFechaCruce($rpv_fecha_cruce);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }
    
    public function showrelacionpagosventas($id   =null)        
    {        

        try {
            /*================================================
            =            Busqueda             =
            ================================================*/
            $rpv_fecha_cruce_desde=$this->request->getPost('rpv_fecha_cruce_desde'); 
            $rpv_fecha_cruce_hasta=$this->request->getPost('rpv_fecha_cruce_hasta'); 
            $relacion_pagos_ventas_model=new  RelacionPagosVentasModel();
            $datos=$relacion_pagos_ventas_model-> getUnRelacionPagosVentas($rpv_fecha_cruce_desde,$rpv_fecha_cruce_hasta);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }
    
    public function verConciliacion()        
    {        

        try {
            $relacion_pagos_ventas_model=new  RelacionPagosVentasModel();
            $rpv_id=$this->request->getPost('rpv_id'); 
            $rpv_venta=$relacion_pagos_ventas_model->getDatosConciliacionVentas_numero_conciliacion($rpv_id);
            $rpv_pago=$relacion_pagos_ventas_model->getDatosConciliacionPagos_numero_conciliacion($rpv_id);
            $datos=array('ventas'=>$rpv_venta,'pagos'=>$rpv_pago);
            
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function delete($id = null)
    {
        try {
            /*================================================
            =            Eliminar         =
            ================================================*/
            $ven_codigo=$this->request->getPost('ven_codigo');           
            $pad_codigo_pago=$this->request->getPost('pad_codigo_pago');            
            $pad_numero_item=$this->request->getPost('pad_numero_item');            
            

            $datos=array(

                "rpv_estado"=>0,
            );      

            $relacion_pagos_ventas_model=new  RelacionPagosVentasModel();
            $relacion_pagos_ventas_model->eliminar($ven_codigo,$pad_codigo_pago,$pad_numero_item,$datos);           
            return $this->genericResponse("Eliminado con exito", null, 200);  

            /*=====  End of Eliminar ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }
    public function desconciliacioneliminar()
    {
        try {
            $rpv_id=$this->request->getPost('rpv_id'); 

            $relacion_pagos_ventas_model=new  RelacionPagosVentasModel();
            $relacion_pagos_ventas_model->borrar($rpv_id);           
            return $this->genericResponse("Eliminado con exito", null, 200);  

            /*=====  End of Eliminar ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function create()
    {

        try {

         
            $rpv_referencia_contable=$this->request->getPost('rpv_referencia_contable');    
            $rpv_fecha_cruce=$this->request->getPost('rpv_fecha_cruce');    
            $rpv_valor_pago=$this->request->getPost('rpv_valor_pago');    
            $rpv_porcentaje_comision_pago=$this->request->getPost('rpv_porcentaje_comision_pago');    
            $rpv_descuento_comision_pago=$this->request->getPost('rpv_descuento_comision_pago');    
            $rpv_valor_venta=$this->request->getPost('rpv_valor_venta');    
            $rpv_porcentaje_comision_venta=$this->request->getPost('rpv_porcentaje_comision_venta');    
            $rpv_descuento_comision_venta=$this->request->getPost('rpv_descuento_comision_venta');    
            $rpv_valor_diferencia_pago=$this->request->getPost('rpv_valor_diferencia_pago');    
            $rpv_frecuencia_pago=$this->request->getPost('rpv_frecuencia_pago');    
            $rpv_estado=$this->request->getPost('rpv_estado');    
            $datos =array(
                "rpv_referencia_contable"=>$rpv_referencia_contable,                
                "rpv_fecha_cruce"=>$rpv_fecha_cruce,
                "rpv_valor_pago"=>$rpv_valor_pago,
                "rpv_porcentaje_comision_pago"=>$rpv_porcentaje_comision_pago,
                "rpv_descuento_comision_pago"=>$rpv_descuento_comision_pago,
                "rpv_valor_venta"=>$rpv_valor_venta,
                "rpv_porcentaje_comision_venta"=>$rpv_porcentaje_comision_venta,
                "rpv_descuento_comision_venta"=>$rpv_descuento_comision_venta,
                "rpv_valor_diferencia_pago"=>$rpv_valor_diferencia_pago,
                "rpv_frecuencia_pago"=>$rpv_frecuencia_pago,
                "rpv_estado"=>$rpv_estado,

            );            
            
            $relacion_pagos_ventas_model=new  RelacionPagosVentasModel();
            $resultado=$relacion_pagos_ventas_model->insertar($datos);
            
            return $this->genericResponse($resultado,null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }
    public function agregarreferenciacontable()
    {

        try {

            $rpv_referencia_contable=$this->request->getPost('rpv_referencia_contable');    
            $rpv_id=$this->request->getPost('rpv_id');    
            
            $datos =array(
                "rpv_referencia_contable"=>$rpv_referencia_contable,               
                
            );            
            
            $relacion_pagos_ventas_model=new  RelacionPagosVentasModel();
            $relacion_pagos_ventas_model->actualizardatos($rpv_id,$datos);
            return $this->genericResponse('referencia contable ingresada',null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    

    public function update($id = null)
    {
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            $datos_ingresado = $this->request->getRawinput();
            $ven_codigo=$datos_ingresado['ven_codigo'];
            $pad_codigo_pago=$datos_ingresado['pad_codigo_pago'];
            $pad_numero_item=$datos_ingresado['pad_numero_item'];
            $rpv_fecha_cruce=$datos_ingresado['rpv_fecha_cruce'];
            $rpv_valor_pago=$datos_ingresado['rpv_valor_pago'];
            $rpv_valor_venta=$datos_ingresado['rpv_valor_venta'];
            $rpv_numero_cuota=$datos_ingresado['rpv_numero_cuota'];
            $rpv_diferencia_comision=$datos_ingresado['rpv_diferencia_comision'];
            $rpv_diferencia_retencion=$datos_ingresado['rpv_diferencia_retencion'];
            $rpv_diferencia_retencion_iva=$datos_ingresado['rpv_diferencia_retencion_iva'];
            $rpv_diferencia_venta=$datos_ingresado['rpv_diferencia_venta'];
            $rpv_estado=$datos_ingresado['rpv_estado'];
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "ven_codigo"=>$ven_codigo,
                "pad_codigo_pago"=>$pad_codigo_pago,
                "pad_numero_item"=>$pad_numero_item,
                "rpv_fecha_cruce"=>$rpv_fecha_cruce,
                "rpv_valor_pago"=>$rpv_valor_pago,
                "rpv_valor_venta"=>$rpv_valor_venta,
                "rpv_numero_cuota"=>$rpv_numero_cuota,
                "rpv_diferencia_comision"=>$rpv_diferencia_comision,
                "rpv_diferencia_retencion"=>$rpv_diferencia_retencion,
                "rpv_diferencia_retencion_iva"=>$rpv_diferencia_retencion_iva,
                "rpv_diferencia_venta"=>$rpv_diferencia_venta,
                "rpv_estado"=>$rpv_estado,

            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([

                "ven_codigo"=>'required',
                "pad_codigo_pago"=>'required',
                "pad_numero_item"=>'required|numeric',
                "rpv_fecha_cruce"=>'required|valid_date',
                "rpv_valor_pago"=>'required|numeric',
                "rpv_valor_venta"=>'required|numeric',
                "rpv_numero_cuota"=>'required|numeric',
                "rpv_diferencia_comision"=>'required|numeric',
                "rpv_diferencia_retencion"=>'required|numeric',
                "rpv_diferencia_retencion_iva"=>'required|numeric',
                "rpv_diferencia_venta"=>'required|numeric',
                "rpv_estado"=>'required',                  
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            actualizar datos            =
            ======================================*/
            $relacion_pagos_ventas_model=new  RelacionPagosVentasModel();
            $relacion_pagos_ventas_model->actualizar($ven_codigo,$pad_codigo_pago,$pad_numero_item,$datos);           
            
            /*=====  End of actualizar datos  ======*/        
            $existente=$relacion_pagos_ventas_model->getUnRelacionPagosVentas($ven_codigo,$pad_codigo_pago,$pad_numero_item);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }       
            


        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
    
    
}