<?php

namespace App\Controllers;

use App\Models\RetencionCabeceraModel;
use CodeIgniter\RESTful\ResourceController;

class RetencionCabecera extends ResourceController
{
    protected $format = 'json';
    public function index()
    {

        try {
            $retencion_cabecera_model=new  RetencionCabeceraModel();
            $datos=$retencion_cabecera_model->getRetencionCabecera();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }

    public function show($rec_codigo_retencion   =null)        
    {        

        try {
            /*================================================
            =            Busqueda             =
            ================================================*/
            
            $retencion_cabecera_model=new  RetencionCabeceraModel();
            $datos=$retencion_cabecera_model->getUnRetencionCabecera($rec_codigo_retencion);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function delete($rec_codigo_retencion = null)
    {
        try {
            /*================================================
            =            Eliminar         =
            ================================================*/
            
            $datos=array(
                "rec_estado"=>0,
            );            
            $retencion_cabecera_model=new  RetencionCabeceraModel();
            $retencion_cabecera_model->eliminar($rec_codigo_retencion,$datos);           
            return $this->genericResponse("Eliminado con exito", null, 200);  

            /*=====  End of Eliminar ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function create()
    {

        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            
            $rec_porcentaje=$this->request->getPost('rec_porcentaje');
            $rec_motivo=$this->request->getPost('rec_motivo');
            $rec_tipo=$this->request->getPost('rec_tipo');
            $rec_anio_fiscal=$this->request->getPost('rec_anio_fiscal');
            $rec_total_pagos_retenciones=$this->request->getPost('rec_total_pagos_retenciones');
            $rec_total_retenciones=$this->request->getPost('rec_total_retenciones');
            $rec_saldo=$this->request->getPost('rec_saldo');
            $rec_saldo_afecta_gasto=$this->request->getPost('rec_saldo_afecta_gasto');
            $rec_fecha_ingreso=$this->request->getPost('rec_fecha_ingreso');
            $rec_usuario=$this->request->getPost('rec_usuario');
            $bap_codigo_banco=$this->request->getPost('bap_codigo_banco');
            $rec_ruc=$this->request->getPost('rec_ruc');
            $rec_razon_social=$this->request->getPost('rec_razon_social');
            $rec_son_saldos=$this->request->getPost('rec_son_saldos');
            $rec_referencia_contable=$this->request->getPost('rec_referencia_contable');
            $rec_fecha_contabilizacion=$this->request->getPost('rec_fecha_contabilizacion');
            $rec_fecha_afectacion_contable=$this->request->getPost('rec_fecha_afectacion_contable');
            $rec_cuenta_gasto=$this->request->getPost('rec_cuenta_gasto');
            $rec_estado=$this->request->getPost('rec_estado');
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "rec_porcentaje"=> $rec_porcentaje,
                "rec_motivo"=> $rec_motivo,
                "rec_tipo"=> $rec_tipo,
                "rec_anio_fiscal"=> $rec_anio_fiscal,
                "rec_total_pagos_retenciones"=> $rec_total_pagos_retenciones,
                "rec_total_retenciones"=> $rec_total_retenciones,
                "rec_saldo"=> $rec_saldo,
                "rec_saldo_afecta_gasto"=> $rec_saldo_afecta_gasto,
                "rec_fecha_ingreso"=> $rec_fecha_ingreso,
                "rec_usuario"=> $rec_usuario,
                "bap_codigo_banco"=> $bap_codigo_banco,
                "rec_ruc"=> $rec_ruc,
                "rec_razon_social"=> $rec_razon_social,
                "rec_son_saldos"=> $rec_son_saldos,
                "rec_referencia_contable"=> $rec_referencia_contable,
                "rec_fecha_contabilizacion"=> $rec_fecha_contabilizacion,
                "rec_fecha_afectacion_contable"=> $rec_fecha_afectacion_contable,
                "rec_cuenta_gasto"=> $rec_cuenta_gasto,
                "rec_estado"=> $rec_estado,


            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([                  
                   

                "rec_porcentaje"=> 'required|numeric',
                "rec_motivo"=> 'required',
                "rec_tipo"=>'required',
                "rec_anio_fiscal"=> 'required',
                "rec_total_pagos_retenciones"=> 'required|numeric',
                "rec_total_retenciones"=> 'required|numeric',
                "rec_saldo"=>'required|numeric',
                "rec_saldo_afecta_gasto"=> 'required|numeric',
                "rec_fecha_ingreso"=> 'required|valid_date',
                "rec_usuario"=> 'required',
                "bap_codigo_banco"=> 'required',
                "rec_ruc"=> 'required',
                "rec_razon_social"=> 'required',
                "rec_son_saldos"=> 'required|numeric',
                "rec_referencia_contable"=> 'required',
                "rec_fecha_contabilizacion"=> 'required|valid_date',
                "rec_fecha_afectacion_contable"=> 'required|valid_date',
                "rec_cuenta_gasto"=> 'required|numeric',
                "rec_estado"=> 'required',     
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            insertar datos            =
            ======================================*/
            $retencion_cabecera_model=new  RetencionCabeceraModel();
            $retencion_cabecera_model->insertar($datos);            
            
            /*=====  End of insertar datos  ======*/            
            
            return $this->genericResponse("Ingresado con exito",null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    public function update($rec_codigo_retencion = null)
    {
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            $datos_ingresado = $this->request->getRawinput();
            
            $rec_porcentaje=$datos_ingresado['rec_porcentaje'];
            $rec_motivo=$datos_ingresado['rec_motivo'];
            $rec_tipo=$datos_ingresado['rec_tipo'];
            $rec_anio_fiscal=$datos_ingresado['rec_anio_fiscal'];
            $rec_total_pagos_retenciones=$datos_ingresado['rec_total_pagos_retenciones'];
            $rec_total_retenciones=$datos_ingresado['rec_total_retenciones'];
            $rec_saldo=$datos_ingresado['rec_saldo'];
            $rec_saldo_afecta_gasto=$datos_ingresado['rec_saldo_afecta_gasto'];
            $rec_fecha_ingreso=$datos_ingresado['rec_fecha_ingreso'];
            $rec_usuario=$datos_ingresado['rec_usuario'];
            $bap_codigo_banco=$datos_ingresado['bap_codigo_banco'];
            $rec_ruc=$datos_ingresado['rec_ruc'];
            $rec_razon_social=$datos_ingresado['rec_razon_social'];
            $rec_son_saldos=$datos_ingresado['rec_son_saldos'];
            $rec_referencia_contable=$datos_ingresado['rec_referencia_contable'];
            $rec_fecha_contabilizacion=$datos_ingresado['rec_fecha_contabilizacion'];
            $rec_fecha_afectacion_contable=$datos_ingresado['rec_fecha_afectacion_contable'];
            $rec_cuenta_gasto=$datos_ingresado['rec_cuenta_gasto'];
            $rec_estado=$datos_ingresado['rec_estado'];
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "rec_porcentaje"=> $rec_porcentaje,
                "rec_motivo"=> $rec_motivo,
                "rec_tipo"=> $rec_tipo,
                "rec_anio_fiscal"=> $rec_anio_fiscal,
                "rec_total_pagos_retenciones"=> $rec_total_pagos_retenciones,
                "rec_total_retenciones"=> $rec_total_retenciones,
                "rec_saldo"=> $rec_saldo,
                "rec_saldo_afecta_gasto"=> $rec_saldo_afecta_gasto,
                "rec_fecha_ingreso"=> $rec_fecha_ingreso,
                "rec_usuario"=> $rec_usuario,
                "bap_codigo_banco"=> $bap_codigo_banco,
                "rec_ruc"=> $rec_ruc,
                "rec_razon_social"=> $rec_razon_social,
                "rec_son_saldos"=> $rec_son_saldos,
                "rec_referencia_contable"=> $rec_referencia_contable,
                "rec_fecha_contabilizacion"=> $rec_fecha_contabilizacion,
                "rec_fecha_afectacion_contable"=> $rec_fecha_afectacion_contable,
                "rec_cuenta_gasto"=> $rec_cuenta_gasto,
                "rec_estado"=> $rec_estado,

            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([

                "rec_porcentaje"=> 'required|numeric',
                "rec_motivo"=> 'required',
                "rec_tipo"=>'required',
                "rec_anio_fiscal"=> 'required',
                "rec_total_pagos_retenciones"=> 'required|numeric',
                "rec_total_retenciones"=> 'required|numeric',
                "rec_saldo"=>'required|numeric',
                "rec_saldo_afecta_gasto"=> 'required|numeric',
                "rec_fecha_ingreso"=> 'required|valid_date',
                "rec_usuario"=> 'required',
                "bap_codigo_banco"=> 'required',
                "rec_ruc"=> 'required',
                "rec_razon_social"=> 'required',
                "rec_son_saldos"=> 'required|numeric',
                "rec_referencia_contable"=> 'required',
                "rec_fecha_contabilizacion"=> 'required|valid_date',
                "rec_fecha_afectacion_contable"=> 'required|valid_date',
                "rec_cuenta_gasto"=> 'required|numeric',
                "rec_estado"=> 'required',             
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            actualizar datos            =
            ======================================*/
            $retencion_cabecera_model=new  RetencionCabeceraModel();
            $retencion_cabecera_model->actualizar($rec_codigo_retencion,$datos);           
            
            /*=====  End of actualizar datos  ======*/        
            $existente=$retencion_cabecera_model->getUnRetencionCabecera($rec_codigo_retencion);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }       
            


        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}