<?php

namespace App\Controllers;

use App\Models\RetencionDetalleModel;
use CodeIgniter\RESTful\ResourceController;

class RetencionDetalle extends ResourceController
{
    protected $format = 'json';
    public function index()
    {

        try {
            $retencion_detalle_model=new  RetencionDetalleModel();
            $datos=$retencion_detalle_model->getRetencionDetalle();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }

    public function show($id   =null)        
    {        

        try {
            /*================================================
            =            Busqueda             =
            ================================================*/
            $rec_codigo_retencion=$this->request->getPost('rec_codigo_retencion');
            $red_numero_item=$this->request->getPost('red_numero_item');          
            
            $retencion_detalle_model=new  RetencionDetalleModel();
            $datos=$retencion_detalle_model->getUnRetencionDetalle($rec_codigo_retencion,$red_numero_item);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function delete($id = null)
    {
        try {
            /*================================================
            =            Eliminar         =
            ================================================*/
            $rec_codigo_retencion=$this->request->getPost('rec_codigo_retencion');
            $red_numero_item=$this->request->getPost('red_numero_item');            

            $datos=array(
                "red_estado"=>0,
            );            
            $retencion_detalle_model=new  RetencionDetalleModel();
            $retencion_detalle_model->eliminar($rec_codigo_retencion,$red_numero_item,$datos);           
            return $this->genericResponse("Eliminado con exito", null, 200);  

            /*=====  End of Eliminar ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function create()
    {

        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            
            
            $rec_codigo_retencion=$this->request->getPost('rec_codigo_retencion');
            $red_numero_item=$this->request->getPost('red_numero_item');
            $red_ruc=$this->request->getPost('red_ruc');
            $red_razon_social=$this->request->getPost('red_razon_social');
            $red_factura=$this->request->getPost('red_factura');
            $red_autorizacion=$this->request->getPost('red_autorizacion');
            $red_serie=$this->request->getPost('red_serie');
            $red_fecha_retencion=$this->request->getPost('red_fecha_retencion');
            $red_fecha_caducidad=$this->request->getPost('red_fecha_caducidad');
            $red_numero_comprobante_retencion=$this->request->getPost('red_numero_comprobante_retencion');
            $red_base_imponible=$this->request->getPost('red_base_imponible');
            $red_valor_retencion=$this->request->getPost('red_valor_retencion');
            $red_saldo_retencion=$this->request->getPost('red_saldo_retencion');
            $red_es_saldo=$this->request->getPost('red_es_saldo');
            $red_referencia_codigo_retencion=$this->request->getPost('red_referencia_codigo_retencion');
            $red_referencia_numero_item=$this->request->getPost('red_referencia_numero_item');
            $red_referencia_contable=$this->request->getPost('red_referencia_contable');
            $red_fecha_contabilizacion=$this->request->getPost('red_fecha_contabilizacion');
            $red_valor_gravado_iva=$this->request->getPost('red_valor_gravado_iva');
            $red_valor_no_gravado_iva=$this->request->getPost('red_valor_no_gravado_iva');
            $red_valor_iva=$this->request->getPost('red_valor_iva');
            $red_motivo=$this->request->getPost('red_motivo');
            $red_porcentaje=$this->request->getPost('red_porcentaje');
            $red_estado=$this->request->getPost('red_estado');
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                
                "rec_codigo_retencion"=> $rec_codigo_retencion,
                "red_numero_item"=> $red_numero_item,
                "red_ruc"=> $red_ruc,
                "red_razon_social"=> $red_razon_social,
                "red_factura"=> $red_factura,
                "red_autorizacion"=> $red_autorizacion,
                "red_serie"=> $red_serie,
                "red_fecha_retencion"=> $red_fecha_retencion,
                "red_fecha_caducidad"=> $red_fecha_caducidad,
                "red_numero_comprobante_retencion"=> $red_numero_comprobante_retencion,
                "red_base_imponible"=> $red_base_imponible,
                "red_valor_retencion"=> $red_valor_retencion,
                "red_saldo_retencion"=> $red_saldo_retencion,
                "red_es_saldo"=> $red_es_saldo,
                "red_referencia_codigo_retencion"=> $red_referencia_codigo_retencion,
                "red_referencia_numero_item"=> $red_referencia_numero_item,
                "red_referencia_contable"=> $red_referencia_contable,
                "red_fecha_contabilizacion"=> $red_fecha_contabilizacion,
                "red_valor_gravado_iva"=> $red_valor_gravado_iva,
                "red_valor_no_gravado_iva"=> $red_valor_no_gravado_iva,
                "red_valor_iva"=> $red_valor_iva,
                "red_motivo"=> $red_motivo,
                "red_porcentaje"=> $red_porcentaje,
                "red_estado"=> $red_estado,
                   

            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([                  

                "rec_codigo_retencion"=> 'required',
                "red_numero_item"=> 'required|numeric',
                "red_ruc"=>'required',
                "red_razon_social"=> 'required',
                "red_factura"=> 'required',
                "red_autorizacion"=> 'required',
                "red_serie"=> 'required',
                "red_fecha_retencion"=> 'required|valid_date',
                "red_fecha_caducidad"=> 'required|valid_date',
                "red_numero_comprobante_retencion"=> 'required|numeric',
                "red_base_imponible"=> 'required',
                "red_valor_retencion"=> 'required|numeric',
                "red_saldo_retencion"=> 'required|numeric',
                "red_es_saldo"=> 'required|numeric',
                "red_referencia_codigo_retencion"=> 'required',
                "red_referencia_numero_item"=> 'required|numeric',
                "red_referencia_contable"=> 'required',
                "red_fecha_contabilizacion"=> 'required|valid_date',
                "red_valor_gravado_iva"=> 'required|numeric',
                "red_valor_no_gravado_iva"=> 'required|numeric',
                "red_valor_iva"=> 'required|numeric',
                "red_motivo"=> 'required',
                "red_porcentaje"=> 'required|numeric',
                "red_estado"=> 'required',          
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            insertar datos            =
            ======================================*/
            $retencion_detalle_model=new  RetencionDetalleModel();
            $retencion_detalle_model->insertar($datos);            
            
            /*=====  End of insertar datos  ======*/            
            
            return $this->genericResponse("Ingresado con exito",null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    public function update($id = null)
    {
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            $datos_ingresado = $this->request->getRawinput();
            $rec_codigo_retencion=$datos_ingresado['rec_codigo_retencion'];
            $red_numero_item=$datos_ingresado['red_numero_item'];
            $red_ruc=$datos_ingresado['red_ruc'];
            $red_razon_social=$datos_ingresado['red_razon_social'];
            $red_factura=$datos_ingresado['red_factura'];
            $red_autorizacion=$datos_ingresado['red_autorizacion'];
            $red_serie=$datos_ingresado['red_serie'];
            $red_fecha_retencion=$datos_ingresado['red_fecha_retencion'];
            $red_fecha_caducidad=$datos_ingresado['red_fecha_caducidad'];
            $red_numero_comprobante_retencion=$datos_ingresado['red_numero_comprobante_retencion'];
            $red_base_imponible=$datos_ingresado['red_base_imponible'];
            $red_valor_retencion=$datos_ingresado['red_valor_retencion'];
            $red_saldo_retencion=$datos_ingresado['red_saldo_retencion'];
            $red_es_saldo=$datos_ingresado['red_es_saldo'];
            $red_referencia_codigo_retencion=$datos_ingresado['red_referencia_codigo_retencion'];
            $red_referencia_numero_item=$datos_ingresado['red_referencia_numero_item'];
            $red_referencia_contable=$datos_ingresado['red_referencia_contable'];
            $red_fecha_contabilizacion=$datos_ingresado['red_fecha_contabilizacion'];
            $red_valor_gravado_iva=$datos_ingresado['red_valor_gravado_iva'];
            $red_valor_no_gravado_iva=$datos_ingresado['red_valor_no_gravado_iva'];
            $red_valor_iva=$datos_ingresado['red_valor_iva'];
            $red_motivo=$datos_ingresado['red_motivo'];
            $red_porcentaje=$datos_ingresado['red_porcentaje'];
            $red_estado=$datos_ingresado['red_estado'];
            /*=====  End of Section Recoger datos Ingresados  ======*/


            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "rec_codigo_retencion"=> $rec_codigo_retencion,
                "red_numero_item"=> $red_numero_item,
                "red_ruc"=> $red_ruc,
                "red_razon_social"=> $red_razon_social,
                "red_factura"=> $red_factura,
                "red_autorizacion"=> $red_autorizacion,
                "red_serie"=> $red_serie,
                "red_fecha_retencion"=> $red_fecha_retencion,
                "red_fecha_caducidad"=> $red_fecha_caducidad,
                "red_numero_comprobante_retencion"=> $red_numero_comprobante_retencion,
                "red_base_imponible"=> $red_base_imponible,
                "red_valor_retencion"=> $red_valor_retencion,
                "red_saldo_retencion"=> $red_saldo_retencion,
                "red_es_saldo"=> $red_es_saldo,
                "red_referencia_codigo_retencion"=> $red_referencia_codigo_retencion,
                "red_referencia_numero_item"=> $red_referencia_numero_item,
                "red_referencia_contable"=> $red_referencia_contable,
                "red_fecha_contabilizacion"=> $red_fecha_contabilizacion,
                "red_valor_gravado_iva"=> $red_valor_gravado_iva,
                "red_valor_no_gravado_iva"=> $red_valor_no_gravado_iva,
                "red_valor_iva"=> $red_valor_iva,
                "red_motivo"=> $red_motivo,
                "red_porcentaje"=> $red_porcentaje,
                "red_estado"=> $red_estado,

            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([

                "rec_codigo_retencion"=> 'required',
                "red_numero_item"=> 'required|numeric',
                "red_ruc"=>'required',
                "red_razon_social"=> 'required',
                "red_factura"=> 'required',
                "red_autorizacion"=> 'required',
                "red_serie"=> 'required',
                "red_fecha_retencion"=> 'required|valid_date',
                "red_fecha_caducidad"=> 'required|valid_date',
                "red_numero_comprobante_retencion"=> 'required|numeric',
                "red_base_imponible"=> 'required',
                "red_valor_retencion"=> 'required|numeric',
                "red_saldo_retencion"=> 'required|numeric',
                "red_es_saldo"=> 'required|numeric',
                "red_referencia_codigo_retencion"=> 'required',
                "red_referencia_numero_item"=> 'required|numeric',
                "red_referencia_contable"=> 'required',
                "red_fecha_contabilizacion"=> 'required|valid_date',
                "red_valor_gravado_iva"=> 'required|numeric',
                "red_valor_no_gravado_iva"=> 'required|numeric',
                "red_valor_iva"=> 'required|numeric',
                "red_motivo"=> 'required',
                "red_porcentaje"=> 'required|numeric',
                "red_estado"=> 'required',              
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            actualizar datos            =
            ======================================*/
            $retencion_detalle_model=new  RetencionDetalleModel();
            $retencion_detalle_model->actualizar($rec_codigo_retencion,$red_numero_item,$datos);           
            
            /*=====  End of actualizar datos  ======*/        
            $existente=$retencion_detalle_model->getUnRetencionDetalle($rec_codigo_retencion,$red_numero_item);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }       
            


        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}