<?php

namespace App\Controllers;

use App\Models\TipoPagoModel;
use CodeIgniter\RESTful\ResourceController;

class TipoPago extends ResourceController
{
   
    public function index()
    {

        try {
            $tipo_pago_model=new  TipoPagoModel();
            $datos=$tipo_pago_model->getTodoTipoPago();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function mostrar()        
    {        

        try {
            
            $tip_id=$this->request->getPost('tip_id');
            $tipo_pago_model=new  TipoPagoModel();
            $datos=$tipo_pago_model->getUnTipoPago($tip_id);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
           
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function eliminar()
    {
        try {
            
            $tipo_pago_model=new  TipoPagoModel();
            $tip_id=$this->request->getPost('tip_id');
            $datos=$tipo_pago_model->getUnTipoPago($tip_id);
            if(empty($datos)){
                return $this->genericResponse(null, "No Eliminado", 404);
            }
            $datos=array(
                "tip_estado"=>0,
            );            
                       
            $tipo_pago_model->eliminar($tip_id,$datos);           
            return $this->genericResponse("Eliminado con exito", null, 200);  

            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function crear()
    {

        try {
            
                        
            $tip_tipo_pago=$this->request->getPost('tip_tipo_pago');
            $tip_descripcion=$this->request->getPost('tip_descripcion');
            $tip_estado=$this->request->getPost('tip_estado');
            
            
            
            $datos =array(
                "tip_tipo_pago"=> $tip_tipo_pago,
                "tip_descripcion"=> $tip_descripcion,
                "tip_estado"=> $tip_estado,
                             
            );
            
            
            
            $validation =  \Config\Services::validation();
            $validation->setRules([
                
                "tip_tipo_pago"=> 'required',
                "tip_descripcion"=> 'required',
                "tip_estado"=> 'numeric',                       
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            
            $tipo_pago_model=new  TipoPagoModel();
            $tipo_pago_model->insertar($datos);            
            
             
            
            return $this->genericResponse("Ingresado con exito",null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function actualizar()
    {
        try {
            $tip_id=$this->request->getPost('tip_id');
            $tip_tipo_pago=$this->request->getPost('tip_tipo_pago');
            $tip_descripcion=$this->request->getPost('tip_descripcion');
            $tip_estado=$this->request->getPost('tip_estado');
            
            
            
            
            $datos =array(
                "tip_tipo_pago"=> $tip_tipo_pago,
                "tip_descripcion"=> $tip_descripcion,
                "tip_estado"=> $tip_estado,
                             
            );
            
            
            
            $validation =  \Config\Services::validation();
            $validation->setRules([
                
                "tip_tipo_pago"=> 'required',
                "tip_descripcion"=> 'required',
                "tip_estado"=> 'numeric',            
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            
            $tipo_pago_model=new  TipoPagoModel();
            $tipo_pago_model->actualizar($tip_id,$datos);           
            
            
            $existente=$tipo_pago_model->getUnTipoPago($tip_id);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }       
            
                

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}