<?php

namespace App\Controllers;

use App\Models\UsuarioModel;
use CodeIgniter\RESTful\ResourceController;

class Usuario extends ResourceController
{
    
    public function index()
    {

        try {
            $ajustes_centavos_model=new  AjustesCentavosModel();
            $datos=$ajustes_centavos_model->getAjustesCentavos();
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }
    public function login()
    {
        $usu_correo=$this->request->getPost('usu_correo');
        $usu_clave=$this->request->getPost('usu_clave');

        try {
            $usuario_model=new  UsuarioModel();
            $datos=$usuario_model->getLoginUsuario($usu_correo,$usu_clave);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }           

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

        
    }

    public function show($ajc_id =null)        
    {        

        try {
            /*================================================
            =            Busqueda             =
            ================================================*/
            
            $ajustes_centavos_model=new  AjustesCentavosModel();
            $datos=$ajustes_centavos_model->getAjusteCentavo($ajc_id);
            if(!empty($datos)){
                return $this->genericResponse($datos, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }   
            /*=====  End of Busqueda  ======*/
            
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
    }

    public function delete($ajc_id = null)
    {
        try {
            /*================================================
            =            Eliminar         =
            ================================================*/

            $datos=array(
                "ajc_estado"=>0,
            );            
            $ajustes_centavos_model=new  AjustesCentavosModel();
            $ajustes_centavos_model->eliminar($ajc_id,$datos);           
            return $this->genericResponse("Eliminado con exito", null, 200);  

            /*=====  End of Eliminar ======*/
        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
    }

    public function create()
    {

        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
                        
            $ajc_valor_movimiento=$this->request->getPost('ajc_valor_movimiento');
            $ajc_cuenta_contable=$this->request->getPost('ajc_cuenta_contable');
            $ajc_fecha_contable=$this->request->getPost('ajc_fecha_contable');
            $ajc_referencia_contable=$this->request->getPost('ajc_referencia_contable');
            $ajc_observacion=$this->request->getPost('ajc_observacion');
            $ajc_oficina=$this->request->getPost('ajc_oficina');
            $ajc_sucursal=$this->request->getPost('ajc_sucursal');
            $ajc_fecha_registro=$this->request->getPost('ajc_fecha_registro');
            $ajc_centro_costo=$this->request->getPost('ajc_centro_costo');
            $ajc_numero_comprobante =$this->request->getPost('ajc_numero_comprobante');
            $ajc_usuario=$this->request->getPost('ajc_usuario');
            $ajc_estado=$this->request->getPost('ajc_estado');
            
            /*=====  End of Section Recoger datos Ingresados  ======*/

           
            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "ajc_valor_movimiento"=> $ajc_valor_movimiento,
                "ajc_cuenta_contable"=> $ajc_cuenta_contable,
                "ajc_fecha_contable"=> $ajc_fecha_contable,
                "ajc_referencia_contable"=> $ajc_referencia_contable,
                "ajc_observacion"=> $ajc_observacion,
                "ajc_oficina"=> $ajc_oficina,
                "ajc_sucursal"=> $ajc_sucursal,
                "ajc_fecha_registro"=> $ajc_fecha_registro,
                "ajc_centro_costo"=> $ajc_centro_costo,
                "ajc_numero_comprobante"=> $ajc_numero_comprobante,
                "ajc_usuario"=> $ajc_usuario,
                "ajc_estado"=> $ajc_estado,                
            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([
                
                "ajc_valor_movimiento"=> 'required',
                "ajc_cuenta_contable"=> 'required',
                "ajc_fecha_contable"=> 'required|valid_date',
                "ajc_referencia_contable"=> 'required',
                "ajc_observacion"=> 'required',
                "ajc_oficina"=> 'required',
                "ajc_sucursal"=> 'required',
                "ajc_fecha_registro"=> 'required|valid_date',
                "ajc_centro_costo"=> 'required',
                "ajc_numero_comprobante"=> 'required|numeric',
                "ajc_usuario"=> 'required',
                "ajc_estado"=> 'required|numeric',               
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            insertar datos            =
            ======================================*/
            $ajustes_centavos_model=new  AjustesCentavosModel();
            $ajustes_centavos_model->insertar($datos);            
            
            /*=====  End of insertar datos  ======*/            
            
            return $this->genericResponse("Ingresado con exito",null, 200);     

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }
        
        
    }

    public function update($ajc_id = null)
    {
        try {
            /*=============================================
            =            Recoger datos Ingresados            =
            =============================================*/
            $datos_ingresado = $this->request->getRawinput();            
            $ajc_valor_movimiento=$datos_ingresado['ajc_valor_movimiento'];
            $ajc_cuenta_contable=$datos_ingresado['ajc_cuenta_contable'];
            $ajc_fecha_contable=$datos_ingresado['ajc_fecha_contable'];
            $ajc_referencia_contable=$datos_ingresado['ajc_referencia_contable'];
            $ajc_observacion=$datos_ingresado['ajc_observacion'];
            $ajc_oficina=$datos_ingresado['ajc_oficina'];
            $ajc_sucursal=$datos_ingresado['ajc_sucursal'];
            $ajc_fecha_registro=$datos_ingresado['ajc_fecha_registro'];
            $ajc_centro_costo=$datos_ingresado['ajc_centro_costo'];
            $ajc_numero_comprobante =$datos_ingresado['ajc_numero_comprobante'];
            $ajc_usuario=$datos_ingresado['ajc_usuario'];
            $ajc_estado=$datos_ingresado['ajc_estado'];
            
            /*=====  End of Section Recoger datos Ingresados  ======*/

           
            /*===================================================
            =            Compactar datos en un array            =
            ===================================================*/
            
            $datos =array(
                "ajc_valor_movimiento"=> $ajc_valor_movimiento,
                "ajc_cuenta_contable"=> $ajc_cuenta_contable,
                "ajc_fecha_contable"=> $ajc_fecha_contable,
                "ajc_referencia_contable"=> $ajc_referencia_contable,
                "ajc_observacion"=> $ajc_observacion,
                "ajc_oficina"=> $ajc_oficina,
                "ajc_sucursal"=> $ajc_sucursal,
                "ajc_fecha_registro"=> $ajc_fecha_registro,
                "ajc_centro_costo"=> $ajc_centro_costo,
                "ajc_numero_comprobante"=> $ajc_numero_comprobante,
                "ajc_usuario"=> $ajc_usuario,
                "ajc_estado"=> $ajc_estado,                
            );
            
            /*=====  End of Compactar datos en un array  ======*/
            
            /*========================================================================
            =            Validar Valores para el ingreso el base de datos            =
            ========================================================================*/
            
            $validation =  \Config\Services::validation();
            $validation->setRules([
                
                "ajc_valor_movimiento"=> 'required',
                "ajc_cuenta_contable"=> 'required',
                "ajc_fecha_contable"=> 'required|valid_date',
                "ajc_referencia_contable"=> 'required',
                "ajc_observacion"=> 'required',
                "ajc_oficina"=> 'required',
                "ajc_sucursal"=> 'required',
                "ajc_fecha_registro"=> 'required|valid_date',
                "ajc_centro_costo"=> 'required',
                "ajc_numero_comprobante"=> 'required|numeric',
                "ajc_usuario"=> 'required',
                "ajc_estado"=> 'required|numeric',               
            ]);
            $validation->withRequest($this->request)->run();
            if($validation->getErrors()){
                $errores = $validation->getErrors();                 
                return $this->genericResponse(null, $errores, 404);
            }
            
            /*=====  End of Validar Valores para el ingreso el base de datos  ======*/
            
            /*======================================
            =            actualizar datos            =
            ======================================*/
            $ajustes_centavos_model=new  AjustesCentavosModel();
            $ajustes_centavos_model->actualizar($ajc_id,$datos);           
            
            /*=====  End of actualizar datos  ======*/        
            $existente=$ajustes_centavos_model->getAjusteCentavo($ajc_id);
            if(!empty($existente)){
                return $this->genericResponse($existente, null, 200);
            }else{
                return $this->genericResponse(null, "No hay datos", 404);
            }       
            
                

        } catch (Exception $e) {  

            return $this->genericResponse(null, $e->getMessage(), 404);
        }

    }

    private function genericResponse($data, $msj, $code)
    {

        if ($code == 200) {
            return $this->respond(array(
                "data" => $data,
                "code" => $code
            )); //, 404, "No hay nada"
        } else {
            return $this->respond(array(
                "msj" => $msj,
                "code" => $code
            ));
        }
    }
}