<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class AjustesModel extends Model
{
    public function getTodosAjustes()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_terceros');
        $builder->select('tbl_terceros.*');       
        $builder->orderBy('tbl_terceros.ter_nombres', 'ASC');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getTodosDependientes()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_dependientes');
        $builder->select('tbl_dependientes.*');       
        $builder->orderBy('tbl_dependientes.dep_nombres', 'ASC');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getTodosBancos()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_banco');
        $builder->select('tbl_banco.*');       
       // $builder->orderBy('tbl_banco.ban_nombre', 'ASC');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getUnAjuste($ter_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_terceros');
        $builder->select('tbl_terceros.*');    
        $builder->where('tbl_terceros.ter_id', $ter_id);        
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_terceros');        
		$builder->insert($data);

    }
    public function insertarDependientes($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_dependientes');        
		$builder->insert($data);

    }
    
    public function actualizar($ter_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_terceros');
        $builder->where('tbl_terceros.ter_id', $ter_id);
		return $builder->update($data);        
    }
    public function eliminar($ter_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_terceros');
        $builder->where('tbl_terceros.ter_id', $ter_id);   
		$builder->update($data);        
    }
    
    public function getNoConciliadoPago($filtro){
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_pago_detalle');
        if(count($filtro)!=0)
            $query = $builder->getWhere($filtro);
        else
            $query = $builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getNoConciliadoVentas($filtro){
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        if(count($filtro)!=0)
            $query = $builder->getWhere($filtro);
        else
            $query = $builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }

    public function ajustarVenta($id, $monto)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->where('ven_id', $id);   
		$builder->update($monto);    
    }

    public function ajustarPago($id, $monto)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_pago_detalle');
        $builder->where('pad_id', $id);   
		$builder->update($monto);    
    }

    public function insertAjuste($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_ajustes');
		$builder->insert($data);          
        $builder = $db->table('tbl_ajustes');
        $builder->select('tbl_ajustes.*');       
        $builder->orderBy('tbl_ajustes.aju_id', 'DESC');
        $builder->limit(1);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;       
    }
    
    public function insertVenta($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
		$builder->insert($data);          
        $builder = $db->table('tbl_venta');
        $builder->select('tbl_venta.*');       
        $builder->orderBy('tbl_venta.ven_id', 'DESC');
        $builder->limit(1);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;       
    }

    public function updateAjuste($id, $data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_ajustes');
        $builder->where('aju_id', $id);   
		$builder->update($data);    
    }
    
    public function updateVenta($id, $data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->where('ven_id', $id);   
		$builder->update($data);    
    }
    
    public function updatePagos($id, $data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_pago_detalle');
        $builder->where('pad_id', $id);   
		$builder->update($data);    
    }
    
    public function insertCobro($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_cobros');
		$builder->insert($data);          
        
    }

    public function updateCobro($id, $data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_cobros');
        $builder->where('cob_id', $id);   
		$builder->update($data);    
    }
    
    public function truncateDependientes()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_dependientes');
        $builder->truncate(); 
    }
    
    public function truncateTerceros()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_terceros');
        $builder->truncate(); 
    }
}