<?php 
namespace App\Models;

use CodeIgniter\Model;

class HistorialPagoDetalleModel extends Model
{
    public function gethistorialpagodetalle($desde,$hasta)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_historial_pago_detalle');
        $builder->select('tbl_historial_pago_detalle.*,tbl_tipo_consulta.*');  
        $builder->join('tbl_tipo_consulta', 'tbl_historial_pago_detalle.tic_id=tbl_tipo_consulta.tic_id');
        $builder->join('tbl_cierre_mes', 'tbl_cierre_mes.cim_id=tbl_historial_pago_detalle.cim_id');
        $builder->where('tbl_cierre_mes.cim_desde >=', $desde); 
        $builder->where('tbl_cierre_mes.cim_hasta <=', $hasta);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_historial_pago_detalle');
        $builder->set($data);
        $builder->insert();

    }

    public function selectpagodetalleconciliado($desde,$hasta,$tic_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_pago_detalle');
        $builder->where('tbl_pago_detalle.pad_fecha_transaccion <=', $hasta);
        $builder->where('tbl_pago_detalle.pad_fecha_cruce >=', $desde);
        $builder->where('tbl_pago_detalle.tic_id', $tic_id);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function selectpagodetallenoconciliado($desde,$hasta,$tic_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_pago_detalle');
        $builder->where('tbl_pago_detalle.pad_fecha_transaccion <=', $hasta);
        $builder->where('tbl_pago_detalle.tic_id', $tic_id);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function comprobarcierremes($desde,$hasta)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_cierre_mes');
        $builder->where('tbl_cierre_mes.cim_desde', $desde); 
        $builder->where('tbl_cierre_mes.cim_hasta', $hasta);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function comprobarcierremesanterior($desde,$hasta)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_cierre_mes');
        $builder->where('tbl_cierre_mes.cim_desde', $desde); 
        $builder->where('tbl_cierre_mes.cim_hasta', $hasta);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function insertarcierremes($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_cierre_mes');
        $builder->set($data);
        $builder->insert();
        $builder = $db->table('tbl_cierre_mes');
        $builder->select('tbl_cierre_mes.*');       
        $builder->orderBy('tbl_cierre_mes.cim_id', 'DESC');
        $builder->limit(1);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;       
    }

    public function ultimafechacierremes()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_cierre_mes');
        $builder->selectMax('tbl_cierre_mes.cim_hasta');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
}