<?php 
namespace App\Models;

use CodeIgniter\Model;

class PagoDetalleModel extends Model
{
    public function getAjustesCentavos()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_ajuste_centavos');
        $builder->select('tbl_ajuste_centavos.*');       
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getpagonoconciliado($desde,$hasta,$tipo_busqueda)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_pago_detalle');
        $builder->select('tbl_pago_detalle.*,tbl_datos_pagos_ventas.*,tbl_relacion_pagos_ventas.*,tbl_tipo_consulta.*,ajuste.*,tbl_pago_cabecera.*');  
        $builder->join('tbl_tipo_consulta', 'tbl_pago_detalle.tic_id=tbl_tipo_consulta.tic_id');  
        $builder->join('tbl_centro_costo', 'tbl_pago_detalle.cco_centro_costo=tbl_centro_costo.cco_centro_costo and tbl_pago_detalle.cco_centro_costo!=""','left');  
        $builder->join('tbl_datos_pagos_ventas','tbl_pago_detalle.pad_id=tbl_datos_pagos_ventas.pad_id','left');
        $builder->join('tbl_relacion_pagos_ventas','tbl_relacion_pagos_ventas.rpv_id=tbl_datos_pagos_ventas.rpv_id','left');
        $builder->join('tbl_pago_cabecera','tbl_pago_cabecera.pac_id=tbl_pago_detalle.pac_id','left');
        $builder->join('(select pad_id, GROUP_CONCAT(`aju_fecha`) a , GROUP_CONCAT(`aju_nombre`) b from tbl_ajustes group by 1) as ajuste','ajuste.pad_id=tbl_pago_detalle.pad_id','left');
        if($tipo_busqueda=='transaccion'){
            $builder->where('tbl_pago_detalle.pad_fecha_transaccion >=', $desde); 
            $builder->where('tbl_pago_detalle.pad_fecha_transaccion <=', $hasta);
        }else{
            if($tipo_busqueda=='pago'){
                $builder->where('tbl_pago_detalle.pad_fecha_pago >=', $desde); 
                $builder->where('tbl_pago_detalle.pad_fecha_pago <=', $hasta);
            }
        }         
        $builder->where('tbl_pago_detalle.tic_id', 1);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getpago($desde,$hasta,$tipo_busqueda)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_pago_detalle');
        $builder->select('tbl_pago_detalle.*,datos_pagos_ventas.*,tbl_relacion_pagos_ventas.*,tbl_tipo_consulta.*,ajuste.*,tbl_pago_cabecera.*');  
        $builder->join('tbl_tipo_consulta', 'tbl_pago_detalle.tic_id=tbl_tipo_consulta.tic_id','left');  
        $builder->join('tbl_centro_costo', 'tbl_pago_detalle.cco_centro_costo=tbl_centro_costo.cco_centro_costo and tbl_pago_detalle.cco_centro_costo!=""','left');  
        $builder->join('(select distinct(pad_id), GROUP_CONCAT(distinct `rpv_id`) c, rpv_id from tbl_datos_pagos_ventas group by 1) as datos_pagos_ventas','tbl_pago_detalle.pad_id=datos_pagos_ventas.pad_id','left');
        $builder->join('tbl_relacion_pagos_ventas','tbl_relacion_pagos_ventas.rpv_id=datos_pagos_ventas.rpv_id','left');
        $builder->join('tbl_pago_cabecera','tbl_pago_cabecera.pac_id=tbl_pago_detalle.pac_id','left');
        $builder->join('(select distinct pad_id, GROUP_CONCAT(`aju_fecha`) a , GROUP_CONCAT(`aju_nombre`) b from tbl_ajustes group by 1) as ajuste','ajuste.pad_id=tbl_pago_detalle.pad_id','left');
        if($tipo_busqueda=='transaccion'){
            $builder->where('tbl_pago_detalle.pad_fecha_transaccion >=', $desde); 
            $builder->where('tbl_pago_detalle.pad_fecha_transaccion <=', $hasta);
        }else{
            if($tipo_busqueda=='pago'){
                $builder->where('tbl_pago_detalle.pad_fecha_pago >=', $desde); 
                $builder->where('tbl_pago_detalle.pad_fecha_pago <=', $hasta);
            }
        }         
       // $builder->where('tbl_pago_detalle.tic_id', 1);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_pago_detalle');
        $builder->insert($data);
        
        $ultimoIdInsertado = $db->insertID();

        // Obtener la última fila insertada
        $builder->where('tbl_pago_detalle.pad_id', $ultimoIdInsertado);
        $query = $builder->get();
        $resultado = $query->getRow();

        return $resultado;
        /*$query=$builder->get();
        $resultado=$query->getLastRow();
        return $resultado;*/
    }
    public function actualizar($pad_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_pago_detalle');
        $builder->where('tbl_pago_detalle.pad_id', $pad_id);
        return $builder->update($data);        
    }
    public function eliminar($ajc_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_ajuste_centavos');
        $builder->where('tbl_ajuste_centavos.ajc_id', $ajc_id);   
        $builder->update($data);        
    }
    public function conciliado($pad_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_pago_detalle');
        $builder->where('tbl_pago_detalle.pad_id', $pad_id);   
        $builder->update($data);        
    }
    public function filtroconciliacion($pad_fecha_pago,$pad_fecha_pago_fin,$pad_lote,$pad_autorizacion,$pad_id_terminal,$pad_fecha_transaccion,$pad_fecha_transaccion_fin,$tic_id,$pad_monto_depositado_min,$pad_monto_depositado_max)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_pago_detalle');
        $builder->select('tbl_pago_detalle.*,tbl_centro_costo.cco_pdv'); 
        $builder->join('tbl_centro_costo', 'tbl_pago_detalle.cco_centro_costo=tbl_centro_costo.cco_centro_costo and tbl_pago_detalle.cco_centro_costo!=""','left'); 
        if($pad_fecha_pago != null){
            
            $builder->where('tbl_pago_detalle.pad_fecha_pago >=', $pad_fecha_pago);
            $builder->where('tbl_pago_detalle.pad_fecha_pago <=', $pad_fecha_pago_fin);
        }
        if($pad_lote != null){
           
            $builder->where('(tbl_pago_detalle.pad_lote)*1', $pad_lote);
        }
        if($pad_autorizacion != null){
            
            $builder->where('tbl_pago_detalle.pad_autorizacion', $pad_autorizacion);
        }
        if($pad_id_terminal != null){
            
            $builder->where('tbl_pago_detalle.pad_id_terminal', $pad_id_terminal);
        }
        if($pad_fecha_transaccion != null){
            
            $builder->where('tbl_pago_detalle.pad_fecha_transaccion >=', $pad_fecha_transaccion);
            $builder->where('tbl_pago_detalle.pad_fecha_transaccion <=', $pad_fecha_transaccion_fin);
        }
        if($tic_id != null){
            
            $builder->where('tbl_pago_detalle.tic_id', $tic_id);
        } 

        if($pad_monto_depositado_min != null && $pad_monto_depositado_max != null){            
            $builder->where('tbl_pago_detalle.pad_total_pagar >=', $pad_monto_depositado_min);
            $builder->where('tbl_pago_detalle.pad_total_pagar <=', $pad_monto_depositado_max);
            
        }else{

            if($pad_monto_depositado_min != null){
                $builder->where('tbl_pago_detalle.pad_total_pagar', $pad_monto_depositado_min);
            }else{
                if($pad_monto_depositado_max != null){
                    $builder->where('tbl_pago_detalle.pad_total_pagar', $pad_monto_depositado_max);
                }
            }
        }
        //$builder->orderBy('tbl_pago_detalle.pad_total_pagar', 'ASC');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }

    public function getestadisticasdeundia($desde,$hasta)
    
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_pago_detalle');
        $builder->selectCount('tbl_pago_detalle.pad_id');  
        $builder->where('tbl_pago_detalle.pad_fecha_cruce >=', $desde); 
        $builder->where('tbl_pago_detalle.pad_fecha_cruce <=', $hasta);    
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getDatosSegunpacidticid($pac_id)    
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_pago_detalle');        
        $builder->where('tbl_pago_detalle.pac_id', $pac_id);    
        $builder->where('tbl_pago_detalle.tic_id',2);    
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }

    public function eliminarsegunpacid($pac_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_pago_detalle');
        $builder->where('tbl_pago_detalle.pac_id', $pac_id);
        $builder->delete();         
    }
    public function getPagosDetalleTotalAjuste($pad_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_pago_detalle');
        $builder->select('tbl_pago_detalle.*');   
        $builder->where('tbl_pago_detalle.pad_id', $pad_id);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
}