<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class RelacionPagosVentasModel extends Model
{
    public function getRelacionPagosVentas($desde,$hasta, $tipobusqueda)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_relacion_pagos_ventas');
        $builder->select('tbl_relacion_pagos_ventas.*'); 
        $builder->join('tbl_datos_pagos_ventas','tbl_relacion_pagos_ventas.rpv_id=tbl_datos_pagos_ventas.rpv_id'); 
        $builder->join('tbl_venta','tbl_datos_pagos_ventas.ven_id=tbl_venta.ven_id');
        if($tipobusqueda=='conciliacion' ){
        $builder->where('tbl_relacion_pagos_ventas.rpv_fecha_cruce >=', $desde); 
        $builder->where('tbl_relacion_pagos_ventas.rpv_fecha_cruce <=', $hasta);   } 
       else if($tipobusqueda=='venta' )
        {
            $builder->where('tbl_venta.ven_fecha_transaccion >=', $desde); 
            $builder->where('tbl_venta.ven_fecha_transaccion <=', $hasta);
        }
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getRelacionPagosVentas_numero_conciliacion($rpv_numero_conciliacion)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_relacion_pagos_ventas');
        $builder->select('tbl_relacion_pagos_ventas.*');    
        $builder->where('tbl_relacion_pagos_ventas.rpv_numero_conciliacion', $rpv_numero_conciliacion );    
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getComprobarRelacionPagosVentas($rpv_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_datos_pagos_ventas');
        $builder->select('tbl_datos_pagos_ventas.*,tbl_venta.ven_fecha_transaccion');   
        $builder->join('(select pad_id from tbl_datos_pagos_ventas a where a.rpv_id='.$rpv_id.') as a','a.pad_id=tbl_datos_pagos_ventas.pad_id');
        $builder->join('tbl_venta','tbl_venta.ven_id=tbl_datos_pagos_ventas.ven_id');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getComprobarRelacionPagosVentasFechaCruce($rpv_fecha_cruce)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_datos_pagos_ventas');
        $builder->select('DATE_FORMAT(tbl_relacion_pagos_ventas.rpv_fecha_cruce,"%Y-%m-%d") as fecha,tbl_datos_pagos_ventas.*,tbl_venta.ven_fecha_transaccion');   
        $builder->join('tbl_relacion_pagos_ventas','tbl_datos_pagos_ventas.rpv_id=tbl_relacion_pagos_ventas.rpv_id ');
        $builder->join('tbl_venta','tbl_venta.ven_id=tbl_datos_pagos_ventas.ven_id');
        $builder->where('DATE_FORMAT(tbl_relacion_pagos_ventas.rpv_fecha_cruce,"%Y-%m-%d") =',$rpv_fecha_cruce);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getUnRelacionPagosVentas($rpv_fecha_cruce_desde,$rpv_fecha_cruce_hasta)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_relacion_pagos_ventas');
        $builder->select('tbl_relacion_pagos_ventas.*,tbl_ventas.*,tbl_pagos_detalle.*,tbl_frecuencias_pago.*');    
        $builder->join('tbl_ventas', 'tbl_relacion_pagos_ventas.ven_codigo=tbl_ventas.ven_codigo');        
        
        $builder->join('tbl_pagos_detalle', 'tbl_pagos_detalle.pac_codigo_archivo=tbl_relacion_pagos_ventas.pac_codigo_archivo 
                                            AND tbl_pagos_detalle.pad_numero_item= tbl_relacion_pagos_ventas.pad_numero_item');   
        if($rpv_fecha_cruce_desde != null && $rpv_fecha_cruce_hasta != null){
            $builder->where('tbl_relacion_pagos_ventas.rpv_fecha_cruce >=', $rpv_fecha_cruce_desde);
            $builder->where('tbl_relacion_pagos_ventas.rpv_fecha_cruce <=', $rpv_fecha_cruce_hasta);
        }else{
            if($rpv_fecha_cruce_desde != null){
                $builder->where('tbl_relacion_pagos_ventas.rpv_fecha_cruce >=', $rpv_fecha_cruce_desde);
            }else{
                if($rpv_fecha_cruce_hasta != null){
                    $builder->where('tbl_relacion_pagos_ventas.rpv_fecha_cruce <=', $rpv_fecha_cruce_hasta);
                }
            }
        }        
           
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }

    public function getestadisticasdeundia($desde,$hasta)
    
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_relacion_pagos_ventas');
        $builder->selectCount('tbl_relacion_pagos_ventas.rpv_id');  
        $builder->where('tbl_relacion_pagos_ventas.rpv_fecha_cruce >=', $desde); 
        $builder->where('tbl_relacion_pagos_ventas.rpv_fecha_cruce <=', $hasta);    
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getEstadisticasPagosAnio()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_pago_detalle');
        $builder->select('Monthname(pad_fecha_pago) as mes,count(pad_fecha_pago) as cantidad ');  
        $builder->where('year(pad_fecha_pago)=year(curdate()) GROUP by mes');  
        $builder->orderBy('pad_fecha_pago','asc');  
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getEstadisticasVentasAnio()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->select('Monthname(ven_fecha_transaccion) as mes,count(ven_fecha_transaccion) as cantidad ');  
        $builder->where('year(ven_fecha_transaccion)=year(curdate()) GROUP by mes');  
        $builder->orderBy('ven_fecha_transaccion','asc');  
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getEstadisticasAnio()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_relacion_pagos_ventas');
        $builder->select(' Monthname(rpv_fecha_cruce) as mes,count(rpv_fecha_cruce) as cantidad ');  
        $builder->where('year(rpv_fecha_cruce)=year(curdate()) GROUP by mes');  
        $builder->orderBy('rpv_fecha_cruce','asc');  
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_relacion_pagos_ventas');
        $builder->set($data);
		$builder->insert();
        $query=$builder->get();
        $resultado=$query->getLastRow();
        return $resultado;
    }
    public function actualizar($ven_codigo,$pad_codigo_pago,$pad_numero_item,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_relacion_pagos_ventas');
        $builder->where('tbl_relacion_pagos_ventas.ven_codigo', $ven_codigo ); 
        $builder->where('tbl_relacion_pagos_ventas.pad_codigo_pago', $pad_codigo_pago ); 
        $builder->where('tbl_relacion_pagos_ventas.pad_numero_item', $pad_numero_item );        
		return $builder->update($data);        
    }
    public function actualizardatos($rpv_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_relacion_pagos_ventas');
        $builder->where('tbl_relacion_pagos_ventas.rpv_id', $rpv_id );       
        $builder->update($data);        
    }
    public function eliminar($ven_codigo,$pad_codigo_pago,$pad_numero_item,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_relacion_pagos_ventas');
        $builder->where('tbl_relacion_pagos_ventas.ven_codigo', $ven_codigo ); 
        $builder->where('tbl_relacion_pagos_ventas.pad_codigo_pago', $pad_codigo_pago ); 
        $builder->where('tbl_relacion_pagos_ventas.pad_numero_item', $pad_numero_item );        
		$builder->update($data);        
    }
    public function borrar($rpv_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_relacion_pagos_ventas');
        $builder->where('tbl_relacion_pagos_ventas.rpv_id', $rpv_id);
        $builder->delete();         
    }
    
    public function getDatosConciliacionVentas_numero_conciliacion($rpv_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_venta');
        $builder->select(' tbl_venta.*,tbl_datos_pagos_ventas.rpv_id');  
        $builder->join('(select distinct tbl_datos_pagos_ventas.ven_id, tbl_datos_pagos_ventas.rpv_id from tbl_datos_pagos_ventas) as tbl_datos_pagos_ventas', 'tbl_venta.ven_id=tbl_datos_pagos_ventas.ven_id');   
        $builder->where('tbl_datos_pagos_ventas.rpv_id',$rpv_id);  
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getDatosConciliacionPagos_numero_conciliacion($rpv_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_pago_detalle');
        $builder->select(' tbl_pago_detalle.*,tbl_datos_pagos_ventas.rpv_id');  
        $builder->join('(select distinct tbl_datos_pagos_ventas.pad_id, tbl_datos_pagos_ventas.rpv_id from tbl_datos_pagos_ventas) as tbl_datos_pagos_ventas', 'tbl_pago_detalle.pad_id=tbl_datos_pagos_ventas.pad_id');   
        $builder->where('tbl_datos_pagos_ventas.rpv_id',$rpv_id);  
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    
    public function getSaldosCentavos($desde,$hasta)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_relacion_pagos_ventas');
        $builder->select(' tbl_relacion_pagos_ventas.*');   
        $builder->where('tbl_relacion_pagos_ventas.rpv_fecha_cruce >=',$desde);  
        $builder->where('tbl_relacion_pagos_ventas.rpv_fecha_cruce <=',$hasta);
        $builder->where('tbl_relacion_pagos_ventas.rpv_valor_diferencia_pago !=',0); 
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
}