<?php

namespace App\Controllers;

class Archivo extends BaseController
{
	public function index()
	{

		$datos_pago_cabecera=$this->getPagoCabecera();

		$enviar_datos=array(
			'datos_pago_cabecera'=>!empty($datos_pago_cabecera['data'])?$datos_pago_cabecera['data']:[],
		);
		
		
		echo view("layouts/header");
		echo view("layouts/aside");
		echo view("archivo/list",$enviar_datos);
		echo view("layouts/footer"); 
		
	}
	

	public function getPagoCabecera(){
		
		$opciones = array('http' =>
			array(
				'method'  => 'POST',
				'header'  => 'Content-type: application/x-www-form-urlencoded',
			)
		);
		$contexto = stream_context_create($opciones);
		$resultado = file_get_contents($this->url_api_conciliacion.'pagocabeceratodos', false, $contexto);
		$resultado=json_decode($resultado,true);
		if(!empty($resultado)){
			return $resultado;
		}else{
			return null;
		}
	}

	public function eliminar($pac_id){
		$session = \Config\Services::session();
		if(!empty($pac_id)){
			$datos_post = http_build_query(
				array(
					'pacid'=>$pac_id,

				)
			);

			$opciones = array('http' =>
				array(
					'method'  => 'POST',
					'header'  => 'Content-type: application/x-www-form-urlencoded',
					'content' => $datos_post
				)
			);
			$contexto = stream_context_create($opciones);
			$resultado = file_get_contents($this->url_api_conciliacion.'pagocabeceraeliminar', false, $contexto);
			$resultado=json_decode($resultado,true);
			if(!empty($resultado)){
				if($resultado['code']==200){
					$session->setFlashdata('mensaje_bueno', 'Eliminado');
					return redirect()->to(base_url('Archivo'));
				}else{
					$session->setFlashdata('mensaje_malo', 'No Eliminado');
					return redirect()->to(base_url('Archivo'));
				}
			}else{
				$session->setFlashdata('mensaje_malo', 'No Eliminado');
				return redirect()->to(base_url('Archivo'));
			}
		}
	}


	
}

