<!-- start:content -->
<script src="https://code.highcharts.com/highcharts.js"></script>
<script src="https://code.highcharts.com/modules/variable-pie.js"></script>
<script src="https://code.highcharts.com/modules/exporting.js"></script>
<script src="https://code.highcharts.com/modules/export-data.js"></script>
<script src="https://code.highcharts.com/modules/accessibility.js"></script>
<script src="https://code.highcharts.com/modules/series-label.js"></script>

<script src="https://code.highcharts.com/highcharts-3d.js"></script>
<script src="https://code.highcharts.com/modules/cylinder.js"></script>
<div id="content">

	<div class="col-md-12 padding-0" style="margin-top:20px;">
		<div class="col-md-12 padding-0">
			<div class="col-md-12 padding-0">
				<div class="col-md-12 padding-0">
					<div class="col-md-12">
						<div class="panel chart-title">
							<h3 style="color:#1d83c6;"><span class="fa fa-area-chart"></span> Estadísticas</h3>
						</div>
					</div>
					<div class="col-sm-3">
					    <div class="panel panel-primary">
							<div class="panel-heading-white panel-heading text-center">
								<h4 style="color:white;">Conciliados Hoy vs Ayer</h4>
							</div>
						<figure class="highcharts-figure">
                            <div id="container"></div>
                        </figure>
                        </div>
					</div>
					<div class="col-sm-3">
					    <div class="panel panel-primary">
							<div class="panel-heading-white panel-heading text-center">
								<h4 style="color:white;">Datos conciliados en el mes</h4>
							</div>
						<figure class="highcharts-figure">
                            <div id="containerMes"></div>
                        </figure>
                        </div>
					</div>
					<div class="col-sm-6">
					    <div class="panel panel-primary">
							<div class="panel-heading-white panel-heading text-center">
								<h4 style="color:white;">Conciliaciones vs Pagos vs Ventas</h4>
							</div>
						<figure class="highcharts-figure">
                            <div id="containerAnio"></div>
                        </figure>
                        </div>
					</div>
										
				</div>
			</div>
			
		</div>
		
		
	</div>
</div>

<script>

    Highcharts.chart('containerAnio', {
        chart: {
            type: 'line'
        },
        title: {
            text: ''
        },
        subtitle: {
            text: ''
        },
        xAxis: {
            categories: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic']
        },
        yAxis: {
            title: {
                text: 'Cantidad'
            }
        },
        plotOptions: {
            line: {
                dataLabels: {
                    enabled: true
                },
                enableMouseTracking: false
            }
        },
        series: [{
            name: 'Conciliaciones',
            data: [<?php echo $estadisticas['rpv_anio']; ?>]
        }, {
            name: 'Pagos',
            data: [<?php echo $estadisticas['pagos_anio'] ;?>]
        },{
            name: 'Ventas',
            data: [<?php echo $estadisticas['ventas_anio']; ?>]
        }]
    });

    Highcharts.chart('containerMes', {
    chart: {
        type: 'cylinder',
        options3d: {
            enabled: true,
            alpha: 15,
            beta: 15,
            depth: 50,
            viewDistance: 25
        }
    },
    title: {
        text: ''
    },
    plotOptions: {
        series: {
            depth: 25,
            colorByPoint: true
        }
    },
    series: [{
        data: [<?php
					if(!empty($estadisticas)){
						if(!empty($estadisticas['rpv_cantidad_mes'])){
							$salida="";
							foreach ($estadisticas['rpv_cantidad_mes'] as  $value) {
								$salida=$salida."".$value['cantidad'].",";
							}
							echo $salida;
						}else{
							echo '';
						}
					}else{
						echo '';
					}

					?>],
        name: 'Conciliaciones',
        showInLegend: false
    }]
    });

   Highcharts.chart('container', {
    chart: {
        plotBackgroundColor: null,
        plotBorderWidth: 0,
        plotShadow: false
    },
    title: {
        text: 'Conciliación de <br>Tarjetas de Crédito<br>',
        align: 'center',
        verticalAlign: 'middle',
        y: 60
    },
    tooltip: {
        pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
    },
    accessibility: {
        point: {
            valueSuffix: '%'
        }
    },
    plotOptions: {
        pie: {
            dataLabels: {
                enabled: true,
                distance: -50,
                style: {
                    fontWeight: 'bold',
                    color: 'white'
                }
            },
            startAngle: -90,
            endAngle: 90,
            center: ['50%', '75%'],
            size: '110%'
        }
    },
    series: [{
        type: 'pie',
        name: 'Conciliación de Tarjetas de Crédito',
        innerSize: '50%',
        data: [
            ['Conciliaciones de hoy', <?php if(!empty($estadisticas['rpv_cantidad_hoy'])){
					echo $estadisticas['rpv_cantidad_hoy'];
				}else{
					echo 0;
				}?>],
            ['Conciliaciones de ayer', <?php if(!empty($estadisticas['rpv_cantidad_ayer'])){
					echo $estadisticas['rpv_cantidad_ayer'];
				}else{
					echo 0;
				}?>]
        ]
    }]
});

</script>
<style>
    #container {
        height: auto;
    }

    .highcharts-figure,
    .highcharts-data-table table {
        min-width: 320px;
        max-width: 700px;
        margin: 1em auto;
    }

    .highcharts-data-table table {
        font-family: Verdana, sans-serif;
        border-collapse: collapse;
        border: 1px solid #ebebeb;
        margin: 10px auto;
        text-align: center;
        width: 100%;
        max-width: 500px;
    }

    .highcharts-data-table caption {
        padding: 1em 0;
        font-size: 1.2em;
        color: #555;
    }

    .highcharts-data-table th {
        font-weight: 600;
        padding: 0.5em;
    }

    .highcharts-data-table td,
    .highcharts-data-table th,
    .highcharts-data-table caption {
        padding: 0.5em;
    }

    .highcharts-data-table thead tr,
    .highcharts-data-table tr:nth-child(even) {
        background: #f8f8f8;
    }

    .highcharts-data-table tr:hover {
        background: #f1f7ff;
    }

</style>




