<?php

namespace App\Controllers;
include_once 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use \PhpOffice\PhpSpreadsheet\Reader\IReader;
use App\Models\UsuarioModel;
use App\Models\Conveniomodel;
use App\Models\Puntoventamodel;
use App\Models\Convenioporcentajemodel;
use App\Models\Comisionmesfinalizadomodel;


class Convenios extends BaseController
{

	public function index(){
	    $session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
    		$datos = $this->datosMenu();
    		$convenio_model=new Conveniomodel();
    		$datos_convenio=$convenio_model->getConvenio();
    
    		$enviar_datos=array(
    			'datos_convenio'=>$datos_convenio,
    		);
    		echo view("layouts/header");
    		echo view("layouts/aside", $datos);
    		echo view("convenios/list",$enviar_datos);
    		echo view("layouts/footer");
		}else{
	        return redirect()->to(base_url());
	    }
	}

	

	public function add(){
		$session = \Config\Services::session();
		
		if(!empty($this->request->getPost('convenio')) && !empty($this->request->getPost('fechainicioconvenio')) && !empty($this->request->getPost('fechafinconvenio'))){

			$convenio_model=new Conveniomodel();

			$cov_nombre=$this->request->getPost('convenio');
			$cov_fecha=$this->request->getPost('fechainicioconvenio');
			$cov_fecha_hasta=$this->request->getPost('fechafinconvenio');
			$cov_porcentaje=$this->request->getPost('porcentajeganancia');
			

			$datos_convenio=array(

				'cov_nombre'=>$cov_nombre,
				'cov_fecha'=>$cov_fecha,
				'cov_fecha_hasta'=>$cov_fecha_hasta,
				'cov_porcentaje'=>$cov_porcentaje,
				'cov_estado'=>1,
			);

			$convenio_model->insertar($datos_convenio);
			
			$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
			return redirect()->to(base_url('Convenios')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Convenios')); 
		}
	}
	public function edit(){		
		$session = \Config\Services::session();		
		if(!empty($this->request->getPost('covid')) && !empty($this->request->getPost('editconvenio')) && !empty($this->request->getPost('editfechainicioconvenio')) && !empty($this->request->getPost('editporcentajeganancia')) && !empty($this->request->getPost('editfechafinconvenio'))){

			$convenio_model=new Conveniomodel();

			$cov_id=$this->request->getPost('covid');
			$cov_nombre=$this->request->getPost('editconvenio');
			$cov_fecha=$this->request->getPost('editfechainicioconvenio');
			$cov_porcentaje=$this->request->getPost('editporcentajeganancia');
			$cov_fecha_hasta=$this->request->getPost('editfechafinconvenio');


			$datos_convenio=array(

				'cov_nombre'=>$cov_nombre,
				'cov_fecha'=>$cov_fecha,
				'cov_fecha_hasta'=>$cov_fecha_hasta,
				'cov_porcentaje'=>$cov_porcentaje,
				'cov_estado'=>1,
			);

			$convenio_model->actualizar($cov_id,$datos_convenio);
			$session->setFlashdata('mensaje_bueno', 'Convenio modificado satisfactoriamente');
			return redirect()->to(base_url('Convenios')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Convenios')); 
		}
	}
	public function eliminar($cov_id){		
		$session = \Config\Services::session();		
		if(!empty($cov_id)){

			$convenio_model=new Conveniomodel();	

			$datos_convenio=array(
				'cov_estado'=>0,
			);
			$convenio_model->actualizar($cov_id,$datos_convenio);

			$session->setFlashdata('mensaje_bueno', 'Se ha inactivado el convenio');
			return redirect()->to(base_url('Convenios')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Convenios')); 
		}
	}
	public function activar($cov_id){		
		$session = \Config\Services::session();		
		if(!empty($cov_id)){

			$convenio_model=new Conveniomodel();	

			$datos_convenio=array(
				'cov_estado'=>1,
			);
			$convenio_model->actualizar($cov_id,$datos_convenio);

			$session->setFlashdata('mensaje_bueno', 'Se ha activado el convenio');
			return redirect()->to(base_url('Convenios')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Convenios')); 
		}
	}
	public function eliminarconvenioporcentaje(){		
		$session = \Config\Services::session();		
		if(!empty($this->request->getPost('covideliminar')) && !empty($this->request->getPost('fechaeliminar'))){

			$cov_id=$this->request->getPost('covideliminar');
			$fecha=$this->request->getPost('fechaeliminar');
			$fecha=date('Y-m-1',strtotime($fecha));
			

			$convenio_porcentaje_model=new Convenioporcentajemodel();
			$convenio_porcentaje_model->eliminarseguncovidmes($cov_id,$fecha);

			

			$session->setFlashdata('mensaje_bueno', 'Datos eliminados');
			return redirect()->to(base_url('Convenios')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Convenios')); 
		}
	}
	public function editvalor(){		
		$session = \Config\Services::session();		
		if(!empty($this->request->getPost('auxporcentaje')) && !empty($this->request->getPost('copid')) ){

			$convenio_porcentaje_model=new Convenioporcentajemodel();

			$cov_porcentaje=$this->request->getPost('auxporcentaje');
			$cop_id=$this->request->getPost('copid');
			$cop_valor_vendido=$this->request->getPost('nuevovalor');

			$cop_porciento=0;

			if($cov_porcentaje!=0){
				$cop_porciento=$cop_valor_vendido*$cov_porcentaje/100;
			}

			$datos_convenio_porcentaje=array(
				'cop_porciento'=>$cop_porciento,
				'cop_valor_vendido'=>$cop_valor_vendido,
			);

			$convenio_porcentaje_model->actualizar($cop_id,$datos_convenio_porcentaje);
			$session->setFlashdata('mensaje_bueno', 'Dato editados');
			return redirect()->to(base_url('Convenios')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'No hay datos');
			return redirect()->to(base_url('Convenios')); 
		}
	}

	public function mostrardatosunconvenio(){
		if(!empty($this->request->getPost('covid')) && !empty($this->request->getPost('mes'))){
			$convenio_porcentaje_model=new Convenioporcentajemodel();
			$cov_id=$this->request->getPost('covid');
			$cop_mes=$this->request->getPost('mes');
			$cop_mes=date('Y-m-1',strtotime($cop_mes));
			$resultado=[];
			$resultado= $convenio_porcentaje_model->getconvenioporcentajecovidmes($cov_id,$cop_mes);
			return json_encode($resultado);
		}else{
			return json_encode([]);
		}
	}

	public function leerconvenio(){
		$datos = $this->datosMenu();
		$convenio_model=new Conveniomodel();
		$datos_convenio=$convenio_model->getConvenio();

		$enviar_datos=array(
			'datos_convenio'=>$datos_convenio,
		);

		
		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("convenios/leerconvenio",$enviar_datos);
		echo view("layouts/footer");
	}

	public function tabla()
	{
		$session = \Config\Services::session();
		$punto_venta_model =new Puntoventamodel();
		$nombre_archivo=null;
		
		$mes='';
		if(empty($this->request->getPost('mes'))){
			$session->setFlashdata('mensaje_malo', 'Seleccion el mes');
			return redirect()->to(base_url('Convenios/leerconvenio'));
		}
		$mes=$this->request->getPost('mes');

		$mes=date('Y-m-d',strtotime($mes));

		$cov_nombre='';
		$cov_id=0;
		$cov_porcentaje=0;

		if(!empty($this->request->getPost('convid'))){
			$convenio=explode('/',$this->request->getPost('convid'));
			$cov_id=$convenio[0];
			$cov_nombre=$convenio[1];	
			$cov_porcentaje=$convenio[2];		
			$cov_porcentaje=$cov_porcentaje/100;	
		}


		if(!empty($_FILES["archivoseleccionado"]["name"])){
			$nombre_archivo = $_FILES["archivoseleccionado"]["name"];            
		}   
		if($nombre_archivo!=null ){            

			$path = $_FILES["archivoseleccionado"]["tmp_name"];
			$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
			$reader->setReadDataOnly(true);
			$spreadsheet = $reader->load($path);
			$sheet = $spreadsheet->getSheetByName('CONVENIOS');        

			if(empty($sheet)){
				$session->setFlashdata('mensaje_malo', 'Archivo no Compatible: Hoja con el nombre "CONVENIOS"');
				return redirect()->to(base_url('Convenios/leerconvenio'));
			}    

			$data=[];

			$pdv_no_encontrados='';

			foreach ($sheet->getRowIterator() as $row) {
				$cellIterator = $row->getCellIterator();
				$cellIterator->setIterateOnlyExistingCells(false); 
				$highestRow = $sheet->getHighestDataRow();               

				$highestColumn = $sheet->getHighestDataColumn();            
				for($row=2; $row<=$highestRow; $row++)
				{
					$pdv = $sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue();   
					$valor_vendido = $sheet->getCellByColumnAndRow(2, $row)->getCalculatedValue();					

					if(!is_numeric($valor_vendido)){
						$valor_vendido=0;
					}

					$valor_vendido=round($valor_vendido,2);
					

					$puv_id= $punto_venta_model->getPuntoventasegunnombre($pdv);
					$puv_id=!empty($puv_id[0]['puv_id'])?$puv_id[0]['puv_id']:0;

					if($puv_id!=0){
						$convenio=$valor_vendido*$cov_porcentaje;
						$convenio=round($convenio, 2);
						$data[]=array(
							'puv_id'=>$puv_id,
							'pdv'=>$pdv,
							'valor_vendido'=>$valor_vendido,
							'convenio2%'=>$convenio,							
						);
					}else{
						$pdv_no_encontrados=$pdv_no_encontrados."-".$pdv;
					}



				}
				break;

			}
			$datos = $this->datosMenu();
			$enviar_datos=array(            
				'data'=>$data,
				'mensaje'=>$pdv_no_encontrados,
				'cov_nombre'=>$cov_nombre,
				'cov_id'=>$cov_id,
				'mes'=>$mes,
			);

			echo view("layouts/header");
			echo view("layouts/aside",$datos);
			echo view("convenios/tabla",$enviar_datos);
			echo view("layouts/footer");


		}else{
			$session->setFlashdata('mensaje_malo', 'Seleccione un archivo');
			return redirect()->to(base_url('Formatocarga')); 
		}

	}
	public function finalizar (){
		$session = \Config\Services::session();

		if(!empty($this->request->getPost('datos'))  && !empty($this->request->getPost('covid')) && !empty($this->request->getPost('mes'))){
			$convenio_porcentaje_model=new Convenioporcentajemodel();
			$datos =$this->request->getPost('datos');			
			$cov_id =$this->request->getPost('covid');
			$cop_mes =$this->request->getPost('mes');            
			$datos=base64_decode($datos);
			$datos=json_decode($datos,true);
			

			foreach ($datos as $value) {

				$datos_convenio_porcentaje=array(
					'puv_id'=>$value['puv_id'],
					'cop_valor_vendido'=>$value['valor_vendido'],
					'cop_porciento'=>$value['convenio2%'],
					'cov_id'=>$cov_id,
					'cop_mes'=>$cop_mes,
					'cop_estado'=>1,

				);
				$convenio_porcentaje_model->insertar($datos_convenio_porcentaje);

			}

			$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
			return redirect()->to(base_url('Convenios/leerconvenio')); 
		}else{
			$session->setFlashdata('mensaje_malo', 'Dato Ingresado');
			return redirect()->to(base_url('Convenios/leerconvenio')); 
		}

	}
	
	public function reporteconvenios(){
		$session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
	        $convenio_model=new Conveniomodel();
    		$datos = $this->datosMenu();
            $desde=$this->request->getPost('desde');
            $hasta=$this->request->getPost('hasta');
            $estado=$this->request->getPost('estado');
            
            $desde=$desde.'-01';
            $hasta=date("Y-m-t", strtotime($hasta.'-01')); 
            $datos_convenio=$convenio_model->getConvenioFiltro($desde, $hasta, $estado);
            
    		$convenio=array();
    		foreach($datos_convenio as $item)
    		{
    		    $a=0;
    		    
    		    if(date("Y-m-t", strtotime($item['cov_fecha_hasta']))<=$hasta){
    		        $a=1; 
    		    }
    		    if(date("Y-m-t", strtotime($item['cov_fecha_hasta']))>=$desde){
		            $a++; 
		        }
		        if($a==1){
		            if(date("Y-m-01", strtotime($item['cov_fecha']))>=$desde && date("Y-m-01", strtotime($item['cov_fecha']))<=$hasta){
    		            $a++; 
    		        }
    		        if($desde>=date("Y-m-01", strtotime($item['cov_fecha'])) && $desde<=date("Y-m-01", strtotime($item['cov_fecha_hasta']))){
    		            $a++; 
    		        }
		        }
		        if($a>1){
		            $c=array(
		                'cov_nombre'=>$item['cov_nombre'],
		                'cov_fecha'=>date("Y-m", strtotime($item['cov_fecha'])),
		                'cov_fecha_hasta'=>date("Y-m", strtotime($item['cov_fecha_hasta'])),
		                'cov_porcentaje'=>$item['cov_porcentaje'],
		                'cov_estado'=>$item['cov_estado']);
		          array_push($convenio, $c);
		        }
    		} 
    		
            $enviar_datos=array(
    			'datos_convenio'=>$convenio,
    		);
    		echo view("layouts/header");
    		echo view("layouts/aside",$datos);
    		echo view("convenios/reporte",$enviar_datos);
    		echo view("layouts/footer");
	    }
	    else{
	        return redirect()->to(base_url());
	    }
	}
	
	public function filtroreporte(){
		$session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
    		$datos = $this->datosMenu();
    
    		echo view("layouts/header");
    		echo view("layouts/aside",$datos);
    		echo view("convenios/filtroreporte");
    		echo view("layouts/footer");
	    }
	    else{
	        return redirect()->to(base_url());
	    }
	}
	
	public function filtroconvenioreporte(){
		$session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
    		$datos = $this->datosMenu();
            $convenio_model=new Conveniomodel();
		    $convenio=$convenio_model->getConvenio();
		    $datos_convenio=array(
    			'datos_convenio'=>$convenio,
    		);
    		echo view("layouts/header");
    		echo view("layouts/aside",$datos);
    		echo view("convenios/filtroconvenioreporte",$datos_convenio);
    		echo view("layouts/footer");
    		echo view("convenios/footer");
	    }
	    else{
	        return redirect()->to(base_url());
	    }
	}
	
	public function reporteespecifico(){
	    $session = \Config\Services::session();
	    if($session->get('USU_ID')!=''){
    	    
            $datos_menu = $this->datosMenu();
    		$meses=$this->request->getPost('meses');
    		$convenio=$this->request->getPost('convenio'); 
    		$datos_finales=array();
    		$tit=array();
    		array_push($tit,'');
    		$pdv_model=new Puntoventamodel();
        	$pdv1=$pdv_model->getNombrePuntoventaDueno(0); //solo obtiene franquicia
        	if(empty($meses)){
    			$session->setFlashdata('mensaje_malo', 'Seleccione los meses para generar el reporte');
    			return redirect()->to(base_url('convenios/filtroconvenioreporte'));
    		}
    		else
    		{
    		    $m=explode(',',$meses);
    		    $m=array_unique($m);
    		    arsort($m);
    		    array_pop($m);
    		    //print_r($m);
    		    $cont_meses=0;
    		    foreach($m as $mes)
        	    {
        	        array_push($tit,$mes);
        	        $cont_meses=$cont_meses+1;
        	    }
    		    foreach($pdv1 as $pdv){
            	    $valor='0.00';
            	    $contador=0;
            	    $valores=array();
            	    array_push($valores,$pdv['puv_punto_venta']);
            	    
        		    foreach($m as $mes)
            	    {
            	        $valor='0.00';
            	        
                		$mes_aux=date("Y-m", strtotime($mes));
                		$mes_inicio=date("Y-m-1", strtotime($mes));
                
                		$comision_mes_finalizado_model= new Comisionmesfinalizadomodel();
                		$resultado= $comision_mes_finalizado_model->getUnComisionmesfinalizadopormes($mes_inicio); 
                		
                		if(!empty($resultado)){
                			$datos_registrados = file_get_contents($resultado[0]['cmf_link']);
                			$datos_registrados = base64_decode($datos_registrados);
                			$datos_registrados = json_decode($datos_registrados,true);
                			$titulos=$datos_registrados['titulos'];
                			$titulos=json_decode($titulos);
                			$id_convenio = array_search($convenio, $titulos);
                			$datos=$datos_registrados['datos'];
                			$datos=json_decode($datos);
                			$id=1;
                			foreach($datos as $d){
                			    if($d->$id==$pdv['puv_punto_venta'])
                			    {
                			        $valor=$d->$id_convenio;
                			        $contador++;
                    			}
                			}
                			array_push($valores,$valor);
                					
                			
            		}
            		else{
            		    array_push($valores,'No existen datos guardados');
            		}
    		    }
    		    array_push($datos_finales,$valores);
            		
        		}
        		$datos_menu = $this->datosMenu();
        		$enviar_datos=array(
        		    'titulos'=>$tit,
        		    'datos'=>$datos_finales,
        		    'meses'=>$cont_meses,
        		    'busqueda'=>$convenio
        		    );
    			echo view("layouts/header");
    			echo view("layouts/aside",$datos_menu);
    			echo view("convenios/reportemes",$enviar_datos);
    			echo view("layouts/footer");
    			return;
                
    		}
	    }
	    else{
	        return redirect()->to(base_url());
	    }
	}
	public function comprobarExisteConvenio(){
	    $nombreConvenio=$this->request->getPost('nombreConvenio');
		$convenios_model=new Convenioporcentajemodel();
		$a=$convenios_model->buscarConvenioPorNombre($nombreConvenio);
		if($a=="")
		{
		    return "Convenio $nombreConvenio: no encontrado ";
		}
		else
		{
		    return "";
		}
	}
	public function datosMenu()
	{
		$session = \Config\Services::session();

		$usuario_model=new UsuarioModel();

		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datos = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);
		return $datos;
	}
}