<?php

namespace App\Controllers;
use App\Models\Cuadreventasmodel;
use App\Models\UsuarioModel;
use App\Models\Puntoventamodel;

class CuadreVentas extends BaseController
{
    public function transacciones()
    {
        helper(['form']);
        $data = [];
        $datos = $this->datosMenu();
        $pdv=new Puntoventamodel();
        $almacen = $this->request->getPost('almacen');
        if ($this->request->getMethod() === 'post') {
            $inicioMes = $this->request->getPost('inicioMes');
            $finMes = $this->request->getPost('finMes');
            $modelo = new Cuadreventasmodel();
            $data['resultados'] = $modelo->obtenerTransacciones($inicioMes, $finMes, $almacen);
        }

        $data['pdv'] = $pdv->getPuntoventaActivo();
        echo view("layouts/header");
		echo view("layouts/aside",$datos);
		echo view("cuadre/ventas",$data);
		echo view("layouts/footer");
    }
    public function notascredito()
    {
        helper(['form']);
        $data = [];
        $datos = $this->datosMenu();
        $pdv=new Puntoventamodel();
        $almacen = $this->request->getPost('almacen');
        if ($this->request->getMethod() === 'post') {
            $inicioMes = $this->request->getPost('inicioMes');
            $finMes = $this->request->getPost('finMes');
            $modelo = new Cuadreventasmodel();
            $data['resultados'] = $modelo->obtenerNotasCredito($inicioMes, $finMes, $almacen);
        }

        $data['pdv'] = $pdv->getPuntoventaActivo();
        echo view("layouts/header");
		echo view("layouts/aside",$datos);
		echo view("cuadre/notascredito",$data);
		echo view("layouts/footer");
    }
    public function datosMenu()
	{
		$session = \Config\Services::session();

		$usuario_model=new UsuarioModel();

		$rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
		$menu = $usuario_model->selectMenu();
		$datos = array(
			'rolMenu' => $rm,
			'menu' => $menu
		);
		return $datos;
	}
}
