<?php

namespace App\Controllers;

use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\Database\Exceptions\DatabaseException;
use App\Models\Transaccionespagomodel;
use App\Models\Notascreditomodel;
use App\Models\Transaccionmodel;
use App\Models\Cotizacionmodel;

class Transaccionesdiarias extends BaseController
{
    /**
     * Función para obtener las transacciones diarias desde la API y almacenarlas en la base de datos.
     */
   public function Transacciones()
{
    // Instanciar el servicio de cliente HTTP
    $client = \Config\Services::curlrequest();
    $db = \Config\Database::connect('postgres'); // Conexión a PostgreSQL

    // Definir la URL de la API
    $url = 'https://api.megaprofer.com/api/dispatches/allDispatchByTransactionDate';

    // Parámetros de la consulta
    $params = [
        'init' => '2025-04-23',
        'end'  => '2025-04-30'
    ];

    // Definir los headers en el formato correcto
    $headers = [
        'Authorization' => 'rapidito-pro;N4RaVsn|&BaXLTIk]1'
    ];

    try {
        // Realizar la solicitud GET con los headers y parámetros
        $response = $client->request('GET', $url, [
            'headers' => $headers,
            'query' => $params,     // Enviar los parámetros en la URL
            'http_errors' => false, // Evitar que CURL genere excepciones automáticas
            'verify' => false,       // Desactivar la verificación SSL (para pruebas)
            'timeout'     => 120
        ]);

        // Verificar si la respuesta fue exitosa
        if ($response->getStatusCode() === 200) {
            // Decodificar el JSON de la respuesta
            $dispatches = json_decode($response->getBody(), true);

            if (json_last_error() === JSON_ERROR_NONE) {
                // Filtrar transacciones duplicadas
                $uniqueDispatches = [];
                foreach ($dispatches as $dispatch) {
                    $key = $dispatch['secuential'] . '-' . $dispatch['warehouseName'] . '-' . $dispatch['transactionDate'];
                    if (!isset($uniqueDispatches[$key])) {
                        $uniqueDispatches[$key] = $dispatch;
                    }
                }
                $dispatches = array_values($uniqueDispatches);

                // Iniciar transacción para asegurar consistencia en la base de datos
                $db->transStart();

                // Instanciar el modelo de transacción
                $transaccionModel = new Transaccionmodel();

                foreach ($dispatches as $dispatch) {
                    try {
                        // Preparar los datos para insertar
                        $data = [
                            'trc_id_despacho' => $dispatch['dispatchId'] ?? null,
                            'trc_nombre_almacen' => $dispatch['warehouseName'] ?? '',
                            'trc_punto_emision' => $dispatch['emisionPoint'] ?? null,
                            'trc_fecha_transaccion' => $dispatch['transactionDate'] ?? null,
                            'trc_secuencial' => $dispatch['secuential'] ?? '',
                            'trc_dni_cliente' => $dispatch['clientDni'] ?? '',
                            'trc_nombre_cliente' => $dispatch['clientName'] ?? '',
                            'trc_metodo_pago' => $dispatch['paymentMethod'] ?? null,
                            'trc_total' => $dispatch['total'] ?? null,
                            'trc_monto_metodo_pago' => $dispatch['amountPaymentMethod'] ?? null
                        ];

                        // Intentar insertar la transacción si no existe
                        $trc_id = $transaccionModel->insertarTransaccionSiNoExiste($data);

                        // Insertar los detalles de la transacción si se ha insertado una cabecera nueva
                        if ($trc_id) {
                            foreach ($dispatch['dispatchDetailPresenters'] as $detail) {
                                $db->table('transaccion_detalle')->insert([
                                    'trd_id_cabecera' => $trc_id,
                                    'trd_es_pesado' => $detail['isHeavy'] ?? false,
                                    'trd_codigo_referencia' => $detail['referenceCode'] ?? '',
                                    'trd_descripcion' => $detail['description'] ?? '',
                                    'trd_cantidad_venta' => $detail['quantitySale'] ?? 0,
                                    'trd_unidad_medida' => $detail['mesaureUnit'] ?? '',
                                    'trd_precio_base' => $detail['basePrice'] ?? 0,
                                    'trd_precio_venta' => $detail['salePrice'] ?? 0,
                                    'trd_subtotal' => $detail['subtotal'] ?? 0
                                ]);
                            }
                        }

                    } catch (\Exception $e) {
                        // Si hay un error de base de datos, capturarlo y mostrarlo
                        $db->transRollback();
                        log_message('error', 'Error al insertar la transacción: ' . $e->getMessage());
                        return $this->response->setStatusCode(500)->setJSON([
                            'status' => 'error',
                            'message' => 'Error al insertar la transacción: ' . $e->getMessage()
                        ]);
                    }
                }

                // Finalizar la transacción
                if ($db->transComplete()) {
                    return $this->response->setJSON(['status' => 'success', 'message' => 'Datos guardados exitosamente.']);
                } else {
                    $error = $db->error();
                    log_message('error', 'Error en la transacción de la base de datos: ' . json_encode($error));
                    return $this->response->setStatusCode(500)->setJSON([
                        'status' => 'error',
                        'message' => 'Error en la transacción de la base de datos.',
                        'db_debug' => $error
                    ]);
                }

            } else {
                return $this->response->setStatusCode(400)->setJSON([
                    'status' => 'error',
                    'message' => 'Error al decodificar el JSON: ' . json_last_error_msg()
                ]);
            }
        } else {
            return $this->response->setStatusCode($response->getStatusCode())
                                  ->setBody('Error al consumir la API: ' . $response->getBody());
        }

    } catch (\Exception $e) {
        // Capturar cualquier error de la solicitud
        log_message('error', 'Error en la solicitud HTTP: ' . $e->getMessage());
        return $this->response->setStatusCode(ResponseInterface::HTTP_BAD_REQUEST)
                              ->setBody('Error: ' . $e->getMessage());
    }
}



    /**
     * Función para calcular comisiones por mes
     */
    
   
   public function TipoPagoTransacciones()
{
    $client = \Config\Services::curlrequest();
    $db = \Config\Database::connect('postgres');

    $url = 'https://api.megaprofer.com/api/dispatches/allDispatchPaymentMethod?init=2025-04-29&end=2025-04-30';
    $headers = [
        'Authorization' => 'rapidito-pro;N4RaVsn|&BaXLTIk]1'
    ];

    try {
        $response = $client->request('GET', $url, [
            'headers' => $headers,
            'http_errors' => false,
            'verify' => false
        ]);

        if ($response->getStatusCode() === 200) {
            $responseBody = $response->getBody();
            $dispatches = json_decode($responseBody, true);

            if (!is_array($dispatches)) {
                return $this->response->setStatusCode(500)->setJSON([
                    'status' => 'error',
                    'message' => 'Formato de respuesta inválido: ' . json_last_error_msg()
                ]);
            }

            $db->transStart();
            $transaccionModel = new \App\Models\Transaccionmodel();

            foreach ($dispatches as $dispatch) {
                try {
                    $data = [
                        'trp_dispatch_id' => $dispatch['dispatchId'] ?? null,
                        'trp_nombre_almacen' => $dispatch['warehouseName'] ?? '',
                        'trp_punto_emision' => $dispatch['emisionPoint'] ?? null,
                        'trp_fecha_transaccion' => isset($dispatch['transactionDate']) ? date('Y-m-d H:i:s', strtotime($dispatch['transactionDate'])) : null,
                        'trp_secuencial' => $dispatch['secuential'] ?? '',
                        'trp_dni_cliente' => $dispatch['clientDni'] ?? '',
                        'trp_nombre_cliente' => $dispatch['clientName'] ?? '',
                        'trp_metodo_pago' => $dispatch['paymentMethod'] ?? '',
                        'trp_total' => $dispatch['total'] ?? 0,
                        'trp_monto_metodo_pago' => $dispatch['amountPaymentMethod'] ?? 0
                    ];
                    log_message('info', 'Intentando insertar: ' . json_encode($data));
                    //echo'<pre>'; print_r($data); echo'</pre>';
                    $transaccionModel->insertarTransaccionTipoPagoSiNoExiste($data);
                } catch (\Exception $e) {
                    $db->transRollback();
                    log_message('error', 'Error al insertar: ' . $e->getMessage());
                    return $this->response->setStatusCode(500)->setJSON([
                        'status' => 'error',
                        'message' => 'Error al insertar la transacción: ' . $e->getMessage()
                    ]);
                }
            }

            if ($db->transComplete()) {
                return $this->response->setJSON(['status' => 'success', 'message' => 'Datos guardados exitosamente.']);
            } else {
                log_message('error', 'Error en la transacción de la base de datos.');
                return $this->response->setStatusCode(500)->setJSON(['status' => 'error', 'message' => 'Error en la transacción.']);
            }
        } else {
            return $this->response->setStatusCode($response->getStatusCode())->setBody('Error al consumir la API: ' . $response->getBody());
        }
    } catch (\Exception $e) {
        log_message('error', 'Error en la solicitud HTTP: ' . $e->getMessage());
        return $this->response->setStatusCode(500)->setBody('Error: ' . $e->getMessage());
    }
}




    public function Notascredito()
{
    // Instanciar el servicio de cliente HTTP
    $client = \Config\Services::curlrequest();
    $db = \Config\Database::connect('postgres'); // Conexión a PostgreSQL

    // Verificar la conexión a la base de datos
    if (!$db->connect()) {
        log_message('error', 'Error al conectar a PostgreSQL.');
        return $this->response->setStatusCode(500)->setBody('Error al conectar a PostgreSQL');
    } else {
        log_message('info', 'Conexión a PostgreSQL exitosa.');
    }

    // Definir la URL de la API
    $url = 'https://api.megaprofer.com/api/creditmemos/allCreditMemoByTransactionDate';

    // Parámetros de la consulta
    $params = [
        'init' => '2025-04-21',
        'end'  => '2025-04-30'
    ];

    // Definir correctamente los headers
    $headers = [
        'Authorization' => 'rapidito-prod;7g::H]d<e%USiL1QTW'
    ];

    try {
        // Realizar la solicitud GET con los parámetros y encabezados
        $response = $client->request('GET', $url, [
            'headers' => $headers,
            'query' => $params,
            'http_errors' => false,
            'verify' => false
        ]);

        // Verificar si la respuesta fue exitosa
        if ($response->getStatusCode() === 200) {
            $creditMemos = json_decode($response->getBody(), true);

            if (json_last_error() === JSON_ERROR_NONE) {
                // Iniciar transacción en la base de datos
                $db->transStart();
                $notaCreditoModel = new Notascreditomodel();

                foreach ($creditMemos as $memo) {//print_r($memo);
                    try {
                        // Verificar si la cabecera ya existe
                        $existsCabecera = $notaCreditoModel->existeCabecera(
                            $memo['dispatchId'] ?? null,
                            $memo['transactionDateNc'] ?? null,
                            $memo['secuentialNc'] ?? '',
                            $memo['secuentialFv'] ?? ''
                        );

                        if (!$existsCabecera) {
                            $dataCabecera = [
                                'ncc_dispatch_id' => $memo['dispatchId'] ?? null,
                                'ncc_nombre_almacen' => $memo['warehouseName'] ?? '',
                                'ncc_punto_emision' => $memo['emisionPoint'] ?? null,
                                'ncc_fecha_transaccion_nc' => $memo['transactionDateNc'] ?? null,
                                'ncc_secuencial_nc' => $memo['secuentialNc'] ?? '',
                                'ncc_fecha_transaccion_fv' => $memo['transactionDateFv'] ?? null,
                                'ncc_secuencial_fv' => $memo['secuentialFv'] ?? '',
                                'ncc_dni_cliente' => $memo['clientDni'] ?? '',
                                'ncc_nombre_cliente' => $memo['clientName'] ?? ''
                            ];
print_r($dataCabecera);
//echo '{';
                            // Insertar cabecera
                            $sqlCabecera = "INSERT INTO nota_credito_cabecera 
                                            (ncc_dispatch_id, ncc_nombre_almacen, ncc_punto_emision, ncc_fecha_transaccion_nc, ncc_secuencial_nc, ncc_fecha_transaccion_fv, ncc_secuencial_fv, ncc_dni_cliente, ncc_nombre_cliente)
                                            VALUES (:ncc_dispatch_id:, :ncc_nombre_almacen:, :ncc_punto_emision:, :ncc_fecha_transaccion_nc:, :ncc_secuencial_nc:, :ncc_fecha_transaccion_fv:, :ncc_secuencial_fv:, :ncc_dni_cliente:, :ncc_nombre_cliente:)
                                            RETURNING ncc_id";

                            $query = $db->query($sqlCabecera, $dataCabecera);
                            $result = $query->getRow();

                            if ($result) {
                                $ncc_id = $result->ncc_id;
                                //echo $sqlCabecera.'--'.$ncc_id;
                            } else {
                                throw new \Exception('No se pudo insertar la cabecera.');
                                echo 'No se pudo insertar la cabecera.';
                            }
                        

                        // Procesar detalles
                        foreach ($memo['creditMemoDetailPresenters'] as $detail) { //print_r($detail);
                            $existsDetalle = $notaCreditoModel->existeDetalle(
                                $ncc_id,
                                $detail['referenceCode'] ?? '',
                                $detail['description'] ?? ''
                            );

                            if (!$existsDetalle) {
                                $dataDetalle = [
                                    'ncd_id_cabecera' => $ncc_id,
                                    'ncd_es_pesado' => $detail['isHeavy'] ?? false,
                                    'ncd_codigo_referencia' => $detail['referenceCode'] ?? '',
                                    'ncd_descripcion_producto' => $detail['description'] ?? '',
                                    'ncd_cantidad' => $detail['quantitySale'] ?? 0,
                                    'ncd_unidad_medida' => $detail['mesaureUnit'] ?? '',
                                    'ncd_precio_base' => $detail['basePrice'] ?? 0,
                                    'ncd_precio_venta' => $detail['salePrice'] ?? 0,
                                    'ncd_subtotal' => $detail['subtotal'] ?? 0
                                ];
print_r($dataDetalle);
//echo '}';
                                // Insertar detalle
                                $notaCreditoModel->insertarDetalle($dataDetalle);
                            }
                        }
                        } else {
                            //$ncc_id = $existsCabecera->ncc_id;
                        }
                    } catch (\Exception $e) {
                        $db->transRollback();
                        log_message('error', 'Error al insertar la nota de crédito: ' . $e->getMessage());
                        return $this->response->setStatusCode(500)->setJSON([
                            'status' => 'error',
                            'message' => 'Error al insertar la nota de crédito: ' . $e->getMessage()
                        ]);
                    }
                }

                if ($db->transComplete()) {
                    return $this->response->setJSON(['status' => 'success', 'message' => 'Notas de crédito guardadas exitosamente.']);
                } else {
                    $error = $db->error();
                    log_message('error', 'Error en la transacción de la base de datos: ' . json_encode($error));
                    return $this->response->setStatusCode(500)->setJSON([
                        'status' => 'error',
                        'message' => 'Error en la transacción de la base de datos.',
                        'db_debug' => $error
                    ]);
                }
            } else {
                return $this->response->setStatusCode(400)->setJSON([
                    'status' => 'error',
                    'message' => 'Error al decodificar el JSON: ' . json_last_error_msg()
                ]);
            }
        } else {
            return $this->response->setStatusCode($response->getStatusCode())
                                  ->setBody('Error al consumir la API: ' . $response->getBody());
        }
    } catch (\Exception $e) {
        log_message('error', 'Error en la solicitud HTTP: ' . $e->getMessage());
        return $this->response->setStatusCode(ResponseInterface::HTTP_BAD_REQUEST)
                              ->setBody('Error: ' . $e->getMessage());
    }
}


    
    public function Cotizaciones()
{
    // Instanciar el servicio de cliente HTTP
    $client = \Config\Services::curlrequest();
    $db = \Config\Database::connect('postgres');  // Conexión a PostgreSQL

    // Definir la URL de la API
    $url = 'https://api.megaprofer.com/api/quotations/allQuotationsDispatch';
    $params = [
        'init' => '2025-03-21',
        'end'  => '2025-03-31'
    ];

    // Configurar el encabezado de autorización
    $headers = [
        'Authorization' => 'rapidito-prod;7g::H]d<e%USiL1QTW'
    ];

    try {
        // Realizar la solicitud GET con encabezados y opciones adicionales
        $response = $client->request('GET', $url, [
            'headers' => $headers,
            'query' => $params,
            'http_errors' => false, // Permitir manejar manualmente los errores HTTP
            'verify' => false       // Desactivar la verificación SSL en entornos de prueba
        ]);

        // Verificar si la respuesta fue exitosa
        if ($response->getStatusCode() === 200) {
            $cotizaciones = json_decode($response->getBody(), true);

            if (json_last_error() === JSON_ERROR_NONE) {
                // Iniciar transacción en la base de datos
                $db->transStart();
                $cotizacionModel = new Cotizacionmodel();
                foreach ($cotizaciones as $cotizacion) {
                    try {
                        // Preparar datos para la cabecera
                        $dataCabecera = [
                            'ctc_id_cotizacion' => $cotizacion['quotationId'],
                            'ctc_almacen' => $cotizacion['warehouseName'] ?? null,
                            'ctc_punto_emision' => $cotizacion['emisionPoint'] ?? null,
                            'ctc_fecha_transaccion' => date('Y-m-d H:i:s', strtotime($cotizacion['transactionDate'])),
                            'ctc_dni_cliente' => $cotizacion['clientDni'],
                            'ctc_nombre_cliente' => $cotizacion['clientName'],
                            'ctc_secuencial_cotizacion' => $cotizacion['sequentialQuotation'],
                            'trc_secuencial' => $cotizacion['sequentialFv'],
                            'ctc_total' => $cotizacion['total'],
                            'ctc_subtotal' => $cotizacion['subtotal']
                        ];

                        // Insertar la cabecera si no existe
                        $ctc_id = $cotizacionModel->insertarCotizacionCabecera($dataCabecera);
                        //echo "<pre>";print_r($dataCabecera);echo "</pre>";

                        // Si se inserta la cabecera, insertar los detalles
                        if ($ctc_id) {
                            foreach ($cotizacion['quotationDetailPresenters'] as $detalle) {
                                $dataDetalle = [
                                    'ctd_id_cabecera' => $ctc_id,
                                    'ctd_codigo_referencia' => $detalle['productReferenceCode'],
                                    'ctd_comision' => $detalle['commission']
                                ];
print_r($dataDetalle);
                                // Insertar el detalle
                                $cotizacionModel->insertarCotizacionDetalle($dataDetalle);
                            }
                        }
                    } catch (\Exception $e) {
                        $db->transRollback();  // Si hay error, hacer rollback
                        return $this->response->setStatusCode(500)->setJSON([
                            'status' => 'error',
                            'message' => 'Error al insertar la cotización: ' . $e->getMessage()
                        ]);
                    }
                }

                // Completar la transacción
                if ($db->transComplete()) {
                    return $this->response->setJSON(['status' => 'success', 'message' => 'Datos guardados exitosamente.']);
                } else {
                    $error = $db->error();
                    return $this->response->setStatusCode(500)->setJSON([
                        'status' => 'error',
                        'message' => 'Error en la transacción de la base de datos.',
                        'db_debug' => $error
                    ]);
                }
            } else {
                return $this->response->setStatusCode(400)->setJSON([
                    'status' => 'error',
                    'message' => 'Error al decodificar el JSON: ' . json_last_error_msg()
                ]);
            }
        } else {
            return $this->response->setStatusCode($response->getStatusCode())
                                  ->setBody('Error al consumir la API: ' . $response->getBody());
        }
    } catch (\Exception $e) {
        return $this->response->setStatusCode(ResponseInterface::HTTP_BAD_REQUEST)
                              ->setBody('Error: ' . $e->getMessage());
    }
}


//-------------------------------------------------DIARIO-----------------

public function TransaccionesDia()
{
    // Instanciar el servicio de cliente HTTP
    $client = \Config\Services::curlrequest();
    $db = \Config\Database::connect('postgres'); // Conexión a PostgreSQL

    // Obtener la fecha de ayer
    $yesterday = new \DateTime('yesterday');
    $fechaAyer = $yesterday->format('Y-m-d');

    // Definir la URL de la API
    $url = 'https://api.megaprofer.com/api/dispatches/allDispatchByTransactionDate';

    // Parámetros de la consulta (solo el día anterior)
    $params = [
        'init' => $fechaAyer,
        'end'  => $fechaAyer
    ];

    // Definir los headers en el formato correcto
    $headers = [
        'Authorization' => 'rapidito-pro;N4RaVsn|&BaXLTIk]1'
    ];

    try {
        // Realizar la solicitud GET con los headers y parámetros
        $response = $client->request('GET', $url, [
            'headers' => $headers,
            'query' => $params,     // Enviar los parámetros en la URL
            'http_errors' => false, // Evitar que CURL genere excepciones automáticas
            'verify' => false,       // Desactivar la verificación SSL (para pruebas)
            'timeout'     => 120
        ]);

        // Verificar si la respuesta fue exitosa
        if ($response->getStatusCode() === 200) {
            // Decodificar el JSON de la respuesta
            $dispatches = json_decode($response->getBody(), true);

            if (json_last_error() === JSON_ERROR_NONE) {
                // Filtrar transacciones duplicadas
                $uniqueDispatches = [];
                foreach ($dispatches as $dispatch) {
                    $key = $dispatch['secuential'] . '-' . $dispatch['warehouseName'] . '-' . $dispatch['transactionDate'];
                    if (!isset($uniqueDispatches[$key])) {
                        $uniqueDispatches[$key] = $dispatch;
                    }
                }
                $dispatches = array_values($uniqueDispatches);

                // Iniciar transacción para asegurar consistencia en la base de datos
                $db->transStart();

                // Instanciar el modelo de transacción
                $transaccionModel = new Transaccionmodel();

                foreach ($dispatches as $dispatch) {
                    try {
                        // Preparar los datos para insertar
                        $data = [
                            'trc_id_despacho' => $dispatch['dispatchId'] ?? null,
                            'trc_nombre_almacen' => $dispatch['warehouseName'] ?? '',
                            'trc_punto_emision' => $dispatch['emisionPoint'] ?? null,
                            'trc_fecha_transaccion' => $dispatch['transactionDate'] ?? null,
                            'trc_secuencial' => $dispatch['secuential'] ?? '',
                            'trc_dni_cliente' => $dispatch['clientDni'] ?? '',
                            'trc_nombre_cliente' => $dispatch['clientName'] ?? '',
                            'trc_metodo_pago' => $dispatch['paymentMethod'] ?? null,
                            'trc_total' => $dispatch['total'] ?? null,
                            'trc_monto_metodo_pago' => $dispatch['amountPaymentMethod'] ?? null
                        ];

                        // Intentar insertar la transacción si no existe
                        $trc_id = $transaccionModel->insertarTransaccionSiNoExiste($data);

                        // Insertar los detalles de la transacción si se ha insertado una cabecera nueva
                        if ($trc_id) {
                            foreach ($dispatch['dispatchDetailPresenters'] as $detail) {
                                $db->table('transaccion_detalle')->insert([
                                    'trd_id_cabecera' => $trc_id,
                                    'trd_es_pesado' => $detail['isHeavy'] ?? false,
                                    'trd_codigo_referencia' => $detail['referenceCode'] ?? '',
                                    'trd_descripcion' => $detail['description'] ?? '',
                                    'trd_cantidad_venta' => $detail['quantitySale'] ?? 0,
                                    'trd_unidad_medida' => $detail['mesaureUnit'] ?? '',
                                    'trd_precio_base' => $detail['basePrice'] ?? 0,
                                    'trd_precio_venta' => $detail['salePrice'] ?? 0,
                                    'trd_subtotal' => $detail['subtotal'] ?? 0
                                ]);
                            }
                        }

                    } catch (\Exception $e) {
                        // Si hay un error de base de datos, capturarlo y mostrarlo
                        $db->transRollback();
                        log_message('error', 'Error al insertar la transacción: ' . $e->getMessage());
                        return $this->response->setStatusCode(500)->setJSON([
                            'status' => 'error',
                            'message' => 'Error al insertar la transacción: ' . $e->getMessage()
                        ]);
                    }
                }

                // Finalizar la transacción
                if ($db->transComplete()) {
                    return $this->response->setJSON(['status' => 'success', 'message' => 'Datos guardados exitosamente.']);
                } else {
                    $error = $db->error();
                    log_message('error', 'Error en la transacción de la base de datos: ' . json_encode($error));
                    return $this->response->setStatusCode(500)->setJSON([
                        'status' => 'error',
                        'message' => 'Error en la transacción de la base de datos.',
                        'db_debug' => $error
                    ]);
                }

            } else {
                return $this->response->setStatusCode(400)->setJSON([
                    'status' => 'error',
                    'message' => 'Error al decodificar el JSON: ' . json_last_error_msg()
                ]);
            }
        } else {
            return $this->response->setStatusCode($response->getStatusCode())
                                  ->setBody('Error al consumir la API: ' . $response->getBody());
        }

    } catch (\Exception $e) {
        // Capturar cualquier error de la solicitud
        log_message('error', 'Error en la solicitud HTTP: ' . $e->getMessage());
        return $this->response->setStatusCode(ResponseInterface::HTTP_BAD_REQUEST)
                              ->setBody('Error: ' . $e->getMessage());
    }
}
public function TipoPagoTransaccionesDia()
{
    $client = \Config\Services::curlrequest();
    $db = \Config\Database::connect('postgres');

    // Obtener la fecha de ayer dinámicamente
    $yesterday = new \DateTime('yesterday');
    $fechaAyer = $yesterday->format('Y-m-d');

    // Construir la URL con la fecha de ayer
    $url = "https://api.megaprofer.com/api/dispatches/allDispatchPaymentMethod?init={$fechaAyer}&end={$fechaAyer}";
    
    $headers = [
        'Authorization' => 'rapidito-pro;N4RaVsn|&BaXLTIk]1'
    ];

    try {
        $response = $client->request('GET', $url, [
            'headers' => $headers,
            'http_errors' => false,
            'verify' => false
        ]);

        if ($response->getStatusCode() === 200) {
            $responseBody = $response->getBody();
            $dispatches = json_decode($responseBody, true);

            if (!is_array($dispatches)) {
                return $this->response->setStatusCode(500)->setJSON([
                    'status' => 'error',
                    'message' => 'Formato de respuesta inválido: ' . json_last_error_msg()
                ]);
            }

            $db->transStart();
            $transaccionModel = new \App\Models\Transaccionmodel();

            foreach ($dispatches as $dispatch) {
                try {
                    $data = [
                        'trp_dispatch_id' => $dispatch['dispatchId'] ?? null,
                        'trp_nombre_almacen' => $dispatch['warehouseName'] ?? '',
                        'trp_punto_emision' => $dispatch['emisionPoint'] ?? null,
                        'trp_fecha_transaccion' => isset($dispatch['transactionDate']) ? date('Y-m-d H:i:s', strtotime($dispatch['transactionDate'])) : null,
                        'trp_secuencial' => $dispatch['secuential'] ?? '',
                        'trp_dni_cliente' => $dispatch['clientDni'] ?? '',
                        'trp_nombre_cliente' => $dispatch['clientName'] ?? '',
                        'trp_metodo_pago' => $dispatch['paymentMethod'] ?? '',
                        'trp_total' => $dispatch['total'] ?? 0,
                        'trp_monto_metodo_pago' => $dispatch['amountPaymentMethod'] ?? 0
                    ];
                    
                    log_message('info', 'Intentando insertar: ' . json_encode($data));

                    $transaccionModel->insertarTransaccionTipoPagoSiNoExiste($data);
                } catch (\Exception $e) {
                    $db->transRollback();
                    log_message('error', 'Error al insertar: ' . $e->getMessage());
                    return $this->response->setStatusCode(500)->setJSON([
                        'status' => 'error',
                        'message' => 'Error al insertar la transacción: ' . $e->getMessage()
                    ]);
                }
            }

            if ($db->transComplete()) {
                return $this->response->setJSON(['status' => 'success', 'message' => 'Datos guardados exitosamente.']);
            } else {
                log_message('error', 'Error en la transacción de la base de datos.');
                return $this->response->setStatusCode(500)->setJSON(['status' => 'error', 'message' => 'Error en la transacción.']);
            }
        } else {
            return $this->response->setStatusCode($response->getStatusCode())->setBody('Error al consumir la API: ' . $response->getBody());
        }
    } catch (\Exception $e) {
        log_message('error', 'Error en la solicitud HTTP: ' . $e->getMessage());
        return $this->response->setStatusCode(500)->setBody('Error: ' . $e->getMessage());
    }
}
public function NotascreditoDia()
{
    // Instanciar el servicio de cliente HTTP
    $client = \Config\Services::curlrequest();
    $db = \Config\Database::connect('postgres'); // Conexión a PostgreSQL

    // Obtener la fecha de ayer dinámicamente
    $yesterday = new \DateTime('yesterday');
    $fechaAyer = $yesterday->format('Y-m-d');

    // Definir la URL de la API con la fecha de ayer
    $url = "https://api.megaprofer.com/api/creditmemos/allCreditMemoByTransactionDate?init={$fechaAyer}&end={$fechaAyer}";

    // Definir correctamente los headers
    $headers = [
        'Authorization' => 'rapidito-prod;7g::H]d<e%USiL1QTW'
    ];

    try {
        // Realizar la solicitud GET con los parámetros y encabezados
        $response = $client->request('GET', $url, [
            'headers' => $headers,
            'http_errors' => false,
            'verify' => false
        ]);

        // Verificar si la respuesta fue exitosa
        if ($response->getStatusCode() === 200) {
            $creditMemos = json_decode($response->getBody(), true);

            if (json_last_error() === JSON_ERROR_NONE) {
                // Iniciar transacción en la base de datos
                $db->transStart();
                $notaCreditoModel = new Notascreditomodel();

                foreach ($creditMemos as $memo) {
                    try {
                        // Verificar si la cabecera ya existe
                        $existsCabecera = $notaCreditoModel->existeCabecera(
                            $memo['dispatchId'] ?? null,
                            $memo['transactionDateNc'] ?? null,
                            $memo['secuentialNc'] ?? ''
                        );

                        if (!$existsCabecera) {
                            $dataCabecera = [
                                'ncc_dispatch_id' => $memo['dispatchId'] ?? null,
                                'ncc_nombre_almacen' => $memo['warehouseName'] ?? '',
                                'ncc_punto_emision' => $memo['emisionPoint'] ?? null,
                                'ncc_fecha_transaccion_nc' => $memo['transactionDateNc'] ?? null,
                                'ncc_secuencial_nc' => $memo['secuentialNc'] ?? '',
                                'ncc_fecha_transaccion_fv' => $memo['transactionDateFv'] ?? null,
                                'ncc_secuencial_fv' => $memo['secuentialFv'] ?? '',
                                'ncc_dni_cliente' => $memo['clientDni'] ?? '',
                                'ncc_nombre_cliente' => $memo['clientName'] ?? ''
                            ];

                            // Insertar cabecera
                            $sqlCabecera = "INSERT INTO nota_credito_cabecera 
                                            (ncc_dispatch_id, ncc_nombre_almacen, ncc_punto_emision, ncc_fecha_transaccion_nc, ncc_secuencial_nc, ncc_fecha_transaccion_fv, ncc_secuencial_fv, ncc_dni_cliente, ncc_nombre_cliente)
                                            VALUES (:ncc_dispatch_id:, :ncc_nombre_almacen:, :ncc_punto_emision:, :ncc_fecha_transaccion_nc:, :ncc_secuencial_nc:, :ncc_fecha_transaccion_fv:, :ncc_secuencial_fv:, :ncc_dni_cliente:, :ncc_nombre_cliente:)
                                            RETURNING ncc_id";

                            $query = $db->query($sqlCabecera, $dataCabecera);
                            $result = $query->getRow();

                            if ($result) {
                                $ncc_id = $result->ncc_id;
                            } else {
                                throw new \Exception('No se pudo insertar la cabecera.');
                            }
                        } else {
                            $ncc_id = $existsCabecera->ncc_id;
                        }

                        // Procesar detalles
                        foreach ($memo['creditMemoDetailPresenters'] as $detail) {
                            $existsDetalle = $notaCreditoModel->existeDetalle(
                                $ncc_id,
                                $detail['referenceCode'] ?? '',
                                $detail['description'] ?? ''
                            );

                            if (!$existsDetalle) {
                                $dataDetalle = [
                                    'ncd_id_cabecera' => $ncc_id,
                                    'ncd_es_pesado' => $detail['isHeavy'] ?? false,
                                    'ncd_codigo_referencia' => $detail['referenceCode'] ?? '',
                                    'ncd_descripcion_producto' => $detail['description'] ?? '',
                                    'ncd_cantidad' => $detail['quantitySale'] ?? 0,
                                    'ncd_unidad_medida' => $detail['mesaureUnit'] ?? '',
                                    'ncd_precio_base' => $detail['basePrice'] ?? 0,
                                    'ncd_precio_venta' => $detail['salePrice'] ?? 0,
                                    'ncd_subtotal' => $detail['subtotal'] ?? 0
                                ];

                                // Insertar detalle
                                $notaCreditoModel->insertarDetalle($dataDetalle);
                            }
                        }
                    } catch (\Exception $e) {
                        $db->transRollback();
                        log_message('error', 'Error al insertar la nota de crédito: ' . $e->getMessage());
                        return $this->response->setStatusCode(500)->setJSON([
                            'status' => 'error',
                            'message' => 'Error al insertar la nota de crédito: ' . $e->getMessage()
                        ]);
                    }
                }

                if ($db->transComplete()) {
                    return $this->response->setJSON(['status' => 'success', 'message' => 'Notas de crédito guardadas exitosamente.']);
                } else {
                    $error = $db->error();
                    log_message('error', 'Error en la transacción de la base de datos: ' . json_encode($error));
                    return $this->response->setStatusCode(500)->setJSON([
                        'status' => 'error',
                        'message' => 'Error en la transacción de la base de datos.',
                        'db_debug' => $error
                    ]);
                }
            } else {
                return $this->response->setStatusCode(400)->setJSON([
                    'status' => 'error',
                    'message' => 'Error al decodificar el JSON: ' . json_last_error_msg()
                ]);
            }
        } else {
            return $this->response->setStatusCode($response->getStatusCode())
                                  ->setBody('Error al consumir la API: ' . $response->getBody());
        }
    } catch (\Exception $e) {
        log_message('error', 'Error en la solicitud HTTP: ' . $e->getMessage());
        return $this->response->setStatusCode(500)->setBody('Error: ' . $e->getMessage());
    }
}
public function CotizacionesDia()
{
    // Instanciar el servicio de cliente HTTP
    $client = \Config\Services::curlrequest();
    $db = \Config\Database::connect('postgres');  // Conexión a PostgreSQL

    // Obtener la fecha de ayer dinámicamente
    $yesterday = new \DateTime('yesterday');
    $fechaAyer = $yesterday->format('Y-m-d');

    // Definir la URL de la API con la fecha de ayer
    $url = "https://api.megaprofer.com/api/quotations/allQuotationsDispatch?init={$fechaAyer}&end={$fechaAyer}";

    // Configurar el encabezado de autorización
    $headers = [
        'Authorization' => 'rapidito-prod;7g::H]d<e%USiL1QTW'
    ];

    try {
        // Realizar la solicitud GET con encabezados y opciones adicionales
        $response = $client->request('GET', $url, [
            'headers' => $headers,
            'http_errors' => false, // Permitir manejar manualmente los errores HTTP
            'verify' => false       // Desactivar la verificación SSL en entornos de prueba
        ]);

        // Verificar si la respuesta fue exitosa
        if ($response->getStatusCode() === 200) {
            $cotizaciones = json_decode($response->getBody(), true);

            if (json_last_error() === JSON_ERROR_NONE) {
                // Iniciar transacción en la base de datos
                $db->transStart();
                $cotizacionModel = new Cotizacionmodel();

                foreach ($cotizaciones as $cotizacion) {
                    try {
                        // Preparar datos para la cabecera
                        $dataCabecera = [
                            'ctc_id_cotizacion' => $cotizacion['quotationId'],
                            'ctc_almacen' => $cotizacion['warehouseName'] ?? null,
                            'ctc_punto_emision' => $cotizacion['emisionPoint'] ?? null,
                            'ctc_fecha_transaccion' => date('Y-m-d H:i:s', strtotime($cotizacion['transactionDate'])),
                            'ctc_dni_cliente' => $cotizacion['clientDni'],
                            'ctc_nombre_cliente' => $cotizacion['clientName'],
                            'ctc_secuencial_cotizacion' => $cotizacion['sequentialQuotation'],
                            'trc_secuencial' => $cotizacion['sequentialFv'],
                            'ctc_total' => $cotizacion['total'],
                            'ctc_subtotal' => $cotizacion['subtotal']
                        ];

                        // Insertar la cabecera si no existe
                        $ctc_id = $cotizacionModel->insertarCotizacionCabecera($dataCabecera);

                        // Si se inserta la cabecera, insertar los detalles
                        if ($ctc_id) {
                            foreach ($cotizacion['quotationDetailPresenters'] as $detalle) {
                                $dataDetalle = [
                                    'ctd_id_cabecera' => $ctc_id,
                                    'ctd_codigo_referencia' => $detalle['productReferenceCode'],
                                    'ctd_comision' => $detalle['commission']
                                ];

                                // Insertar el detalle
                                $cotizacionModel->insertarCotizacionDetalle($dataDetalle);
                            }
                        }
                    } catch (\Exception $e) {
                        $db->transRollback();  // Si hay error, hacer rollback
                        return $this->response->setStatusCode(500)->setJSON([
                            'status' => 'error',
                            'message' => 'Error al insertar la cotización: ' . $e->getMessage()
                        ]);
                    }
                }

                // Completar la transacción
                if ($db->transComplete()) {
                    return $this->response->setJSON(['status' => 'success', 'message' => 'Datos guardados exitosamente.']);
                } else {
                    $error = $db->error();
                    return $this->response->setStatusCode(500)->setJSON([
                        'status' => 'error',
                        'message' => 'Error en la transacción de la base de datos.',
                        'db_debug' => $error
                    ]);
                }
            } else {
                return $this->response->setStatusCode(400)->setJSON([
                    'status' => 'error',
                    'message' => 'Error al decodificar el JSON: ' . json_last_error_msg()
                ]);
            }
        } else {
            return $this->response->setStatusCode($response->getStatusCode())
                                  ->setBody('Error al consumir la API: ' . $response->getBody());
        }
    } catch (\Exception $e) {
        return $this->response->setStatusCode(500)->setBody('Error: ' . $e->getMessage());
    }
}


}
