<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class Descuentomensualvalormodel extends Model
{
    public function getDescuentomensual()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuentos_mensuales_valor');
        $builder->select('tbl_descuentos_mensuales_valor.*');    
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }  
    public function getDescuentomensualpuvididmes($puv_id,$dem_id,$dmv_mes)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuentos_mensuales_valor');
        $builder->select('tbl_descuentos_mensuales_valor.*');   
        $builder->where('tbl_descuentos_mensuales_valor.puv_id', $puv_id);
        $builder->where('tbl_descuentos_mensuales_valor.dem_id', $dem_id);
        $builder->where('tbl_descuentos_mensuales_valor.dmv_mes', $dmv_mes);    
       
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }   
     
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuentos_mensuales_valor');
        $builder->set($data);
		$builder->insert();

    }
    public function actualizar($dmv_id,$data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuentos_mensuales_valor');
        $builder->where('tbl_descuentos_mensuales_valor.dmv_id', $dmv_id);
		return $builder->update($data);        
    }
    public function getDescuentomensualidmes($dem_id,$dmv_mes)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuentos_mensuales_valor');
        $builder->select('tbl_descuentos_mensuales_valor.*,tbl_punto_venta.*');   
        $builder->where('tbl_descuentos_mensuales_valor.dem_id', $dem_id);
        $builder->where('tbl_descuentos_mensuales_valor.dmv_mes', $dmv_mes);   
        $builder->join('tbl_punto_venta', 'tbl_descuentos_mensuales_valor.puv_id=tbl_punto_venta.puv_id'); 
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }

    public function eliminarsegundemidmes($dem_id,$dmv_mes)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuentos_mensuales_valor');
        $builder->where('tbl_descuentos_mensuales_valor.dem_id', $dem_id);
        $builder->where('tbl_descuentos_mensuales_valor.dmv_mes', $dmv_mes);
        return $builder->delete();        
    }
    public function eliminar($dmv_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_descuentos_mensuales_valor');
        $builder->where('tbl_descuentos_mensuales_valor.dmv_id', $dmv_id);
        return $builder->delete();        
    }
    public function insertarDescuento($puv_id, $nombreDescuento, $valor,$mes) {
        $data = [
            'puv_id' => $puv_id,
            'dmv_valor' => $valor,
            'dem_id' => $this->buscarDescuentoPorNombre($nombreDescuento)['dem_id'],
            'dmv_mes' => $mes,  // Ejemplo: mes actual
            'dmv_estado' => 1
        ];
        
        // Usar el query builder para la inserción
        $builder = $this->db->table('tbl_descuentos_mensuales_valor');
        $builder->insert($data);

        
        

    }

    public function buscarDescuentoPorNombre($nombreDescuento) {
        if (!isset($this->db)) {
            $this->db = \Config\Database::connect();  // Conectar a la base de datos si no est conectado
        }
        $builder = $this->db->table('tbl_descuentos_mensuales');  // Inicializa el query builder para la tabla 'tbl_descuentos_mensuales'
        $builder->where('dem_nombre', $nombreDescuento);  // Aplica la condición 'where'
        //echo $builder->getCompiledSelect();
        $query = $builder->get();  // Ejecuta la consulta
        return $query->getRowArray();  // Retorna el resultado como un array
    }

}