<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class Prestamoabonocuotamodel extends Model
{
      
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_detalle_abono');
        $builder->set($data);
		$builder->insert();
    }
    
    public function getTotalAbonoCuotaPRDID($prd_id,$mes,$ano)
    {
        $db = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_detalle_abono');
        $builder->selectSum('tbl_prestamo_detalle_abono.pda_valor', 'saldo');  // Alias corregido
        $builder->where('tbl_prestamo_detalle_abono.prd_id', $prd_id);
        $builder->where("CONCAT(tbl_prestamo_detalle_abono.pda_mes_abono, tbl_prestamo_detalle_abono.pda_ano_abono) <", $mes.$ano);
        $query = $builder->get();
        $resultado = $query->getResultArray();
        return $resultado;

    }
    public function insertAbonoCuotaPRDID($pre_id, $pra_id, $prd_id, $mes, $ano, $valor, $saldo, $tipopago)
{
    $db = \Config\Database::connect();

    // Generar y eliminar registros existentes
    $builder = $db->table('tbl_prestamo_detalle_abono');
    $builder->where('prd_id', $prd_id);
    $builder->where("CONCAT(tbl_prestamo_detalle_abono.pda_mes_abono, tbl_prestamo_detalle_abono.pda_ano_abono) =", $mes . $ano);
    $builder->where('pda_tipo_pago', 'A');
    // Imprimir la consulta delete
   // echo $builder->getCompiledDelete(); // Imprime la consulta delete
    $builder->delete();

    // Preparar datos para la insercin
    $data = [
        'pre_id' => $pre_id,
        'pra_id' => $pra_id,
        'prd_id' => $prd_id,
        'pda_mes_abono' => $mes,
        'pda_ano_abono' => $ano,
        'pda_saldo_cuota' => $saldo,
        'pda_valor' => $valor,
        'pda_estado' => 0,
        'pda_tipo_pago' => $tipopago
    ];

    $builder = $db->table('tbl_prestamo_detalle_abono');
    $builder->set($data);
    //Imprimir la consulta insert
    //echo $builder->getCompiledInsert(); die();// Imprime la consulta insert
    $builder->insert(); 
}

    public function insertAbonoCuotaManual($pre_id,$pra_id,$prd_id,$mes,$ano,$valor,$saldo,$observacion,$tipopago)
    {
       $db = \Config\Database::connect();
        $data = [
            'pre_id' => $pre_id,
            'pra_id' => $pra_id,
            'prd_id'   => $prd_id,
            'pda_mes_abono' => $mes,
            'pda_ano_abono' => $ano,
            'pda_saldo_cuota'   => $saldo,
            'pda_valor'   => $valor,
            'pda_estado' => 0,
            'pda_tipo_pago' => $tipopago
        ];
         $builder = $db->table('tbl_prestamo_detalle_abono');
    $builder->set($data);
    //Imprimir la consulta insert
    //echo $builder->getCompiledInsert(); // Imprime la consulta insert
    $builder->insert(); 
    }
    public function reiniciarAbonoCuotaPRDID($prd_id,$mes,$ano)// elimina el abono que se realizo en una consulta anterior pero del mismo mes
    {
        $db = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_detalle_abono');
        $builder->where('prd_id', $prd_id);
        $builder->where("CONCAT(tbl_prestamo_detalle_abono.pda_mes_abono, tbl_prestamo_detalle_abono.pda_ano_abono) =", $mes.$ano);  // Expresión corregida
        $builder->where('pda_tipo_pago', 'A');
        $builder->delete(); 
        
    }
    
    public function insertCuotaPendiente($pre_id, $pra_id, $prd_id,$ppp_motivo,$ppp_transaccion, $puv_id )
    {
        $ppp_transaccion=$ppp_transaccion+1;
        $fecha=date('Y-m-d');
        $data = [
            'pre_id' => $pre_id,
            'pra_id' => $pra_id,
            'prd_id'   => $prd_id,
            'ppp_motivo' => $ppp_motivo,
            'ppp_fecha_registro' => $fecha,
            'ppp_transaccion'   => $ppp_transaccion,
            'puv_id' => $puv_id,
            'ppp_estado' => 0,
        ];
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_pendiente_pago');
        $builder->set($data);
		$builder->insert();  
    }
    public function updateRegistroAnteriorCuotaPendiente($prd_id,$ppp_motivo,$ppp_transaccion, $puv_id,$estado )
    {
        $ppp_transaccion=$ppp_transaccion+1;
        $fecha=date('Y-m-d');
        $data = [
            'ppp_motivo' => $ppp_motivo,
            'ppp_fecha_registro' => $fecha,
            'ppp_transaccion'   => $ppp_transaccion,
            'puv_id' => $puv_id,
            'ppp_estado' => $estado,
        ];
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_pendiente_pago');
        $builder->where('tbl_prestamo_pendiente_pago.prd_id', $prd_id);
        return $builder->update($data);        
    }
    
    public function getNumeroCuotasPendientesByPraId($pra_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_pendiente_pago');
        $builder->select('tbl_prestamo_pendiente_pago.ppp_id');  
        $builder->where('tbl_prestamo_pendiente_pago.pra_id', $pra_id);
        $builder->where('tbl_prestamo_pendiente_pago.ppp_estado', 0);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
}