<?php 
namespace App\Models;
 
use CodeIgniter\Model;
 
class Prestamomesgraciamodel extends Model
{
      
    public function insertar($data)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_mes_gracia');
        $builder->set($data);
		$builder->insert();
		
		$builder = $db->table('tbl_prestamo_mes_gracia');
        $builder->select('tbl_prestamo_mes_gracia.*');
        $builder->join('(select max(tbl_prestamo_mes_gracia.meg_id) as "id" from tbl_prestamo_mes_gracia) as a', 'tbl_prestamo_mes_gracia.meg_id=a.id');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado; 
    }
    
    public function registrarMesGraciaTablaAmortizacionDetalle($data,$mes,$ano,$pre_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_amortizacion');
        $builder->select('tbl_prestamo_amortizacion.*');  
        $builder->where('tbl_prestamo_amortizacion.pre_id', $pre_id);
        $builder->where('tbl_prestamo_amortizacion.pra_estado', 1);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        $pra_id=$resultado[0]['pra_id'];
        
        $builder = $db->table('tbl_prestamo_amortizacion_detalle');
        $builder->where('tbl_prestamo_amortizacion_detalle.prd_mes_estimado',$mes);
        $builder->where('tbl_prestamo_amortizacion_detalle.prd_ano_estimado',$ano);
        $builder->where('tbl_prestamo_amortizacion_detalle.pra_id',$pra_id);
        return $builder->update($data);     
    }
    
    public function getMesGraciaByPreid($pre_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_mes_gracia');
        $builder->select('tbl_prestamo_mes_gracia.*');   
        $builder->where('tbl_prestamo_mes_gracia.pre_id', $pre_id);
        $builder->where('tbl_prestamo_mes_gracia.meg_estado', 1);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getCobrarMesGracia($mes,$pra_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_amortizacion_detalle');
        $builder->select('tbl_prestamo_amortizacion_detalle.*');  
        $builder->join('(select max(tbl_prestamo_amortizacion_detalle.prd_numero_cuota) as "maxcuota" from tbl_prestamo_amortizacion_detalle where tbl_prestamo_amortizacion_detalle.pra_id='.$pra_id.') as b','tbl_prestamo_amortizacion_detalle.prd_numero_cuota=b.maxcuota ');
        $builder->where('tbl_prestamo_amortizacion_detalle.pra_id', $pra_id);
        $builder->where('concat(tbl_prestamo_amortizacion_detalle.prd_ano_estimado,tbl_prestamo_amortizacion_detalle.prd_mes_estimado)>=', $mes);
        
        //$builder->where('concat(tbl_prestamo_amortizacion_detalle.prd_ano_real,tbl_prestamo_amortizacion_detalle.prd_mes_real)=', $mes);
        //$builder->orwhere('tbl_prestamo_amortizacion_detalle.prd_ano_real is NULL');
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function getMesGraciaByPreidMes($pre_id,$mes,$ano,$puv_id)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_mes_gracia');
        $builder->select('tbl_prestamo_mes_gracia.*'); 
        $builder->join('tbl_prestamos','tbl_prestamo_mes_gracia.pre_id=tbl_prestamos.pre_id');
        $builder->where('tbl_prestamo_mes_gracia.pre_id', $pre_id);
        $builder->where('tbl_prestamo_mes_gracia.meg_mes', $mes);
        $builder->where('tbl_prestamo_mes_gracia.meg_ano', $ano);
        //$builder->where('tbl_prestamo_mes_gracia.meg_estado', 1);
        $builder->where('tbl_prestamos.puv_id', $puv_id);
        $query=$builder->get();
        $resultado=$query->getResultArray();
        return $resultado;
    }
    public function otorgarMesGracia($meg_id)
    {
        $data = [
            'meg_estado' => 2,
        ];
        $db      = \Config\Database::connect();
        $builder = $db->table('tbl_prestamo_mes_gracia');
        $builder->where('tbl_prestamo_mes_gracia.meg_id', $meg_id);
        return $builder->update($data);        
    }
}