<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Contratoestadomodel;

class Contratoestado extends BaseController
{

	public function index(){
		$contrato_estado_model= new Contratoestadomodel();
		$datos_contrato_estado=$contrato_estado_model->getContratoestado();

		$enviar_datos=array(
			'datos_contrato_estado' => !empty($datos_contrato_estado)?$datos_contrato_estado:null , 
		);
		
		$datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("contratoestado/list",$enviar_datos);
		echo view("layouts/footer");
	}

	
	public function add(){
		$session = \Config\Services::session();
		$contrato_estado_model= new Contratoestadomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('contratoestado'))){
				$esc_estadocontrato=$this->request->getPost('contratoestado');
				$ingresar_datos=array(
					'esc_estadocontrato'=>$esc_estadocontrato,
					'esc_estado'=>1
				);
				$contrato_estado_model->insertar($ingresar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
				return redirect()->to(base_url('Contratoestado')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Contratoestado')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}


	}
	

	public function edit(){
		$session = \Config\Services::session();
		$contrato_estado_model= new Contratoestadomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('editesccontratoestado')) && !empty($this->request->getPost('editescid'))){
				$esc_estadocontrato=$this->request->getPost('editesccontratoestado');
				$esc_id=$this->request->getPost('editescid');
				$editar_datos=array(
					'esc_estadocontrato'=>$esc_estadocontrato,
					'esc_estado'=>1
				);
				$contrato_estado_model->actualizar($esc_id,$editar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Editado');
				return redirect()->to(base_url('Contratoestado')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Contratoestado')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}

	public function eliminar($id){		
		
		$session = \Config\Services::session();
		$contrato_estado_model= new Contratoestadomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($id)){				
				$eliminar_datos=array(
					'esc_estado'=>0
				);
				$contrato_estado_model->eliminar($id,$eliminar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Eliminado');
				return redirect()->to(base_url('Contratoestado')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Contratoestado')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	
		
	
    public function datosMenu()
    {
        $session = \Config\Services::session();
        
        $usuario_model=new UsuarioModel();
        
        $rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
        $menu = $usuario_model->selectMenu();
        $datos = array(
            'rolMenu' => $rm,
            'menu' => $menu
        );
        return $datos;
    }
}