<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Planmercadeoestadomodel;

class Planmercadeoestado extends BaseController
{

	public function index(){
		$plan_mercade_estado_model= new Planmercadeoestadomodel();
		$datos_plan_mercade_estado=$plan_mercade_estado_model->getPlanmercadeoestado();


		$enviar_datos=array(
			'datos_plan_mercade_estado' => !empty($datos_plan_mercade_estado)?$datos_plan_mercade_estado:null , 
		);

		$datos = $this->datosMenu();
		
		echo view("layouts/header");
		echo view("layouts/aside", $datos);
		echo view("planmercadeoestado/list",$enviar_datos);
		echo view("layouts/footer");
	}

	
	public function add(){
		$session = \Config\Services::session();
		$plan_mercade_estado_model= new Planmercadeoestadomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('estadoplan'))){
				$esp_estadoplan=$this->request->getPost('estadoplan');
				$ingresar_datos=array(
					'esp_estadoplan'=>$esp_estadoplan,
					'esp_estado'=>1
				);
				$plan_mercade_estado_model->insertar($ingresar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
				return redirect()->to(base_url('Planmercadeoestado')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Planmercadeoestado')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}


	}
	

	public function edit(){
		$session = \Config\Services::session();
		$plan_mercade_estado_model= new Planmercadeoestadomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('editestadoplan')) && !empty($this->request->getPost('editespid'))){
				$esp_estadoplan=$this->request->getPost('editestadoplan');
				$esp_id=$this->request->getPost('editespid');
				$editar_datos=array(
					'esp_estadoplan'=>$esp_estadoplan,
					'esp_estado'=>1
				);
				$plan_mercade_estado_model->actualizar($esp_id,$editar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Editado');
				return redirect()->to(base_url('Planmercadeoestado')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Planmercadeoestado')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}

	public function eliminar($id){		
		
		$session = \Config\Services::session();
		$plan_mercade_estado_model= new Planmercadeoestadomodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($id)){				
				$eliminar_datos=array(
					'esp_estado'=>0
				);
				$plan_mercade_estado_model->eliminar($id,$eliminar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Eliminado');
				return redirect()->to(base_url('Planmercadeoestado')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Planmercadeoestado')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	
	public function datosMenu()
    {
        $session = \Config\Services::session();
        
        $usuario_model=new UsuarioModel();
        
        $rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
        $menu = $usuario_model->selectMenu();
        $datos = array(
            'rolMenu' => $rm,
            'menu' => $menu
        );
        return $datos;
    }
}