<?php

namespace App\Controllers;
use App\Models\UsuarioModel;
use App\Models\Proveedormodel;

class Proveedor extends BaseController
{

	public function index(){
		$proveedor_model= new Proveedormodel();
		$datos_proveedor=$proveedor_model->getProveedor();
        $usuario_model=new Usuariomodel();
        $coordinador=$usuario_model->getUsuarioCoordinador();
		$enviar_datos=array(
			'datos_proveedor' => !empty($datos_proveedor)?$datos_proveedor:[] , 
			'coordinador'=>!empty($coordinador)?$coordinador:[] , 
		);

		$datos = $this->datosMenu();

		echo view("layouts/header");
		echo view("layouts/aside",$datos);
		echo view("proveedor/list",$enviar_datos);
		echo view("layouts/footer");
	}

	
	public function add(){
		$session = \Config\Services::session();
		$proveedor_model= new Proveedormodel();
		
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('proveedor'))&&!empty($this->request->getPost('coordinador'))){
				$pro_nombre=$this->request->getPost('proveedor');
				$coordinador=$this->request->getPost('coordinador');
				$ingresar_datos=array(				
					'pro_nombre'=>$pro_nombre,
					'tpp_id'=>1,
					'pro_estado'=>1,
					'pro_coordinador'=>$coordinador
				);

				$proveedor_model->insertar($ingresar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Ingresado');
				return redirect()->to(base_url('Proveedor')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Proveedor')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}


	}
	

	public function edit(){
		$session = \Config\Services::session();
		$proveedor_model= new Proveedormodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($this->request->getPost('editproveedor')) && !empty($this->request->getPost('editproid'))&&!empty($this->request->getPost('editcoordinador'))){
				$pro_nombre=$this->request->getPost('editproveedor');
				$pro_id=$this->request->getPost('editproid');
				$coordinador=$this->request->getPost('editcoordinador');
				$editar_datos=array(
					'pro_nombre'=>$pro_nombre,
					'tpp_id'=>1,
					'pro_estado'=>1,
					'pro_coordinador'=>$coordinador
				);
				$proveedor_model->actualizar($pro_id,$editar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Editado');
				return redirect()->to(base_url('Proveedor')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Proveedor')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}

	public function eliminar($id){		
		
		$session = \Config\Services::session();
		$proveedor_model= new Proveedormodel();
		if($session->get('USU_CORREO')!=null){
			if(!empty($id)){				
				$eliminar_datos=array(
					'pro_estado'=>0
				);
				$proveedor_model->eliminar($id,$eliminar_datos);
				$session->setFlashdata('mensaje_bueno', 'Dato Eliminado');
				return redirect()->to(base_url('Proveedor')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese Datos');
				return redirect()->to(base_url('Proveedor')); 
			} 
		}else{

			return redirect()->to(base_url()); 
		}
	}
	
	public function datosMenu()
    {
        $session = \Config\Services::session();
        
        $usuario_model=new UsuarioModel();
        
        $rm = $usuario_model->buscarRolMenu($session->get('ROL_ID'));
        $menu = $usuario_model->selectMenu();
        $datos = array(
            'rolMenu' => $rm,
            'menu' => $menu
        );
        return $datos;
    }
}