<script src="https://unpkg.com/read-excel-file@5.x/bundle/read-excel-file.min.js"></script>
<script>
    class Excel{
        constructor(content){
            this.content=content;
        }
        header(){
            return this.content[0];
        }
        rows(){
            return new RowCollection(this.content.slice(1,this.content.length));
        }
    }
    class RowCollection{
        constructor(rows){
            this.rows=rows;
        }
        get(index){
            return new Row(this.rows[index]);
        }
        count(){
            return this.rows.length;
        }
    }
    class Row{
        constructor(row){
            this.row=row;
        }
        codigo(){
            return this.row[0];
        }
        descripcion(){
            return this.row[1];
        }
        margenActual(){
            return this.row[2];
        }
        descuentoAutorizador(){
            return this.row[3];
        }
        ventaProyectadaUnidades(){
            return this.row[4];
        }
        ventaProyectadaValorizada(){
            return this.row[5];
        }
        margenProyectado(){
            return this.row[6];
        }
        count(){
            return this.row.length;
        }
    }
    class ExcelPrinter{
        static print(tableId, excel){
            const table=document.getElementById(tableId);
            
            if(excel.header().length==7 && excel.header()[0]=='CÓDIGO' && excel.header()[1]=='DESCRIPCIÓN' && excel.header()[2]=='MARGEN ACTUAL' && excel.header()[3]=='DESCUENTO DESDE AUTORIZADOR' && excel.header()[4]=='VENTA PROYECTADA EN UNIDADES' && excel.header()[5]=='VENTA PROYECTADA VALORIZADA' && excel.header()[6]=='MARGEN PROYECTADO' ){
                excel.header().forEach(title=>(
                    table.querySelector("thead>tr").innerHTML+=`<th>${title}</th>`
                    ))
                   
                for(let index=0; index<excel.rows().count();index++)
                {
                    const row=excel.rows().get(index);
                    
                    table.querySelector("tbody").innerHTML+=`
                    <tr>
                    <td>${row.codigo()}</td>
                    <td>${row.descripcion()}</td>
                    <td style='text-align:right'>${USDollar.format(row.margenActual())}</td>
                    <td style='text-align:right'>${USDollar.format(row.descuentoAutorizador())}</td>
                    <td style='text-align:right'>${USDollar.format(row.ventaProyectadaUnidades())}</td>
                    <td style='text-align:right'>${USDollar.format(row.ventaProyectadaValorizada())}</td>
                    <td style='text-align:right'>${USDollar.format(row.margenProyectado())}</td>
                    </tr>`
                }
                document.getElementById('datosdetalleproducto').value=(JSON.stringify(excel.rows())); //alert(document.getElementById('datosdetalleproducto').value);
            }
            else{
                alert("Error en el archivo");
                document.getElementById('detalle').value='';
                table.querySelector("tbody").innerHTML='';
                table.querySelector("thead").innerHTML='';
            }
        }
        
    }
   
    var excelInput=document.getElementById('detalleproducto');
    
    excelInput.addEventListener('change',async function(){ 
        const table=document.getElementById("detalle");
        if(typeof(excelInput.files[0])!='undefined'){
            const content=await readXlsxFile(excelInput.files[0]);
            const excel=new Excel(content);
            console.log(ExcelPrinter.print("detalle",excel));
        }
        else
        {
            table.querySelector("thead").innerHTML='';
            table.querySelector("tbody").innerHTML='';
            document.getElementById('detalle').value='';
        }
    });
    
    let USDollar = new Intl.NumberFormat('en-US', {
        style: 'currency',
        currency: 'USD',
    });

</script>