<?php

namespace Config;

use CodeIgniter\Config\BaseConfig;

class Filters extends BaseConfig
{
    public $aliases = [
        'csrf'          => \CodeIgniter\Filters\CSRF::class,
        'toolbar'       => \CodeIgniter\Filters\DebugToolbar::class,
        'honeypot'      => \CodeIgniter\Filters\Honeypot::class,
        'invalidchars'  => \CodeIgniter\Filters\InvalidChars::class,
        'secureheaders' => \CodeIgniter\Filters\SecureHeaders::class,

        // Filtro propio
        //'auth'          => \App\Filters\AuthFilter::class,
    ];

    public $globals = [
        'before' => [
            // Aplica el filtro de autenticación a todo...
            
            // 'csrf', // activa si usas CSRF global
        ],
        'after' => [
            'toolbar', // útil en desarrollo
        ],
    ];

    public $methods = [
        // 'post' => ['csrf'],
    ];

    public $filters = [
        // Si ya lo pusiste en $globals no necesitas repetir aquí
    ];
}
