<?php namespace App\Controllers;

use App\Models\UsuarioModel;

class Auth extends BaseController
{
    public function index()
    {
        return view('Login/login'); // tu vista de login
    }

    public function login()
{
    if ($this->request->getMethod() !== 'post') {
        return redirect()->to(base_url('Auth'));
    }

    $correo = trim((string) $this->request->getPost('correo'));
    $clave  = (string) $this->request->getPost('clave');

    if ($correo === '' || $clave === '') {
        return redirect()->back()->with('mensaje_malo', 'Completa usuario y contraseña.');
    }

    $u = new UsuarioModel();
    $user = $u->verificarCredenciales($correo, $clave);

    if (!$user) {
        return redirect()->back()->with('mensaje_malo', 'Correo o contraseña incorrectos.');
    }

    // Roles del usuario
    $roles = $u->rolesDeUsuario((int) $user['usu_id']);

    // ====== Cargar menú y permisos en sesión ======
    $menu = [];
    $rolMenu = [];
    try {
        $menuModel = new \App\Models\MenuModel();
        $menu    = $menuModel->menuCompleto();                       // Array de MEN_*
        $rolMenu = $menuModel->menuIdsPorUsuario((int)$user['usu_id']); // MEN_ID permitidos
    } catch (\Throwable $e) {
        // Si falla, deja arrays vacíos (la vista está blindada)
        $menu = [];
        $rolMenu = [];
    }

    // Variables de sesión
    session()->set([
        'USU_ID'     => (int) $user['usu_id'],
        'USU_NOMBRE' => $user['usu_nombre'] ?? '',
        'USU_CORREO' => $user['usu_email']  ?? '',
        'ROLES'      => $roles,
        'MENU'       => $menu,
        'ROL_MENU'   => $rolMenu,
        'isLoggedIn' => true,
    ]);

    $u->marcarUltimoLogin((int) $user['usu_id']);

    return redirect()->to(base_url('Home'));
}


    public function logout()
    {
        session()->destroy();
        return redirect()->to(base_url('/'));
    }
}
