<?php
namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\DescuentoPrecioModel;
use App\Models\MargenHoyModel;
use CodeIgniter\Database\Exceptions\DatabaseException;

class PreciosController extends BaseController
{
    public function index()
    {
        $db = \Config\Database::connect();
        $descuentoModel = new DescuentoPrecioModel($db);
        $margenModel    = new MargenHoyModel($db);

        // Activos actuales
        $activos = [];
        foreach (DescuentoPrecioModel::TIPOS as $t) {
            $row = $descuentoModel->where(['dpr_tipo'=>$t,'dpr_activo'=>true])->first();
            $activos[$t] = $row ?: [
                'dpr_tipo'=>$t,'dpr_porcentaje'=>'0.0000','dpr_sentido'=>'D','dpr_observacion'=>null
            ];
        }
        $margenActivo = $margenModel->where('mho_activo', true)->first() ?: [
            'mho_margen'=>'0.0000','mho_observacion'=>null
        ];

        // Historial
        $histDescuentos = $descuentoModel->orderBy('dpr_id','DESC')->findAll(200);
        $histMHo        = $margenModel->orderBy('mho_id','DESC')->findAll(200);


        echo view('layouts/header');
        echo view('layouts/aside');
        echo view('precios/reglas', [
            'activos'=>$activos,
            'margenActivo'=>$margenActivo,
            'histDescuentos'=>$histDescuentos,
            'histMHo'=>$histMHo
        ]);
        echo view('layouts/footer');
        
    }

    

    public function guardarMargen()
    {
        $db = \Config\Database::connect();
        $margenModel = new MargenHoyModel($db);
        $userId = session()->get('user_id');
    
        $margen = number_format((float)$this->request->getPost('mho_margen'), 4, '.', '');
        $obs    = trim($this->request->getPost('mho_observacion') ?? '');
    
        $db->transBegin();
        try {
            // Inactivar actual
            $db->query("UPDATE tbl_margen_hoy SET mho_activo=false, mho_updated_by=?, mho_updated_at=now() WHERE mho_activo=true", [$userId]);
    
            // Insertar nuevo margen
            $margenModel->insert([
                'mho_margen'      => $margen,
                'mho_observacion' => $obs !== '' ? $obs : null,
                'mho_activo'      => true,
                'mho_created_by'  => $userId,
                'mho_updated_by'  => $userId,
                'mho_created_at'  => date('c'),
                'mho_updated_at'  => date('c'),
            ]);
    
            // Recalcular dpr_margen de los descuentos activos
            $sql = "
              UPDATE public.tbl_descuentos_precios d
              SET dpr_margen = ROUND(
                    :margen::numeric *
                    CASE WHEN d.dpr_sentido = 'D'
                         THEN (1 - d.dpr_porcentaje/100.0)
                         ELSE (1 + d.dpr_porcentaje/100.0)
                    END, 4
                  ),
                  dpr_updated_by = :uid,
                  dpr_updated_at = now()
              WHERE dpr_activo = true
            ";
            $db->query($sql, ['margen' => $margen, 'uid' => $userId]);
    
            $db->transCommit();
            return redirect()->back()->with('ok','Margen hoy actualizado y márgenes recalculados.');
        } catch (\Throwable $e) {
            $db->transRollback();
            return redirect()->back()->with('error','Error al guardar: '.$e->getMessage());
        }
    }

    public function guardarDescuentos()
    {
        $db = \Config\Database::connect();
        $descuentoModel = new DescuentoPrecioModel($db);
        $margenModel    = new MargenHoyModel($db);
        $userId = session()->get('user_id');
    
        // margen hoy activo (default 0)
        $mh = $margenModel->where('mho_activo', true)->orderBy('mho_id','DESC')->first();
        $margenHoy = (float)($mh['mho_margen'] ?? 0);
    
        $datos = $this->request->getPost('dpr');
    
        $db->transBegin();
        try {
            // Inactivar actuales
            $db->query(
              "UPDATE tbl_descuentos_precios SET dpr_activo=false, dpr_updated_by=?, dpr_updated_at=now() WHERE dpr_activo=true",
              [$userId]
            );
    
            // Insertar nuevos con margen calculado
            foreach (DescuentoPrecioModel::TIPOS as $tipo) {
                $p = $datos[$tipo] ?? null;
                if (!$p) continue;
    
                $porc    = (float)($p['porcentaje'] ?? 0);
                $sentido = ($p['sentido'] ?? 'D') === 'I' ? 'I' : 'D';
    
                // Fórmula: margen_tipo = margen_hoy * (1 ± porcentaje/100)
                $factor  = $sentido === 'D' ? (1 - $porc/100) : (1 + $porc/100);
                $margenCalc = number_format($margenHoy * $factor, 4, '.', '');
    
                $descuentoModel->insert([
                    'dpr_tipo'        => $tipo,
                    'dpr_porcentaje'  => number_format($porc, 4, '.', ''),
                    'dpr_sentido'     => $sentido,
                    'dpr_observacion' => trim($p['observacion'] ?? '') ?: null,
                    'dpr_margen'      => $margenCalc,           // <-- NUEVO
                    'dpr_activo'      => true,
                    'dpr_created_by'  => $userId,
                    'dpr_updated_by'  => $userId,
                    'dpr_created_at'  => date('c'),
                    'dpr_updated_at'  => date('c'),
                ]);
            }
    
            $db->transCommit();
            return redirect()->back()->with('ok','Descuentos actualizados y márgenes calculados.');
        } catch (\Throwable $e) {
            $db->transRollback();
            return redirect()->back()->with('error','Error al guardar: '.$e->getMessage());
        }
    }

}
