<?php namespace App\Models;

use CodeIgniter\Model;

class ParametrosProductoModel extends Model
{
    protected $table      = 'public.tbl_parametros_producto';
    protected $primaryKey = 'ppr_id';
    protected $returnType = 'array';
    protected $allowedFields = [
        'pro_codigo',
        'ppr_margen_hoy',
        'ppr_desc_normal','ppr_sentido_normal','ppr_margen_normal',
        'ppr_desc_limite','ppr_sentido_limite','ppr_margen_limite',
        'ppr_desc_admin', 'ppr_sentido_admin', 'ppr_margen_admin',
        'ppr_desc_mayorista','ppr_sentido_mayorista','ppr_margen_mayorista',
        'ppr_desc_especial','ppr_sentido_especial','ppr_margen_especial',
        'ppr_observacion','ppr_activo','ppr_created_at','ppr_updated_at'
    ];

    // Inactiva el set activo actual de un producto
    public function inactivarActivoPorCodigo(string $codigo): void
    {
        $this->db->table($this->table)
            ->set(['ppr_activo'=>false, 'ppr_updated_at'=>date('c')])
            ->where(['pro_codigo'=>$codigo,'ppr_activo'=>true])
            ->update();
    }

    // Cálculo general de márgenes (4 decimales): margen_tipo = margen_hoy × (1 − descuento/100)
    public static function calcularMargenes(float $margenHoy, array $porcentajes): array
    {
        $nf = fn($x)=> number_format($x, 4, '.', '');
        $calc = function($pct) use ($margenHoy){ return $margenHoy * (1 - ((float)$pct)/100.0); };

        return [
            'normal'     => $nf($calc($porcentajes['normal']     ?? 0)),
            'limite'     => $nf($calc($porcentajes['limite']     ?? 0)),
            'admin'      => $nf($calc($porcentajes['admin']      ?? 0)),
            'mayorista'  => $nf($calc($porcentajes['mayorista']  ?? 0)),
            'especial'   => $nf($calc($porcentajes['especial']   ?? 0)),
        ];
    }
    public function activoPorProducto(string $codigo)
    {
        return $this->where('pro_codigo', $codigo)
            ->where('ppr_activo', true)
            ->orderBy('ppr_updated_at', 'DESC')
            ->orderBy('ppr_id', 'DESC')
            ->first();
    }

    public function historial(string $codigo, int $limit=50)
    {
        return $this->where('pro_codigo',$codigo)
            ->orderBy('ppr_updated_at','DESC')
            ->orderBy('ppr_id','DESC')
            ->findAll($limit);
    }
}
