<?php /** @var array $items */ $matId = (int)($mat_id ?? 0); ?>
<div class="container-fluid" style="margin-top:80px">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h2 class="mb-0">Historial de versiones <small class="text-muted">(mat <?= $matId ?>)</small></h2>
    <a class="btn btn-sm btn-default" href="<?= site_url('matrices2/'.$matId.'/grid') ?>">Volver al grid</a>
  </div>

  <form class="card p-3 mb-3" method="get">
    <div class="row g-2 align-items-end">
      <div class="col-sm-3">
        <label class="form-label">Tipo</label>
        <select name="tipo" class="form-control form-control-sm">
          <option value="">Todos</option>
          <option value="DIST"   <?= (($_GET['tipo'] ?? '')==='DIST'?'selected':'') ?>>Distribución</option>
          <option value="PDV"    <?= (($_GET['tipo'] ?? '')==='PDV'?'selected':'') ?>>PDV</option>
          <option value="COSTOS" <?= (($_GET['tipo'] ?? '')==='COSTOS'?'selected':'') ?>>Costos</option>
        </select>
      </div>
      <div class="col-sm-5">
        <label class="form-label">Buscar</label>
        <input type="text" name="q" value="<?= esc($_GET['q'] ?? '') ?>" class="form-control form-control-sm" placeholder="Nombre de versión, motivo…">
      </div>
      <div class="col-sm-2">
        <button class="btn btn-primary btn-sm w-100">Filtrar</button>
      </div>
    </div>
  </form>

  <div class="card">
    <div class="table-responsive">
      <table class="table table-sm table-striped mb-0">
        <thead>
          <tr>
            <th>#</th>
            <th>Fecha</th>
            <th>Tipo</th>
            <th>Nombre</th>
            <th>Usuario</th>
            <th>Filas</th>
            <th>Meta</th>
            <th>Descargar</th>
          </tr>
        </thead>
        <tbody>
        <?php foreach ($items as $it): $meta = json_decode($it['mver_meta'] ?? '{}', true) ?: []; ?>
          <tr>
            <td><?= (int)$it['mver_id'] ?></td>
            <td><?= esc(date('Y-m-d H:i', strtotime($it['created_at']))) ?></td>
            <td><span class="badge bg-secondary"><?= esc($it['mver_tipo']) ?></span></td>
            <td><?= esc($it['mver_nombre']) ?></td>
            <td><?= esc($it['mver_usuario']) ?></td>
            <td><?= number_format((int)$it['mver_rows']) ?></td>
            <td>
              <small>
                Hasta: <strong><?= esc($meta['hasta'] ?? '') ?></strong>,
                Promo: <strong><?= !empty($meta['promo'])?'Sí':'No' ?></strong>,
                Motivo: <em><?= esc($meta['motivo'] ?? '') ?></em>
              </small>
            </td>
            <td>
  <a class="btn btn-sm btn-outline-primary" href="<?= site_url('matrices2/versions/view/'.$it['mver_id']) ?>">
    Ver
  </a>
  <a class="btn btn-sm btn-outline-dark" href="<?= site_url('matrices2/versions/json/'.$it['mver_id']) ?>">
    Descargar JSON
  </a>
</td>

            
          </tr>
        <?php endforeach ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
