<?php

namespace App\Controllers;


class CentroCosto extends BaseController
{

	public function index(){

		$opciones = array('http' =>
			array(
				'method'  => 'POST',
				'header'  => 'Content-type: application/x-www-form-urlencoded'
			)
		);
		$contexto = stream_context_create($opciones);
		$resultado = file_get_contents($this->url_api_conciliacion.'centrocostoindex', false, $contexto);
		$resultado_centro_costo=json_decode($resultado,true);

		if($resultado_centro_costo['code']==200){
			$datos=array(
				'datos_centro_costo'=>$resultado_centro_costo['data'],
			);
		}else{
			$datos=array(
				'mensaje'=>'No hay datos',
				'datos_centro_costo'=>[],
			);
		}


		echo view("layouts/header");
		echo view("layouts/aside");
		echo view("centrocosto/vistacentrocosto",$datos);
		echo view("layouts/footer");
	}

	
	public function add(){
		$session = \Config\Services::session();
		$cco_centro_costo=$this->request->getPost('cco_centro_costo');
        $cco_pdv=$this->request->getPost('cco_pdv');
        $cco_ctc=$this->request->getPost('cco_ctc');

		$datos_post = http_build_query(
			array(
				"cco_centro_costo"=> $cco_centro_costo,
                "cco_pdv"=> $cco_pdv,
                "cco_ctc"=> $cco_ctc,
			)
		);

		$opciones = array('http' =>
			array(
				'method'  => 'POST',
				'header'  => 'Content-type: application/x-www-form-urlencoded',
				'content' => $datos_post
			)
		);

		$contexto = stream_context_create($opciones);
		$resultado = file_get_contents($this->url_api_conciliacion.'centrocostocreate', false, $contexto);
		$resultado=json_decode($resultado,true);  

		if(!empty($resultado)){
			if($resultado['code'] ==200){
				$session->setFlashdata('mensaje_bueno', 'Agregado con exito');
				return redirect()->to(base_url('CentroCosto')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Fallo, al momento de agregar');
				return redirect()->to(base_url('CentroCosto')); 
			}

		}else{
			$session->setFlashdata('mensaje_malo', 'respuesta nula');
			return redirect()->to(base_url('CentroCosto')); 
		}     

	}

	

	public function editar(){
		$session = \Config\Services::session();
		$edit_cco_centro_costo=$this->request->getPost('edit_cco_centro_costo');
        $edit_cco_pdv=$this->request->getPost('edit_cco_pdv');
        $edit_cco_ctc=$this->request->getPost('edit_cco_ctc');
		$edit_cco_id=$this->request->getPost('edit_cco_id');
		$datos_post = http_build_query(
			array(
				"edit_cco_centro_costo"=> $edit_cco_centro_costo,
                "edit_cco_pdv"=> $edit_cco_pdv,
                "edit_cco_ctc"=> $edit_cco_ctc,
                "edit_cco_id"=> $edit_cco_id,
			)
		);//print_r($datos_post);

		$opciones = array('http' =>
			array(
				'method'  => 'POST',	
				'header'  => 'Content-type: application/x-www-form-urlencoded',
				'content' => $datos_post
			)
		);
        $contexto = stream_context_create($opciones);
		$resultado = file_get_contents($this->url_api_conciliacion.'centrocostoactualizar', false, $contexto);
		$resultado=json_decode($resultado,true); print_r($resultado);
		if(!empty($resultado)){
			if($resultado['code'] ==200){
				$session->setFlashdata('mensaje_bueno', 'Editado con exito');
				return redirect()->to(base_url('CentroCosto')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Fallo, al momento de editar');
				return redirect()->to(base_url('CentroCosto')); 
			}

		}else{
			$session->setFlashdata('mensaje_malo', 'respuesta nula');
			return redirect()->to(base_url('CentroCosto')); 
		} 
	}

	public function eliminar($id){
		$session = \Config\Services::session();
		
		$datos_post = http_build_query(
			array(				
				"tip_id"=>$id,
			)
		);

		$opciones = array('http' =>
			array(
				'method'  => 'POST',	
				'header'  => 'Content-type: application/x-www-form-urlencoded',
				'content' => $datos_post
			)
		);

		$contexto = stream_context_create($opciones);
		$resultado = file_get_contents($this->url_api_conciliacion.'tipopagoeliminar', false, $contexto);
		$resultado=json_decode($resultado,true); 
		if(!empty($resultado)){
			if($resultado['code'] ==200){
				$session->setFlashdata('mensaje_bueno', 'Eliminado con exito');
				return redirect()->to(base_url('TipoPago')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Fallo, al momento de eliminar');
				return redirect()->to(base_url('TipoPago')); 
			}

		}else{
			$session->setFlashdata('mensaje_malo', 'respuesta nula');
			return redirect()->to(base_url('TipoPago')); 
		} 
	}
}